/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg.generator;

import gcewing.sg.BaseOrientation;
import gcewing.sg.SGCraft;
import gcewing.sg.block.SGRingBlock;
import gcewing.sg.generator.FeatureGeneration;
import gcewing.sg.generator.GeneratorAddressRegistry;
import gcewing.sg.tileentity.DHDTE;
import gcewing.sg.tileentity.SGBaseTE;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraftforge.fml.common.registry.VillagerRegistry;

public class FeatureJungleTemple
extends StructureComponent {
    StructureComponent base;
    boolean generateStructure = false;
    boolean generateChevronUpgrade = false;
    boolean generateZpmChest = false;
    boolean taintedZpm = false;
    BlockPos centerPos = null;
    int pass = 0;

    protected void func_143011_b(NBTTagCompound compound, TemplateManager templateManager) {
    }

    protected void func_143012_a(NBTTagCompound compound) {
    }

    public FeatureJungleTemple() {
    }

    public FeatureJungleTemple(StructureComponent base) {
        super(0);
        this.base = base;
        Random rand = new Random();
        this.generateStructure = rand.nextInt(100) <= FeatureGeneration.jungleAddonChance;
        this.generateChevronUpgrade = rand.nextInt(100) <= FeatureGeneration.jungleChevronUpgradeChance;
        this.generateZpmChest = rand.nextInt(100) <= FeatureGeneration.jungleZpmChestChance;
        boolean bl = this.taintedZpm = rand.nextInt(100) <= 10;
        if (FeatureGeneration.debugStructures) {
            // empty if block
        }
        StructureBoundingBox baseBox = base.func_74874_b();
        BlockPos boxCenter = new BlockPos(baseBox.field_78897_a + (baseBox.field_78893_d - baseBox.field_78897_a + 1) / 2, baseBox.field_78895_b + (baseBox.field_78894_e - baseBox.field_78895_b + 1) / 2, baseBox.field_78896_c + (baseBox.field_78892_f - baseBox.field_78896_c + 1) / 2);
        int cx = boxCenter.func_177958_n() - 15;
        int cz = boxCenter.func_177952_p();
        int bottom = baseBox.field_78895_b;
        this.centerPos = boxCenter;
        this.field_74887_e = new StructureBoundingBox(cx - 5, bottom, cz - 5, cx + 5, bottom + 7, cz + 8);
        this.func_186164_a(EnumFacing.SOUTH);
    }

    public boolean func_74875_a(World world, Random rand, StructureBoundingBox clip) {
        return this.generateStructure && this.addAugmentationParts(world, rand, clip);
    }

    protected boolean addAugmentationParts(World world, Random rand, StructureBoundingBox clip) {
        IBlockState[] sgRings;
        if (FeatureGeneration.debugStructures) {
            // empty if block
        }
        if (this.base == null) {
            return false;
        }
        StructureBoundingBox box = this.func_74874_b();
        BlockPos boxCenter = new BlockPos(box.field_78897_a + (box.field_78893_d - box.field_78897_a + 1) / 2, box.field_78895_b + (box.field_78894_e - box.field_78895_b + 1) / 2, box.field_78896_c + (box.field_78892_f - box.field_78896_c + 1) / 2);
        BlockPos newYPos = world.func_175672_r(boxCenter);
        clip.field_78895_b = newYPos.func_177956_o() - 1;
        box.field_78895_b = newYPos.func_177956_o() - 1;
        IBlockState air = Blocks.field_150350_a.func_176223_P();
        IBlockState dhd = SGCraft.sgControllerBlock.func_176223_P().func_177226_a(BaseOrientation.Orient4WaysByState.FACING, (Comparable)EnumFacing.NORTH);
        IBlockState sgBase = SGCraft.sgBaseBlock.func_176223_P().func_177226_a(BaseOrientation.Orient4WaysByState.FACING, (Comparable)EnumFacing.NORTH);
        sgRings = new IBlockState[]{SGCraft.sgRingBlock.func_176223_P(), sgRings[0].func_177226_a(SGRingBlock.VARIANT, (Comparable)Integer.valueOf(1))};
        IBlockState chest = Blocks.field_150486_ae.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)EnumFacing.NORTH);
        for (int i = -2; i <= 2; ++i) {
            for (int j = 0; j <= 4; ++j) {
                IBlockState id = i == 0 && j == 0 ? sgBase : (i == -2 || i == 2 || j == 0 || j == 4 ? sgRings[i + j + 1 & 1] : air);
                this.func_175811_a(world, id, 5 + i, 1 + j, 2, clip);
            }
        }
        int baseX = box.field_78897_a + 5;
        int baseY = box.field_78895_b + 1;
        int baseZ = box.field_78896_c + 2;
        SGBaseTE te = (SGBaseTE)world.func_175625_s(new BlockPos(baseX, baseY, baseZ));
        if (FeatureGeneration.debugStructures) {
            System.out.println("Jungle Temple Stargate built at: " + baseX + "/" + baseY + "/" + baseZ);
        }
        if (te != null) {
            if (this.generateChevronUpgrade) {
                te.hasChevronUpgrade = true;
                if (FeatureGeneration.debugStructures) {
                    System.out.println("Jungle Temple Stargate at: [" + baseX + "/" + baseY + "/" + baseZ + "] granted chevron upgrade.");
                }
            }
            ItemStack grassBlock = new ItemStack((Block)Blocks.field_150349_c, 1, 0);
            te.getInventory().func_70299_a(0, grassBlock.func_77946_l());
            te.getInventory().func_70299_a(1, grassBlock.func_77946_l());
            te.getInventory().func_70299_a(2, grassBlock.func_77946_l());
            te.getInventory().func_70299_a(3, grassBlock.func_77946_l());
            te.getInventory().func_70299_a(4, grassBlock.func_77946_l());
            te.markChanged();
            if (te.homeAddress == null) {
                te.setMerged(true);
            }
            if (te.homeAddress != null) {
                GeneratorAddressRegistry.addAddress(te.func_145831_w(), te.homeAddress);
            } else {
                System.err.println("Something bad happened!!! please report to Dockter:  Error 1");
            }
        }
        this.func_175811_a(world, dhd, 5, 1, 7, clip);
        int dhdX = box.field_78897_a + 5;
        int dhdY = box.field_78895_b + 1;
        int dhdZ = box.field_78896_c + 7;
        DHDTE dhdte = (DHDTE)world.func_175625_s(new BlockPos(dhdX, dhdY, dhdZ));
        if (dhdte != null) {
            ItemStack naquadahPieces = new ItemStack(SGCraft.naquadah, 3);
            dhdte.getInventory().func_70299_a(0, naquadahPieces);
        }
        int chestX = box.field_78897_a + 8;
        int chestY = box.field_78895_b + 1;
        int chestZ = box.field_78896_c + 2;
        BlockPos chestPos = new BlockPos(chestX, chestY, chestZ);
        if (this.generateZpmChest) {
            if (SGCraft.zpm == null) {
                return true;
            }
            if (world.func_180495_p(chestPos).func_177230_c() != Blocks.field_150486_ae) {
                this.func_175811_a(world, chest, 8, 1, 2, clip);
                TileEntityChest chestTE = (TileEntityChest)world.func_175625_s(chestPos);
                if (chestTE != null) {
                    ItemStack zpm;
                    if (FeatureGeneration.debugStructures) {
                        System.out.println("Generating ZPM Chest at: " + chestPos);
                    }
                    if ((zpm = new ItemStack(SGCraft.zpm, 1)) != null) {
                        NBTTagCompound tag = zpm.func_77978_p();
                        if (tag == null) {
                            tag = new NBTTagCompound();
                        }
                        zpm.func_77982_d(tag);
                        tag.func_74780_a("AvailableEnergy", 2.147483647E9);
                        tag.func_74757_a("loadedIntoCart", false);
                    }
                    if (this.taintedZpm) {
                        zpm.func_77966_a(Enchantment.func_185262_c((int)51), 1);
                    }
                    chestTE.getSingleChestHandler().insertItem(0, zpm, false);
                }
            }
        }
        if (FeatureGeneration.jungleSpawnTokra && this.pass == 0) {
            EntityVillager entityvillager = new EntityVillager(world);
            entityvillager.func_70012_b((double)chestX + 0.5, (double)chestY + 2.0, (double)chestZ + 0.5, 0.0f, 0.0f);
            entityvillager.func_70938_b(VillagerRegistry.getId((VillagerRegistry.VillagerProfession)SGCraft.tokraProfession));
            entityvillager.func_190672_a(world.func_175649_E(new BlockPos((Entity)entityvillager)), (IEntityLivingData)null, false);
            world.func_72838_d((Entity)entityvillager);
        }
        ++this.pass;
        return true;
    }
}

