/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.parser.generator;

import cofh.cofhworld.init.WorldProps;
import cofh.cofhworld.parser.IGeneratorParser;
import cofh.cofhworld.parser.variables.BlockData;
import cofh.cofhworld.parser.variables.EnumData;
import cofh.cofhworld.parser.variables.NumberData;
import cofh.cofhworld.parser.variables.StringData;
import cofh.cofhworld.util.random.WeightedBlock;
import cofh.cofhworld.util.random.WeightedEnum;
import cofh.cofhworld.util.random.WeightedNBTTag;
import cofh.cofhworld.util.random.WeightedString;
import cofh.cofhworld.world.generator.WorldGenStructure;
import cofh.shade.com.typesafe.config.Config;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.world.gen.feature.WorldGenerator;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Logger;

public class GenParserStructure
implements IGeneratorParser {
    protected static ArrayList<WeightedEnum<Rotation>> ALL_ROTATION = Lists.newArrayList((Object[])new WeightedEnum[]{new WeightedEnum<Rotation>(Rotation.NONE, 1), new WeightedEnum<Rotation>(Rotation.CLOCKWISE_90, 1), new WeightedEnum<Rotation>(Rotation.CLOCKWISE_180, 1), new WeightedEnum<Rotation>(Rotation.COUNTERCLOCKWISE_90, 1)});
    protected static ArrayList<WeightedEnum<Mirror>> NO_MIRROR = new ArrayList();
    private static String[] FIELDS = new String[]{"structure"};

    @Override
    public String[] getRequiredFields() {
        return FIELDS;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nonnull
    public WorldGenerator parseGenerator(String name, Config genObject, Logger log, List<WeightedBlock> resList, List<WeightedBlock> matList) throws IGeneratorParser.InvalidGeneratorException {
        ArrayList<WeightedNBTTag> tags = new ArrayList<WeightedNBTTag>();
        if (!genObject.hasPath("structure")) {
            log.error("Tag `structure` missing for `structure` generator!");
            throw new IGeneratorParser.InvalidGeneratorException("Missing `structure` tag", genObject.origin());
        }
        ArrayList<WeightedString> files = new ArrayList<WeightedString>();
        String dir = FilenameUtils.getFullPath((String)genObject.origin().filename());
        if (!StringData.parseStringList(genObject.getValue("structure"), files)) {
            log.error("Tag `structure` invalid!");
            throw new IGeneratorParser.InvalidGeneratorException("Invalid `structure` tag", genObject.getValue("structure").origin());
        }
        if (files.size() == 0) {
            log.error("No structures provided for `structure` geenrator!");
            throw new IGeneratorParser.InvalidGeneratorException("Empty `structure` array", genObject.getValue("structure").origin());
        }
        tags.ensureCapacity(files.size());
        for (WeightedString file : files) {
            String path = FilenameUtils.normalize((String)(dir + file.value));
            try {
                if (!FilenameUtils.directoryContains((String)WorldProps.cannonicalWorldGenDir, (String)path)) {
                    throw new IGeneratorParser.InvalidGeneratorException("Structure NBT file not contained in worldgen folder", genObject.getValue("structure").origin());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                FileInputStream stream = new FileInputStream(new File(path));
                tags.add(new WeightedNBTTag(file.field_76292_a, (NBTBase)CompressedStreamTools.func_74796_a((InputStream)stream)));
                IOUtils.closeQuietly((InputStream)stream);
            }
            catch (IOException e) {
                throw new IGeneratorParser.InvalidGeneratorException("Structure NBT file cannot be read.", genObject.getValue("structure").origin()).causedBy(e);
            }
        }
        resList.clear();
        if (genObject.hasPath("ignored-block") && !BlockData.parseBlockList(genObject.getValue("ignored-block"), resList, false)) {
            log.warn("Error parsing `ignored-block`, generating all template blocks instead");
            resList.clear();
        }
        boolean ignoreEntities = false;
        if (genObject.hasPath("ignore-entities")) {
            ignoreEntities = genObject.getBoolean("ignore-entities");
        }
        WorldGenStructure gen = new WorldGenStructure(tags, resList, ignoreEntities);
        if (genObject.hasPath("integrity")) {
            gen.setIntegrity(NumberData.parseNumberValue(genObject.getValue("integrity"), 0.0, 1.01));
        }
        ArrayList rots = ALL_ROTATION;
        if (genObject.hasPath("rotation")) {
            rots = new ArrayList(4);
            if (!EnumData.parseEnumList(genObject.getValue("rotation"), rots, Rotation.class)) {
                rots.clear();
            }
        }
        ArrayList mirror = NO_MIRROR;
        if (genObject.hasPath("mirror")) {
            mirror = new ArrayList(3);
            if (!EnumData.parseEnumList(genObject.getValue("mirror"), mirror, Mirror.class)) {
                mirror.clear();
            }
        }
        gen.setDetails(rots, mirror);
        return gen;
    }

    @Override
    public boolean isMeta() {
        return true;
    }
}

