/*
 * Decompiled with CFR 0.152.
 */
package nc.block;

import javax.annotation.Nullable;
import nc.block.item.IMetaBlockName;
import nc.enumm.IBlockMeta;
import nc.enumm.MetaEnums;
import nc.tab.NCTabs;
import nc.util.CollectionHelper;
import nc.util.ItemStackHelper;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockMeta<T extends Enum<T> & IBlockMeta>
extends Block
implements IMetaBlockName {
    public final T[] values;
    public final PropertyEnum type;
    protected boolean canCreatureSpawn = true;

    public BlockMeta(Class<T> enumm, PropertyEnum property, Material material) {
        super(material);
        this.values = (Enum[])enumm.getEnumConstants();
        this.type = property;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)this.type, this.values[0]));
        this.setMetaHarvestLevels();
        this.func_149711_c(2.0f);
        this.func_149752_b(15.0f);
    }

    public void setMetaHarvestLevels() {
        for (Enum nextState : CollectionHelper.asList(this.values)) {
            this.setHarvestLevel(((IBlockMeta)((Object)nextState)).getHarvestTool(), ((IBlockMeta)((Object)nextState)).getHarvestLevel(), this.func_176203_a(((IBlockMeta)((Object)nextState)).getID()));
        }
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return ((IBlockMeta)((Object)((Enum)((Object)state.func_177229_b((IProperty)this.type))))).getLightValue();
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        return ((IBlockMeta)((Object)((Enum)((Object)state.func_177229_b((IProperty)this.type))))).getHardness();
    }

    public float getExplosionResistance(World world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        return ((IBlockMeta)((Object)((Enum)((Object)world.func_180495_p(pos).func_177229_b((IProperty)this.type))))).getResistance();
    }

    public int func_176201_c(IBlockState state) {
        return ((IBlockMeta)((Object)((Enum)((Object)state.func_177229_b((IProperty)this.type))))).getID();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)this.type, this.values[meta]);
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (int i = 0; i < this.values.length; ++i) {
            list.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(Item.func_150898_a((Block)this), 1, this.func_176201_c(state));
    }

    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return this.canCreatureSpawn && super.canCreatureSpawn(state, world, pos, type);
    }

    @Override
    public String getSpecialName(ItemStack stack) {
        return ((IStringSerializable)this.values[ItemStackHelper.getMetadata(stack)]).func_176610_l();
    }

    public static class BlockCooler
    extends BlockMeta<MetaEnums.CoolerType> {
        public static final PropertyEnum TYPE = PropertyEnum.func_177709_a((String)"type", MetaEnums.CoolerType.class);

        public BlockCooler() {
            super(MetaEnums.CoolerType.class, TYPE, Material.field_151573_f);
            this.func_149647_a(NCTabs.FISSION_BLOCKS);
            this.canCreatureSpawn = false;
        }

        protected BlockStateContainer func_180661_e() {
            return new BlockStateContainer((Block)this, new IProperty[]{TYPE});
        }
    }

    public static class BlockFission
    extends BlockMeta<MetaEnums.FissionBlockType> {
        public static final PropertyEnum TYPE = PropertyEnum.func_177709_a((String)"type", MetaEnums.FissionBlockType.class);

        public BlockFission() {
            super(MetaEnums.FissionBlockType.class, TYPE, Material.field_151573_f);
            this.func_149647_a(NCTabs.FISSION_BLOCKS);
            this.canCreatureSpawn = false;
        }

        protected BlockStateContainer func_180661_e() {
            return new BlockStateContainer((Block)this, new IProperty[]{TYPE});
        }
    }

    public static class BlockIngot
    extends BlockMeta<MetaEnums.IngotType> {
        public static final PropertyEnum TYPE = PropertyEnum.func_177709_a((String)"type", MetaEnums.IngotType.class);

        public BlockIngot() {
            super(MetaEnums.IngotType.class, TYPE, Material.field_151573_f);
            this.func_149647_a(NCTabs.BASE_BLOCK_MATERIALS);
        }

        protected BlockStateContainer func_180661_e() {
            return new BlockStateContainer((Block)this, new IProperty[]{TYPE});
        }

        public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
            return ((MetaEnums.IngotType)((Object)world.func_180495_p(pos).func_177229_b((IProperty)this.type))).getFireSpreadSpeed();
        }

        public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
            return ((MetaEnums.IngotType)((Object)world.func_180495_p(pos).func_177229_b((IProperty)this.type))).getFlammability();
        }

        public boolean isFireSource(World world, BlockPos pos, EnumFacing side) {
            return ((MetaEnums.IngotType)((Object)world.func_180495_p(pos).func_177229_b((IProperty)this.type))).isFireSource();
        }
    }

    public static class BlockOre
    extends BlockMeta<MetaEnums.OreType> {
        public static final PropertyEnum TYPE = PropertyEnum.func_177709_a((String)"type", MetaEnums.OreType.class);

        public BlockOre() {
            super(MetaEnums.OreType.class, TYPE, Material.field_151576_e);
            this.func_149647_a(NCTabs.BASE_BLOCK_MATERIALS);
        }

        protected BlockStateContainer func_180661_e() {
            return new BlockStateContainer((Block)this, new IProperty[]{TYPE});
        }

        @SideOnly(value=Side.CLIENT)
        public BlockRenderLayer func_180664_k() {
            return BlockRenderLayer.CUTOUT;
        }
    }
}

