/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.compat.jei;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.function.Supplier;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.thirteen.Context;
import mcjty.lib.varia.ItemStackList;
import mcjty.rftools.blocks.storage.ModularStorageItemContainer;
import mcjty.rftools.blocks.storage.ModularStorageSetup;
import mcjty.rftools.blocks.storage.RemoteStorageItemContainer;
import mcjty.rftools.blocks.storagemonitor.StorageScannerContainer;
import mcjty.rftools.compat.jei.JEIRecipeAcceptor;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketSendRecipe
implements IMessage {
    private ItemStackList stacks;
    private BlockPos pos;

    public void fromBytes(ByteBuf buf) {
        int l = buf.readInt();
        this.stacks = ItemStackList.create((int)l);
        for (int i = 0; i < l; ++i) {
            if (buf.readBoolean()) {
                this.stacks.set(i, (Object)NetworkTools.readItemStack((ByteBuf)buf));
                continue;
            }
            this.stacks.set(i, (Object)ItemStack.field_190927_a);
        }
        this.pos = buf.readBoolean() ? NetworkTools.readPos((ByteBuf)buf) : null;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.stacks.size());
        for (ItemStack stack : this.stacks) {
            if (!stack.func_190926_b()) {
                buf.writeBoolean(true);
                NetworkTools.writeItemStack((ByteBuf)buf, (ItemStack)stack);
                continue;
            }
            buf.writeBoolean(false);
        }
        if (this.pos != null) {
            buf.writeBoolean(true);
            NetworkTools.writePos((ByteBuf)buf, (BlockPos)this.pos);
        } else {
            buf.writeBoolean(false);
        }
    }

    public PacketSendRecipe() {
    }

    public PacketSendRecipe(ByteBuf buf) {
        this.fromBytes(buf);
    }

    public PacketSendRecipe(ItemStackList stacks, BlockPos pos) {
        this.stacks = stacks;
        this.pos = pos;
    }

    public void handle(Supplier<Context> supplier) {
        Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            EntityPlayerMP player = ctx.getSender();
            World world = player.func_130014_f_();
            if (this.pos == null) {
                ItemStack mainhand = player.func_184614_ca();
                if (!mainhand.func_190926_b() && mainhand.func_77973_b() == ModularStorageSetup.storageModuleTabletItem) {
                    if (player.field_71070_bA instanceof ModularStorageItemContainer) {
                        ModularStorageItemContainer storageItemContainer = (ModularStorageItemContainer)player.field_71070_bA;
                        storageItemContainer.getJEIRecipeAcceptor().setGridContents((List<ItemStack>)this.stacks);
                    } else if (player.field_71070_bA instanceof RemoteStorageItemContainer) {
                        RemoteStorageItemContainer storageItemContainer = (RemoteStorageItemContainer)player.field_71070_bA;
                        storageItemContainer.getJEIRecipeAcceptor().setGridContents((List<ItemStack>)this.stacks);
                    } else if (player.field_71070_bA instanceof StorageScannerContainer) {
                        StorageScannerContainer storageItemContainer = (StorageScannerContainer)player.field_71070_bA;
                        storageItemContainer.getStorageScannerTileEntity().setGridContents((List<ItemStack>)this.stacks);
                    }
                }
            } else {
                TileEntity te = world.func_175625_s(this.pos);
                if (te instanceof JEIRecipeAcceptor) {
                    JEIRecipeAcceptor acceptor = (JEIRecipeAcceptor)te;
                    acceptor.setGridContents((List<ItemStack>)this.stacks);
                }
            }
        });
        ctx.setPacketHandled(true);
    }
}

