/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.semiblock;

import java.util.List;
import me.desht.pneumaticcraft.common.GuiHandler;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.IDescSynced;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.NetworkUtils;
import me.desht.pneumaticcraft.common.network.PacketDescription;
import me.desht.pneumaticcraft.common.network.SyncedField;
import me.desht.pneumaticcraft.common.semiblock.ISemiBlock;
import me.desht.pneumaticcraft.common.semiblock.ItemSemiBlockBase;
import me.desht.pneumaticcraft.common.semiblock.SemiBlockManager;
import me.desht.pneumaticcraft.common.tileentity.IGUIButtonSensitive;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class SemiBlockBasic<TTileEntity extends TileEntity>
implements ISemiBlock,
IDescSynced,
IGUIButtonSensitive {
    private final Class<TTileEntity> tileClass;
    protected World world;
    protected BlockPos pos;
    private int index = -1;
    private boolean isInvalid;
    private TTileEntity cachedTE;
    private List<SyncedField> descriptionFields;
    private boolean descriptionPacketScheduled;

    public SemiBlockBasic(Class<TTileEntity> tileClass) {
        this.tileClass = tileClass;
    }

    @Override
    public void initialize(World world, BlockPos pos) {
        this.world = world;
        this.pos = pos;
    }

    @Override
    public int getIndex() {
        if (this.index == -1) {
            this.index = SemiBlockManager.getInstance(this.world).getSemiBlocksAsList(this.world, this.getPos()).indexOf(this);
            if (this.index == -1) {
                throw new IllegalStateException("Semi block is not part of the world! " + this);
            }
        }
        return this.index;
    }

    @Override
    public void onSemiBlockRemovedFromThisPos(ISemiBlock semiBlock) {
        this.index = -1;
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
    }

    @Override
    public void update() {
        if (!this.world.field_72995_K && !this.canStay()) {
            this.drop();
        }
        if (!this.world.field_72995_K && !this.isInvalid()) {
            if (this.descriptionFields == null) {
                this.descriptionPacketScheduled = true;
            }
            for (SyncedField field : this.getDescriptionFields()) {
                if (!field.update()) continue;
                this.descriptionPacketScheduled = true;
            }
            if (this.descriptionPacketScheduled) {
                this.descriptionPacketScheduled = false;
                this.sendDescriptionPacket();
            }
        }
    }

    private void sendDescriptionPacket() {
        NetworkHandler.sendToAllAround(this.getDescriptionPacket(), this.world);
    }

    @Override
    public PacketDescription getDescriptionPacket() {
        return new PacketDescription(this);
    }

    @Override
    public BlockPos getPosition() {
        return this.getPos();
    }

    protected void drop() {
        SemiBlockManager.getInstance(this.world).breakSemiBlock(this);
    }

    protected boolean isAirBlock() {
        return this.world.func_175623_d(this.pos);
    }

    public IBlockState getBlockState() {
        return this.world.func_180495_p(this.pos);
    }

    public boolean isAir() {
        IBlockState state = this.getBlockState();
        return state.func_177230_c().isAir(state, (IBlockAccess)this.world, this.pos);
    }

    public TTileEntity getTileEntity() {
        if (this.cachedTE == null || this.cachedTE.func_145837_r()) {
            TileEntity te = this.world.func_175625_s(this.pos);
            this.cachedTE = te != null && this.tileClass.isAssignableFrom(te.getClass()) ? te : null;
        }
        return this.cachedTE;
    }

    @Override
    public void invalidate() {
        this.isInvalid = true;
    }

    @Override
    public boolean isInvalid() {
        return this.isInvalid;
    }

    @Override
    public World getWorld() {
        return this.world;
    }

    @Override
    public BlockPos getPos() {
        return this.pos;
    }

    @Override
    public void addDrops(NonNullList<ItemStack> drops) {
        ItemSemiBlockBase item = SemiBlockManager.getItemForSemiBlock(this);
        if (item != null) {
            drops.add((Object)new ItemStack((Item)item));
        }
    }

    @Override
    public boolean canPlace(EnumFacing facing) {
        return true;
    }

    @Override
    public void prePlacement(EntityPlayer player, ItemStack stack, EnumFacing facing) {
    }

    @Override
    public void onPlaced(EntityPlayer player, ItemStack stack, EnumFacing facing) {
    }

    public boolean canStay() {
        return this.canPlace(null);
    }

    @Override
    public boolean onRightClickWithConfigurator(EntityPlayer player, EnumFacing side) {
        return false;
    }

    @Override
    public GuiHandler.EnumGuiId getGuiID() {
        return null;
    }

    public void addTooltip(List<String> curInfo, NBTTagCompound tag, boolean extended) {
    }

    public void addWailaInfoToTag(NBTTagCompound tag) {
    }

    @Override
    public IDescSynced.Type getSyncType() {
        return IDescSynced.Type.SEMI_BLOCK;
    }

    @Override
    public List<SyncedField> getDescriptionFields() {
        if (this.descriptionFields == null) {
            this.descriptionFields = NetworkUtils.getSyncedFields(this, DescSynced.class);
            for (SyncedField field : this.descriptionFields) {
                field.update();
            }
        }
        return this.descriptionFields;
    }

    @Override
    public void writeToPacket(NBTTagCompound tag) {
        tag.func_74774_a("index", (byte)this.getIndex());
    }

    @Override
    public void readFromPacket(NBTTagCompound tag) {
    }

    @Override
    public void onDescUpdate() {
    }

    @Override
    public void handleGUIButtonPress(int guiID, EntityPlayer player) {
    }

    public String toString() {
        return String.format("Pos: %s, %s", this.getPos(), this.getClass());
    }
}

