/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.network;

import io.netty.buffer.ByteBuf;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.tile.TileTerraPlate;
import vazkii.botania.common.core.helper.Vector3;
import vazkii.botania.common.item.ItemTwigWand;

public class PacketBotaniaEffect
implements IMessage {
    private EffectType type;
    private double x;
    private double y;
    private double z;
    private int[] args;

    public PacketBotaniaEffect() {
    }

    public PacketBotaniaEffect(EffectType type, double x, double y, double z, int ... args) {
        this.type = type;
        this.x = x;
        this.y = y;
        this.z = z;
        this.args = args;
    }

    public void fromBytes(ByteBuf buf) {
        this.type = EffectType.values()[buf.readByte()];
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
        this.args = new int[this.type.argCount];
        for (int i = 0; i < this.args.length; ++i) {
            this.args[i] = ByteBufUtils.readVarInt((ByteBuf)buf, (int)5);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte(this.type.ordinal());
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        for (int i = 0; i < this.type.argCount; ++i) {
            ByteBufUtils.writeVarInt((ByteBuf)buf, (int)this.args[i], (int)5);
        }
    }

    public static enum EffectType {
        PAINT_LENS(1),
        ARENA_INDICATOR(0),
        ITEM_SMOKE(2),
        SPARK_NET_INDICATOR(2),
        SPARK_MANA_FLOW(2),
        ENCHANTER_DESTROY(0),
        BLACK_LOTUS_DISSOLVE(0),
        TERRA_PLATE(0),
        FLUGEL_EFFECT(1),
        PARTICLE_BEAM(3),
        DIVA_EFFECT(1);

        private final int argCount;

        private EffectType(int argCount) {
            this.argCount = argCount;
        }
    }

    public static class Handler
    implements IMessageHandler<PacketBotaniaEffect, IMessage> {
        public IMessage onMessage(final PacketBotaniaEffect message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(new Runnable(){

                @Override
                public void run() {
                    Minecraft mc = Minecraft.func_71410_x();
                    WorldClient world = mc.field_71441_e;
                    switch (message.type) {
                        case PAINT_LENS: {
                            EnumDyeColor placeColor = EnumDyeColor.func_176764_b((int)message.args[0]);
                            int hex = placeColor.func_193350_e();
                            int r = (hex & 0xFF0000) >> 16;
                            int g = (hex & 0xFF00) >> 8;
                            int b = hex & 0xFF;
                            for (int i = 0; i < 10; ++i) {
                                BlockPos pos = new BlockPos(message.x, message.y, message.z).func_177972_a(EnumFacing.field_82609_l[world.field_73012_v.nextInt(6)]);
                                Botania.proxy.sparkleFX((float)pos.func_177958_n() + (float)Math.random(), (float)pos.func_177956_o() + (float)Math.random(), (float)pos.func_177952_p() + (float)Math.random(), (float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, 0.6f + (float)Math.random() * 0.5f, 5);
                            }
                            break;
                        }
                        case ARENA_INDICATOR: {
                            for (int i = 0; i < 360; i += 8) {
                                float r = 1.0f;
                                float g = 0.0f;
                                float b = 1.0f;
                                float rad = (float)i * (float)Math.PI / 180.0f;
                                double x = message.x + 0.5 - Math.cos(rad) * 12.0;
                                double y = message.y + 0.5;
                                double z = message.z + 0.5 - Math.sin(rad) * 12.0;
                                Botania.proxy.sparkleFX(x, y, z, r, g, b, 5.0f, 120);
                            }
                            break;
                        }
                        case ITEM_SMOKE: {
                            Entity item = world.func_73045_a(message.args[0]);
                            if (item == null) {
                                return;
                            }
                            int p = message.args[1];
                            for (int i = 0; i < p; ++i) {
                                double m = 0.01;
                                double d0 = item.field_70170_p.field_73012_v.nextGaussian() * m;
                                double d1 = item.field_70170_p.field_73012_v.nextGaussian() * m;
                                double d2 = item.field_70170_p.field_73012_v.nextGaussian() * m;
                                double d3 = 10.0;
                                item.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, message.x + (double)(item.field_70170_p.field_73012_v.nextFloat() * item.field_70130_N * 2.0f) - (double)item.field_70130_N - d0 * d3, message.y + (double)(item.field_70170_p.field_73012_v.nextFloat() * item.field_70131_O) - d1 * d3, message.z + (double)(item.field_70170_p.field_73012_v.nextFloat() * item.field_70130_N * 2.0f) - (double)item.field_70130_N - d2 * d3, d0, d1, d2, new int[0]);
                            }
                            break;
                        }
                        case SPARK_NET_INDICATOR: {
                            Entity e1 = world.func_73045_a(message.args[0]);
                            Entity e2 = world.func_73045_a(message.args[1]);
                            if (e1 == null || e2 == null) {
                                return;
                            }
                            Vector3 orig = new Vector3(e1.field_70165_t, e1.field_70163_u + 0.25, e1.field_70161_v);
                            Vector3 end = new Vector3(e2.field_70165_t, e2.field_70163_u + 0.25, e2.field_70161_v);
                            Vector3 diff = end.subtract(orig);
                            Vector3 movement = diff.normalize().multiply(0.1);
                            int iters = (int)(diff.mag() / movement.mag());
                            float huePer = 1.0f / (float)iters;
                            float hueSum = (float)Math.random();
                            Vector3 currentPos = orig;
                            for (int i = 0; i < iters; ++i) {
                                float hue = (float)i * huePer + hueSum;
                                Color color = Color.getHSBColor(hue, 1.0f, 1.0f);
                                float r = Math.min(1.0f, (float)color.getRed() / 255.0f + 0.4f);
                                float g = Math.min(1.0f, (float)color.getGreen() / 255.0f + 0.4f);
                                float b = Math.min(1.0f, (float)color.getBlue() / 255.0f + 0.4f);
                                Botania.proxy.setSparkleFXNoClip(true);
                                Botania.proxy.sparkleFX(currentPos.x, currentPos.y, currentPos.z, r, g, b, 1.0f, 12);
                                Botania.proxy.setSparkleFXNoClip(false);
                                currentPos = currentPos.add(movement);
                            }
                            break;
                        }
                        case SPARK_MANA_FLOW: {
                            Entity e1 = world.func_73045_a(message.args[0]);
                            Entity e2 = world.func_73045_a(message.args[1]);
                            if (e1 == null || e2 == null) {
                                return;
                            }
                            double rc = 0.45;
                            Vector3 thisVec = Vector3.fromEntityCenter(e1).add((Math.random() - 0.5) * rc, (Math.random() - 0.5) * rc, (Math.random() - 0.5) * rc);
                            Vector3 receiverVec = Vector3.fromEntityCenter(e2).add((Math.random() - 0.5) * rc, (Math.random() - 0.5) * rc, (Math.random() - 0.5) * rc);
                            Vector3 motion = receiverVec.subtract(thisVec).multiply(0.04f);
                            float r = 0.4f + 0.3f * (float)Math.random();
                            float g = 0.4f + 0.3f * (float)Math.random();
                            float b = 0.4f + 0.3f * (float)Math.random();
                            float size = 0.125f + 0.125f * (float)Math.random();
                            Botania.proxy.wispFX(thisVec.x, thisVec.y, thisVec.z, r, g, b, size, (float)motion.x, (float)motion.y, (float)motion.z);
                            break;
                        }
                        case ENCHANTER_DESTROY: {
                            for (int i = 0; i < 50; ++i) {
                                float red = (float)Math.random();
                                float green = (float)Math.random();
                                float blue = (float)Math.random();
                                Botania.proxy.wispFX(message.x, message.y, message.z, red, green, blue, (float)Math.random() * 0.15f + 0.15f, (float)(Math.random() - 0.5) * 0.25f, (float)(Math.random() - 0.5) * 0.25f, (float)(Math.random() - 0.5) * 0.25f);
                            }
                            break;
                        }
                        case BLACK_LOTUS_DISSOLVE: {
                            for (int i = 0; i < 50; ++i) {
                                float r = (float)Math.random() * 0.35f;
                                float g = 0.0f;
                                float b = (float)Math.random() * 0.35f;
                                float s = 0.45f * (float)Math.random() * 0.25f;
                                float m = 0.045f;
                                float mx = ((float)Math.random() - 0.5f) * m;
                                float my = (float)Math.random() * m;
                                float mz = ((float)Math.random() - 0.5f) * m;
                                Botania.proxy.wispFX(message.x, message.y, message.z, r, g, b, s, mx, my, mz);
                            }
                            break;
                        }
                        case TERRA_PLATE: {
                            TileEntity te = world.func_175625_s(new BlockPos(message.x, message.y, message.z));
                            if (!(te instanceof TileTerraPlate)) break;
                            int ticks = (int)(100.0 * ((double)((TileTerraPlate)te).getCurrentMana() / 500000.0));
                            int totalSpiritCount = 3;
                            double tickIncrement = 360.0 / (double)totalSpiritCount;
                            int speed = 5;
                            double wticks = (double)(ticks * speed) - tickIncrement;
                            double r = Math.sin((double)(ticks - 100) / 10.0) * 2.0;
                            double g = Math.sin(wticks * Math.PI / 180.0 * 0.55);
                            for (int i = 0; i < totalSpiritCount; ++i) {
                                double x = message.x + Math.sin(wticks * Math.PI / 180.0) * r + 0.5;
                                double y = message.y + 0.25 + Math.abs(r) * 0.7;
                                double z = message.z + Math.cos(wticks * Math.PI / 180.0) * r + 0.5;
                                wticks += tickIncrement;
                                float[] colorsfx = new float[]{0.0f, (float)ticks / 100.0f, 1.0f - (float)ticks / 100.0f};
                                Botania.proxy.wispFX(x, y, z, colorsfx[0], colorsfx[1], colorsfx[2], 0.85f, (float)g * 0.05f, 0.25f);
                                Botania.proxy.wispFX(x, y, z, colorsfx[0], colorsfx[1], colorsfx[2], (float)Math.random() * 0.1f + 0.1f, (float)(Math.random() - 0.5) * 0.05f, (float)(Math.random() - 0.5) * 0.05f, (float)(Math.random() - 0.5) * 0.05f, 0.9f);
                                if (ticks != 100) continue;
                                for (int j = 0; j < 15; ++j) {
                                    Botania.proxy.wispFX(message.x + 0.5, message.y + 0.5, message.z + 0.5, colorsfx[0], colorsfx[1], colorsfx[2], (float)Math.random() * 0.15f + 0.15f, (float)(Math.random() - 0.5) * 0.125f, (float)(Math.random() - 0.5) * 0.125f, (float)(Math.random() - 0.5) * 0.125f);
                                }
                            }
                            break;
                        }
                        case FLUGEL_EFFECT: {
                            Entity entity = world.func_73045_a(message.args[0]);
                            if (entity == null) break;
                            for (int i = 0; i < 15; ++i) {
                                float x = (float)(entity.field_70165_t + Math.random());
                                float y = (float)(entity.field_70163_u + Math.random());
                                float z = (float)(entity.field_70161_v + Math.random());
                                Botania.proxy.wispFX(x, y, z, (float)Math.random(), (float)Math.random(), (float)Math.random(), (float)Math.random(), -0.3f + (float)Math.random() * 0.2f);
                            }
                            break;
                        }
                        case PARTICLE_BEAM: {
                            ItemTwigWand.doParticleBeam((World)Minecraft.func_71410_x().field_71441_e, new Vector3(message.x, message.y, message.z), new Vector3((double)message.args[0] + 0.5, (double)message.args[1] + 0.5, (double)message.args[2] + 0.5));
                            break;
                        }
                        case DIVA_EFFECT: {
                            Entity target = Minecraft.func_71410_x().field_71441_e.func_73045_a(message.args[0]);
                            if (target == null) break;
                            double x = target.field_70165_t;
                            double y = target.field_70163_u;
                            double z = target.field_70161_v;
                            for (int i = 0; i < 50; ++i) {
                                Botania.proxy.sparkleFX(x + Math.random() * (double)target.field_70130_N, y + Math.random() * (double)target.field_70131_O, z + Math.random() * (double)target.field_70130_N, 1.0f, 1.0f, 0.25f, 1.0f, 3);
                            }
                            break;
                        }
                    }
                }
            });
            return null;
        }
    }
}

