/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.tileentity;

import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import lumien.randomthings.config.Numbers;
import lumien.randomthings.tileentity.TileEntityBase;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class TileEntityRainShield
extends TileEntityBase {
    public static Set<TileEntityRainShield> shields = Collections.newSetFromMap(new WeakHashMap());
    public static ConcurrentHashMap<BlockPos, Boolean> rainCache = new ConcurrentHashMap();
    STATE state;
    int currentRange;
    boolean active = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TileEntityRainShield() {
        Set<TileEntityRainShield> set = shields;
        synchronized (set) {
            shields.add(this);
        }
        this.state = STATE.INACTIVE;
    }

    @Override
    public void writeDataToNBT(NBTTagCompound compound, boolean sync) {
        compound.func_74757_a("active", this.active);
    }

    @Override
    public void readDataFromNBT(NBTTagCompound compound, boolean sync) {
        this.active = !compound.func_74764_b("active") ? true : compound.func_74767_n("active");
    }

    @Override
    public boolean syncAdditionalData() {
        return true;
    }

    public void onChunkUnload() {
        this.func_145843_s();
    }

    @Override
    public void breakBlock(World worldIn, BlockPos pos, IBlockState state) {
        super.breakBlock(worldIn, pos, state);
        this.func_145843_s();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean shouldRain(World world, BlockPos pos) {
        Boolean cachedValue = rainCache.get(pos);
        if (cachedValue != null) {
            return cachedValue;
        }
        Set<TileEntityRainShield> set = shields;
        synchronized (set) {
            for (TileEntityRainShield rainShield : shields) {
                if (!rainShield.active || rainShield.field_145850_b != world || rainShield.func_145837_r() || !(rainShield.func_174877_v().func_177982_a(0, -rainShield.func_174877_v().func_177956_o(), 0).func_177951_i((Vec3i)pos) < (double)(Numbers.RAIN_SHIELD_RANGE * Numbers.RAIN_SHIELD_RANGE))) continue;
                rainCache.put(pos, Boolean.FALSE);
                return false;
            }
        }
        rainCache.put(pos, Boolean.TRUE);
        return true;
    }

    public void onBlockAdded(World worldIn, BlockPos pos, IBlockState state) {
        this.active = worldIn.func_175687_A(pos) <= 0;
    }

    @Override
    public void neighborChanged(IBlockState state2, World worldIn, BlockPos pos, Block neighborBlock, BlockPos changedPos) {
        boolean desiredState;
        boolean bl = desiredState = worldIn.func_175687_A(pos) <= 0;
        if (desiredState != this.active) {
            this.active = desiredState;
            this.syncTE();
        }
    }

    static enum STATE {
        INACTIVE,
        ACTIVATING,
        ACTIVE;

    }
}

