/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets;

import java.util.ArrayList;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.planets.GalacticraftPlanets;
import micdoodle8.mods.galacticraft.planets.IPlanetsModule;
import micdoodle8.mods.galacticraft.planets.IPlanetsModuleClient;
import micdoodle8.mods.galacticraft.planets.venus.tick.VenusTickHandlerServer;
import micdoodle8.mods.galacticraft.planets.venus.tile.SolarModuleNetwork;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.relauncher.Side;

public class PlanetsProxy
implements IGuiHandler {
    public void preInit(FMLPreInitializationEvent event) {
        for (IPlanetsModule module : GalacticraftPlanets.commonModules) {
            module.preInit(event);
        }
    }

    public void registerVariants() {
    }

    public void init(FMLInitializationEvent event) {
        for (IPlanetsModule module : GalacticraftPlanets.commonModules) {
            module.init(event);
        }
    }

    public void postInit(FMLPostInitializationEvent event) {
        for (IPlanetsModule module : GalacticraftPlanets.commonModules) {
            module.postInit(event);
        }
    }

    public void serverStarting(FMLServerStartingEvent event) {
        for (IPlanetsModule module : GalacticraftPlanets.commonModules) {
            module.serverStarting(event);
        }
    }

    public void serverInit(FMLServerStartedEvent event) {
        for (IPlanetsModule module : GalacticraftPlanets.commonModules) {
            module.serverInit(event);
        }
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        for (IPlanetsModule module : GalacticraftPlanets.commonModules) {
            ArrayList<Integer> guiIDs = new ArrayList<Integer>();
            module.getGuiIDs(guiIDs);
            if (!guiIDs.contains(ID)) continue;
            return module.getGuiElement(Side.SERVER, ID, player, world, x, y, z);
        }
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        for (IPlanetsModuleClient module : GalacticraftPlanets.clientModules) {
            ArrayList<Integer> guiIDs = new ArrayList<Integer>();
            module.getGuiIDs(guiIDs);
            if (!guiIDs.contains(ID)) continue;
            return module.getGuiElement(Side.CLIENT, ID, player, world, x, y, z);
        }
        return null;
    }

    public void postRegisterItem(Item item) {
    }

    public void unregisterNetwork(SolarModuleNetwork solarNetwork) {
        if (GCCoreUtil.getEffectiveSide().isServer()) {
            VenusTickHandlerServer.removeSolarNetwork(solarNetwork);
        }
    }

    public void registerNetwork(SolarModuleNetwork solarNetwork) {
        if (GCCoreUtil.getEffectiveSide().isServer()) {
            VenusTickHandlerServer.addSolarNetwork(solarNetwork);
        }
    }
}

