/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.ic2c_extras.blocks;

import ic2.core.block.base.BlockMultiID;
import ic2.core.block.base.tile.TileEntityBlock;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.textures.Ic2Icons;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import trinsdar.ic2c_extras.IC2CExtras;
import trinsdar.ic2c_extras.tileentity.TileEntityCutter;
import trinsdar.ic2c_extras.tileentity.TileEntityExtruder;
import trinsdar.ic2c_extras.tileentity.TileEntityFluidCanningMachine;
import trinsdar.ic2c_extras.tileentity.TileEntityImpellerizedRoller;
import trinsdar.ic2c_extras.tileentity.TileEntityLiquescentExtruder;
import trinsdar.ic2c_extras.tileentity.TileEntityMetalBender;
import trinsdar.ic2c_extras.tileentity.TileEntityOreWashingPlant;
import trinsdar.ic2c_extras.tileentity.TileEntityPlasmaCutter;
import trinsdar.ic2c_extras.tileentity.TileEntityRoller;
import trinsdar.ic2c_extras.tileentity.TileEntityThermalCentrifuge;
import trinsdar.ic2c_extras.tileentity.TileEntityThermalWasher;
import trinsdar.ic2c_extras.tileentity.TileEntityTreeTapper;
import trinsdar.ic2c_extras.util.Registry;

public class BlockMachine
extends BlockMultiID {
    public BlockMachine(String name, LocaleComp comp) {
        super(Material.field_151573_f);
        this.func_149711_c(4.0f);
        this.func_149752_b(20.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149647_a(IC2CExtras.creativeTab);
        this.setRegistryName("ic2c_extras", name.toLowerCase());
        this.setUnlocalizedName(comp);
    }

    public List<Integer> getValidMetas() {
        return Arrays.asList(0);
    }

    public TileEntityBlock createNewTileEntity(World worldIn, int meta) {
        if (this == Registry.oreWashingPlant) {
            return new TileEntityOreWashingPlant();
        }
        if (this == Registry.thermalCentrifuge) {
            return new TileEntityThermalCentrifuge();
        }
        if (this == Registry.thermalWasher) {
            return new TileEntityThermalWasher();
        }
        if (this == Registry.roller) {
            return new TileEntityRoller();
        }
        if (this == Registry.extruder) {
            return new TileEntityExtruder();
        }
        if (this == Registry.cutter) {
            return new TileEntityCutter();
        }
        if (this == Registry.impellerizedRoller) {
            return new TileEntityImpellerizedRoller();
        }
        if (this == Registry.liquescentExtruder) {
            return new TileEntityLiquescentExtruder();
        }
        if (this == Registry.plasmaCutter) {
            return new TileEntityPlasmaCutter();
        }
        if (this == Registry.metalBender) {
            return new TileEntityMetalBender();
        }
        if (this == Registry.fluidCanningMachine) {
            return new TileEntityFluidCanningMachine();
        }
        if (this == Registry.treeTapper) {
            return new TileEntityTreeTapper();
        }
        return new TileEntityBlock();
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if (this == Registry.thermalCentrifuge || this == Registry.thermalWasher || this == Registry.impellerizedRoller || this == Registry.liquescentExtruder || this == Registry.plasmaCutter || this == Registry.metalBender) {
            drops.add(Ic2Items.advMachine);
            return drops;
        }
        if (this == Registry.fluidCanningMachine) {
            drops.add(Ic2Items.canner);
            return drops;
        }
        drops.add(Ic2Items.machine);
        return drops;
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite[] getIconSheet(int meta) {
        if (this == Registry.oreWashingPlant) {
            return Ic2Icons.getTextures((String)"orewashingplant");
        }
        if (this == Registry.thermalCentrifuge) {
            return Ic2Icons.getTextures((String)"thermalcentrifuge");
        }
        if (this == Registry.thermalWasher) {
            return Ic2Icons.getTextures((String)"thermalwasher");
        }
        if (this == Registry.roller) {
            return Ic2Icons.getTextures((String)"roller");
        }
        if (this == Registry.extruder) {
            return Ic2Icons.getTextures((String)"extruder");
        }
        if (this == Registry.cutter) {
            return Ic2Icons.getTextures((String)"cutter");
        }
        if (this == Registry.impellerizedRoller) {
            return Ic2Icons.getTextures((String)"impellerizedroller");
        }
        if (this == Registry.liquescentExtruder) {
            return Ic2Icons.getTextures((String)"liquescentextruder");
        }
        if (this == Registry.plasmaCutter) {
            return Ic2Icons.getTextures((String)"plasmacutter");
        }
        if (this == Registry.metalBender) {
            return Ic2Icons.getTextures((String)"metalbender");
        }
        if (this == Registry.fluidCanningMachine) {
            return Ic2Icons.getTextures((String)"fluidcanningmachine");
        }
        if (this == Registry.treeTapper) {
            return Ic2Icons.getTextures((String)"treetapper");
        }
        return Ic2Icons.getTextures((String)"roller");
    }

    public int getMaxSheetSize(int meta) {
        return 1;
    }

    public List<IBlockState> getValidStateList() {
        IBlockState def = this.func_176223_P();
        ArrayList<IBlockState> states = new ArrayList<IBlockState>();
        for (EnumFacing side : EnumFacing.field_82609_l) {
            states.add(def.func_177226_a((IProperty)this.getMetadataProperty(), (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)allFacings, (Comparable)side).func_177226_a((IProperty)active, (Comparable)Boolean.valueOf(false)));
            states.add(def.func_177226_a((IProperty)this.getMetadataProperty(), (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)allFacings, (Comparable)side).func_177226_a((IProperty)active, (Comparable)Boolean.valueOf(true)));
        }
        return states;
    }

    public List<IBlockState> getValidStates() {
        return this.func_176194_O().func_177619_a();
    }
}

