/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.ic2c_extras.tileentity;

import ic2.api.classic.network.adv.NetworkField;
import ic2.api.classic.recipe.machine.IMachineRecipeList;
import ic2.api.classic.recipe.machine.MachineOutput;
import ic2.api.classic.tile.IMachine;
import ic2.api.classic.tile.IStackOutput;
import ic2.api.classic.tile.MachineType;
import ic2.api.recipe.IRecipeInput;
import ic2.core.RotationList;
import ic2.core.block.base.tile.TileEntityBasicElectricMachine;
import ic2.core.block.base.util.output.SimpleStackOutput;
import ic2.core.fluid.IC2Tank;
import ic2.core.inventory.base.IHasInventory;
import ic2.core.inventory.container.ContainerIC2;
import ic2.core.inventory.filters.ArrayFilter;
import ic2.core.inventory.filters.BasicItemFilter;
import ic2.core.inventory.filters.CommonFilters;
import ic2.core.inventory.filters.IFilter;
import ic2.core.inventory.filters.MachineFilter;
import ic2.core.inventory.management.AccessRule;
import ic2.core.inventory.management.InventoryHandler;
import ic2.core.inventory.management.SlotType;
import ic2.core.inventory.transport.wrapper.RangedInventoryWrapper;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2Sounds;
import ic2.core.util.helpers.CompareableStack;
import ic2.core.util.misc.FluidHelper;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.IClickable;
import ic2.core.util.obj.ITankListener;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;
import trinsdar.ic2c_extras.container.ContainerOreWashingPlant;
import trinsdar.ic2c_extras.recipes.Ic2cExtrasRecipes;
import trinsdar.ic2c_extras.util.GuiMachine;
import trinsdar.ic2c_extras.util.references.Ic2cExtrasLang;
import trinsdar.ic2c_extras.util.references.Ic2cExtrasResourceLocations;

public class TileEntityOreWashingPlant
extends TileEntityBasicElectricMachine
implements ITankListener,
IFluidHandler,
IClickable {
    @NetworkField(index=13)
    public IC2Tank waterTank = new IC2Tank(FluidRegistry.getFluidStack((String)FluidRegistry.WATER.getName(), (int)0), 10000);
    public static final String waterAmount = "amount";
    public int water = 0;
    public int maxWater = 10000;
    public static final int slotInput = 0;
    public static final int slotFuel = 1;
    public static final int slotOutput = 2;
    public static final int slotOutput2 = 3;
    public static final int slotOutput3 = 4;
    public static final int slotInputTank = 5;
    public static final int slotOutputTank = 6;

    public TileEntityOreWashingPlant() {
        super(7, 8, 400, 32);
        this.waterTank.addListener((ITankListener)this);
        this.waterTank.setCanFill(true);
        this.addGuiFields(new String[]{"waterTank"});
    }

    public IC2Tank getWaterTank() {
        return this.waterTank;
    }

    protected void addSlots(InventoryHandler handler) {
        this.filter = new MachineFilter((IMachine)this);
        handler.registerDefaultSideAccess(AccessRule.Both, RotationList.ALL);
        handler.registerDefaultSlotAccess(AccessRule.Both, new int[]{1});
        handler.registerDefaultSlotAccess(AccessRule.Import, new int[]{0});
        handler.registerDefaultSlotAccess(AccessRule.Export, new int[]{2, 3, 4, 6});
        handler.registerDefaultSlotsForSide(RotationList.UP.invert(), new int[]{2, 3, 4});
        handler.registerDefaultSlotsForSide(RotationList.DOWN.invert(), new int[]{0});
        handler.registerInputFilter((IFilter)new ArrayFilter(new IFilter[]{CommonFilters.DischargeEU, new BasicItemFilter(Items.field_151137_ax), new BasicItemFilter(Ic2Items.suBattery)}), new int[]{1});
        handler.registerInputFilter(this.filter, new int[]{0});
        handler.registerOutputFilter(CommonFilters.NotDischargeEU, new int[]{1});
        handler.registerSlotType(SlotType.Fuel, new int[]{1});
        handler.registerSlotType(SlotType.Input, new int[]{0});
        handler.registerSlotType(SlotType.Output, new int[]{2, 3, 4, 6});
    }

    public IMachineRecipeList.RecipeEntry getOutputFor(ItemStack input) {
        return Ic2cExtrasRecipes.oreWashingPlant.getRecipeInAndOutput(input, false);
    }

    public boolean isValidInput(ItemStack par1) {
        return super.isValidInput(par1) && this.isRecipeInputValid(par1);
    }

    public boolean isRecipeInputValid(ItemStack stack) {
        IRecipeInput input = Ic2cExtrasRecipes.oreWashingPlantValidInputs.get(new CompareableStack(stack));
        if (input == null) {
            return false;
        }
        return input.matches(stack);
    }

    public ResourceLocation getStartSoundFile() {
        return Ic2cExtrasResourceLocations.oreWashingPlantOp;
    }

    public ResourceLocation getInterruptSoundFile() {
        return Ic2Sounds.interruptingSound;
    }

    public void func_73660_a() {
        if (!((ItemStack)this.inventory.get(5)).func_190926_b()) {
            this.handleTank();
        }
        super.func_73660_a();
    }

    public boolean canWork() {
        return super.canWork() && this.waterTank.getFluidAmount() >= 1000;
    }

    protected EnumActionResult isRecipeStillValid(IMachineRecipeList.RecipeEntry entry) {
        if (this.waterTank.getFluidAmount() >= TileEntityOreWashingPlant.getRequiredWater(entry.getOutput())) {
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    protected EnumActionResult canFillRecipeIntoOutputs(MachineOutput output) {
        List result = output.getAllOutputs();
        for (int i = 0; i < result.size() && i < 3; ++i) {
            ItemStack stack = this.getStackInSlot(2 + i);
            ItemStack extra = (ItemStack)result.get(i);
            if ((stack.func_190926_b() || StackUtil.isStackEqual((ItemStack)stack, (ItemStack)extra, (boolean)false, (boolean)true)) && stack.func_190916_E() + extra.func_190916_E() <= extra.func_77976_d()) continue;
            return EnumActionResult.PASS;
        }
        return EnumActionResult.SUCCESS;
    }

    public void handleTank() {
        RangedInventoryWrapper output;
        IFluidHandlerItem containerFluidHandler = FluidUtil.getFluidHandler((ItemStack)((ItemStack)this.inventory.get(5)));
        if (FluidHelper.hasFluid((IFluidHandler)containerFluidHandler, (FluidStack)FluidRegistry.getFluidStack((String)FluidRegistry.WATER.getName(), (int)1), (boolean)false) && this.waterTank.getFluidAmount() + FluidUtil.getFluidContained((ItemStack)((ItemStack)this.inventory.get((int)5))).amount <= this.waterTank.getCapacity() && FluidHelper.drainContainers((IFluidHandler)this.waterTank, (IHasInventory)this, (int)5, (IHasInventory)(output = new RangedInventoryWrapper((IHasInventory)this, new int[]{6})))) {
            this.getNetwork().updateTileGuiField((TileEntity)this, "tank");
            this.setStackInSlot(6, output.getStackInSlot(0));
        }
    }

    public void operateOnce(IRecipeInput input, MachineOutput output, List<IStackOutput> list) {
        List result = output.getRecipeOutput(this.func_145831_w().field_73012_v, this.getTileData());
        for (int i = 0; i < result.size(); ++i) {
            list.add((IStackOutput)new SimpleStackOutput((ItemStack)result.get(i), 2 + i % 3));
        }
        this.consumeInput(input);
        this.waterTank.drain(TileEntityOreWashingPlant.getRequiredWater(output), true);
    }

    public FluidStack getFluid() {
        return this.waterTank.getFluid();
    }

    public int getPixel() {
        return (int)((double)this.waterTank.getFluidAmount() / (double)this.waterTank.getCapacity() * 58.0);
    }

    public void onTankChanged(IFluidTank tank) {
        this.getNetwork().updateTileGuiField((TileEntity)this, "waterTank");
        if (this.lastRecipe != null && this.activeRecipe == null) {
            this.checkRecipe = true;
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.waterTank.readFromNBT(nbt.func_74775_l("Tank"));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.waterTank.writeToNBT(this.getTag(nbt, "Tank"));
        return nbt;
    }

    public ContainerIC2 getGuiContainer(EntityPlayer player) {
        return new ContainerOreWashingPlant(player.field_71071_by, this);
    }

    public Class<? extends GuiScreen> getGuiClass(EntityPlayer player) {
        return GuiMachine.OreWashingPlantGui.class;
    }

    public LocaleComp getBlockName() {
        return Ic2cExtrasLang.oreWashingPlant;
    }

    public ResourceLocation getGuiTexture() {
        return Ic2cExtrasResourceLocations.oreWashingPlant;
    }

    public MachineType getType() {
        return null;
    }

    public double getWrenchDropRate() {
        return 1.0;
    }

    public IMachineRecipeList getRecipeList() {
        return Ic2cExtrasRecipes.oreWashingPlant;
    }

    public IHasInventory getOutputInventory() {
        return new RangedInventoryWrapper((IHasInventory)this, new int[]{2, 3, 4, 6});
    }

    public IHasInventory getInputInventory() {
        return new RangedInventoryWrapper((IHasInventory)this, new int[]{0}).setFilters(this.filter);
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{new FluidTankProperties(new FluidStack(FluidRegistry.WATER, this.water), 10000)};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource != null && resource.getFluid() == FluidRegistry.WATER) {
            int toAdd = Math.min(resource.amount, this.maxWater - this.water);
            if (doFill) {
                this.water += toAdd;
                this.getNetwork().updateTileGuiField((TileEntity)this, "water");
            }
            return toAdd;
        }
        return 0;
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return resource != null && resource.getFluid() == FluidRegistry.WATER ? this.drain(resource.amount, doDrain) : null;
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        int amount = Math.min(maxDrain, this.water);
        if (amount <= 0) {
            return null;
        }
        if (doDrain) {
            this.water -= amount;
            this.getNetwork().updateTileGuiField((TileEntity)this, "water");
        }
        return new FluidStack(FluidRegistry.WATER, amount);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)(capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY ? this.waterTank : super.getCapability(capability, facing));
    }

    public static int getRequiredWater(MachineOutput output) {
        if (output == null || output.getMetadata() == null) {
            return 1000;
        }
        return output.getMetadata().func_74762_e(waterAmount);
    }

    protected static NBTTagCompound createNeededWater(int amount) {
        if (amount <= 0) {
            return null;
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a(waterAmount, amount);
        return nbt;
    }

    public static void addRecipe(IRecipeInput input, int water, ItemStack ... output) {
        TileEntityOreWashingPlant.addRecipe(input, new MachineOutput(TileEntityOreWashingPlant.createNeededWater(water), output));
    }

    public static void addRecipe(IRecipeInput input, MachineOutput output) {
        Ic2cExtrasRecipes.oreWashingPlant.addRecipe(input, output, ((ItemStack)output.getAllOutputs().get(0)).func_77977_a());
    }

    public boolean hasRightClick() {
        return true;
    }

    public boolean onRightClick(EntityPlayer player, EnumHand hand, EnumFacing enumFacing, Side side) {
        FluidActionResult result;
        ItemStack playerStack = player.func_184586_b(hand);
        if (!playerStack.func_190926_b() && (result = FluidUtil.tryEmptyContainer((ItemStack)playerStack, (IFluidHandler)this.waterTank, (int)(this.waterTank.getCapacity() - this.waterTank.getFluidAmount()), (EntityPlayer)player, (boolean)true)).isSuccess()) {
            playerStack.func_190918_g(1);
            ItemStack resultStack = result.getResult();
            if (!resultStack.func_190926_b() && !player.field_71071_by.func_70441_a(resultStack)) {
                player.func_71019_a(resultStack, false);
            }
            return true;
        }
        return false;
    }

    public boolean hasLeftClick() {
        return false;
    }

    public void onLeftClick(EntityPlayer entityPlayer, Side side) {
    }
}

