/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.energy.render;

import ic2.api.classic.energy.render.IRenderValidator;
import ic2.core.energy.render.RenderEntry;
import ic2.core.energy.render.RenderPath;
import ic2.core.energy.render.TextureRotator;
import ic2.core.platform.registry.Ic2Lang;
import ic2.core.platform.textures.Ic2Icons;
import ic2.core.util.events.ElectricToolTipManager;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class EnergyNetRenderer {
    public static EnergyNetRenderer instance = new EnergyNetRenderer();
    boolean isLockt = false;
    int limit = 5;
    TextureRotator rotator = new TextureRotator();
    Minecraft mc;
    World lastWorld;
    LinkedList<Tuple<IRenderValidator, List<RenderPath>>> renderStorage = new LinkedList();
    List<Tuple<IRenderValidator, List<RenderPath>>> backlog = new LinkedList<Tuple<IRenderValidator, List<RenderPath>>>();
    RenderEntry lastViewed;
    int delay = 5;

    public void init() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.mc = Minecraft.func_71410_x();
        this.rotator.init();
    }

    @SubscribeEvent
    public void onRenderWorld(RenderWorldLastEvent evt) {
        EntityPlayerSP player = this.mc.field_71439_g;
        if (player == null || this.lastWorld == null || player.field_70170_p == null || player.field_70170_p.field_73011_w.getDimension() != this.lastWorld.field_73011_w.getDimension()) {
            return;
        }
        if (this.renderStorage.isEmpty()) {
            return;
        }
        float particalTicks = evt.getPartialTicks();
        Vec3d pos = player.func_174791_d();
        TextureAtlasSprite sprite = Ic2Icons.getEnergyPacketTexture(true);
        this.rotator.setTexture(Ic2Icons.getEnergyPacketTexture(false));
        double x = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)particalTicks;
        double y = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)particalTicks;
        double z = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)particalTicks;
        this.isLockt = true;
        for (Tuple tuple : this.renderStorage) {
            for (RenderPath path : (List)tuple.func_76340_b()) {
                if (path.getTargets() <= 0) continue;
                for (RenderEntry renderEntry : path) {
                    double distance = pos.func_72438_d(renderEntry.getPosition());
                    if (distance > 80.0) continue;
                    AxisAlignedBB box = renderEntry.getBox();
                    double xCoord = -x + (box.field_72340_a - box.field_72336_d);
                    double yCoord = -y + (box.field_72338_b - box.field_72337_e);
                    double zCoord = -z + (box.field_72339_c - box.field_72334_f);
                    xCoord -= xCoord + x;
                    yCoord -= yCoord + y;
                    zCoord -= zCoord + z;
                    GL11.glPushMatrix();
                    GL11.glTranslated((double)xCoord, (double)yCoord, (double)zCoord);
                    this.rotator.setRotation(renderEntry.getDirection());
                    this.renderEffect(box, sprite, renderEntry.getDirection().func_176740_k());
                    GL11.glPopMatrix();
                }
            }
        }
        this.isLockt = false;
    }

    public void renderEffect(AxisAlignedBB box, TextureAtlasSprite sprite, EnumFacing.Axis axis) {
        this.mc.func_175598_ae().field_78724_e.func_110577_a(TextureMap.field_110575_b);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        if (axis == EnumFacing.Axis.Y) {
            vertexbuffer.func_181668_a(6, DefaultVertexFormats.field_181707_g);
            vertexbuffer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72339_c).func_187315_a((double)sprite.func_94209_e(), (double)sprite.func_94210_h()).func_181675_d();
            vertexbuffer.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72339_c).func_187315_a((double)sprite.func_94212_f(), (double)sprite.func_94210_h()).func_181675_d();
            vertexbuffer.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72334_f).func_187315_a((double)sprite.func_94212_f(), (double)sprite.func_94206_g()).func_181675_d();
            vertexbuffer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72334_f).func_187315_a((double)sprite.func_94209_e(), (double)sprite.func_94206_g()).func_181675_d();
            tessellator.func_78381_a();
            vertexbuffer.func_181668_a(6, DefaultVertexFormats.field_181707_g);
            vertexbuffer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72334_f).func_187315_a((double)sprite.func_94209_e(), (double)sprite.func_94210_h()).func_181675_d();
            vertexbuffer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72334_f).func_187315_a((double)sprite.func_94212_f(), (double)sprite.func_94210_h()).func_181675_d();
            vertexbuffer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72339_c).func_187315_a((double)sprite.func_94212_f(), (double)sprite.func_94206_g()).func_181675_d();
            vertexbuffer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72339_c).func_187315_a((double)sprite.func_94209_e(), (double)sprite.func_94206_g()).func_181675_d();
            tessellator.func_78381_a();
        } else {
            this.rotator.setSide(EnumFacing.DOWN);
            vertexbuffer.func_181668_a(6, DefaultVertexFormats.field_181707_g);
            vertexbuffer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72339_c).func_187315_a(this.rotator.getUV(0, true), this.rotator.getUV(0, false)).func_181675_d();
            vertexbuffer.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72339_c).func_187315_a(this.rotator.getUV(1, true), this.rotator.getUV(1, false)).func_181675_d();
            vertexbuffer.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72334_f).func_187315_a(this.rotator.getUV(2, true), this.rotator.getUV(2, false)).func_181675_d();
            vertexbuffer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72334_f).func_187315_a(this.rotator.getUV(3, true), this.rotator.getUV(3, false)).func_181675_d();
            tessellator.func_78381_a();
            this.rotator.setSide(EnumFacing.UP);
            vertexbuffer.func_181668_a(6, DefaultVertexFormats.field_181707_g);
            vertexbuffer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72334_f).func_187315_a(this.rotator.getUV(0, true), this.rotator.getUV(0, false)).func_181675_d();
            vertexbuffer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72334_f).func_187315_a(this.rotator.getUV(1, true), this.rotator.getUV(1, false)).func_181675_d();
            vertexbuffer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72339_c).func_187315_a(this.rotator.getUV(2, true), this.rotator.getUV(2, false)).func_181675_d();
            vertexbuffer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72339_c).func_187315_a(this.rotator.getUV(3, true), this.rotator.getUV(3, false)).func_181675_d();
            tessellator.func_78381_a();
        }
        if (axis == EnumFacing.Axis.Z) {
            vertexbuffer.func_181668_a(6, DefaultVertexFormats.field_181707_g);
            vertexbuffer.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72334_f).func_187315_a((double)sprite.func_94212_f(), (double)sprite.func_94210_h()).func_181675_d();
            vertexbuffer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72334_f).func_187315_a((double)sprite.func_94212_f(), (double)sprite.func_94206_g()).func_181675_d();
            vertexbuffer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72334_f).func_187315_a((double)sprite.func_94209_e(), (double)sprite.func_94206_g()).func_181675_d();
            vertexbuffer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72334_f).func_187315_a((double)sprite.func_94209_e(), (double)sprite.func_94210_h()).func_181675_d();
            tessellator.func_78381_a();
            vertexbuffer.func_181668_a(6, DefaultVertexFormats.field_181707_g);
            vertexbuffer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72339_c).func_187315_a((double)sprite.func_94212_f(), (double)sprite.func_94210_h()).func_181675_d();
            vertexbuffer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72339_c).func_187315_a((double)sprite.func_94212_f(), (double)sprite.func_94206_g()).func_181675_d();
            vertexbuffer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72339_c).func_187315_a((double)sprite.func_94209_e(), (double)sprite.func_94206_g()).func_181675_d();
            vertexbuffer.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72339_c).func_187315_a((double)sprite.func_94209_e(), (double)sprite.func_94210_h()).func_181675_d();
            tessellator.func_78381_a();
        } else {
            this.rotator.setSide(EnumFacing.SOUTH);
            vertexbuffer.func_181668_a(6, DefaultVertexFormats.field_181707_g);
            vertexbuffer.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72334_f).func_187315_a(this.rotator.getUV(0, true), this.rotator.getUV(0, false)).func_181675_d();
            vertexbuffer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72334_f).func_187315_a(this.rotator.getUV(1, true), this.rotator.getUV(1, false)).func_181675_d();
            vertexbuffer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72334_f).func_187315_a(this.rotator.getUV(2, true), this.rotator.getUV(2, false)).func_181675_d();
            vertexbuffer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72334_f).func_187315_a(this.rotator.getUV(3, true), this.rotator.getUV(3, false)).func_181675_d();
            tessellator.func_78381_a();
            this.rotator.setSide(EnumFacing.NORTH);
            vertexbuffer.func_181668_a(6, DefaultVertexFormats.field_181707_g);
            vertexbuffer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72339_c).func_187315_a(this.rotator.getUV(0, true), this.rotator.getUV(0, false)).func_181675_d();
            vertexbuffer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72339_c).func_187315_a(this.rotator.getUV(1, true), this.rotator.getUV(1, false)).func_181675_d();
            vertexbuffer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72339_c).func_187315_a(this.rotator.getUV(2, true), this.rotator.getUV(2, false)).func_181675_d();
            vertexbuffer.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72339_c).func_187315_a(this.rotator.getUV(3, true), this.rotator.getUV(3, false)).func_181675_d();
            tessellator.func_78381_a();
        }
        if (axis == EnumFacing.Axis.X) {
            vertexbuffer.func_181668_a(6, DefaultVertexFormats.field_181707_g);
            vertexbuffer.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72339_c).func_187315_a((double)sprite.func_94212_f(), (double)sprite.func_94206_g()).func_181675_d();
            vertexbuffer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72339_c).func_187315_a((double)sprite.func_94209_e(), (double)sprite.func_94206_g()).func_181675_d();
            vertexbuffer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72334_f).func_187315_a((double)sprite.func_94209_e(), (double)sprite.func_94210_h()).func_181675_d();
            vertexbuffer.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72334_f).func_187315_a((double)sprite.func_94212_f(), (double)sprite.func_94210_h()).func_181675_d();
            tessellator.func_78381_a();
            vertexbuffer.func_181668_a(6, DefaultVertexFormats.field_181707_g);
            vertexbuffer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72334_f).func_187315_a((double)sprite.func_94212_f(), (double)sprite.func_94210_h()).func_181675_d();
            vertexbuffer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72334_f).func_187315_a((double)sprite.func_94212_f(), (double)sprite.func_94206_g()).func_181675_d();
            vertexbuffer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72339_c).func_187315_a((double)sprite.func_94209_e(), (double)sprite.func_94206_g()).func_181675_d();
            vertexbuffer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72339_c).func_187315_a((double)sprite.func_94209_e(), (double)sprite.func_94210_h()).func_181675_d();
            tessellator.func_78381_a();
        } else {
            this.rotator.setSide(EnumFacing.EAST);
            vertexbuffer.func_181668_a(6, DefaultVertexFormats.field_181707_g);
            vertexbuffer.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72339_c).func_187315_a(this.rotator.getUV(0, true), this.rotator.getUV(0, false)).func_181675_d();
            vertexbuffer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72339_c).func_187315_a(this.rotator.getUV(1, true), this.rotator.getUV(1, false)).func_181675_d();
            vertexbuffer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72334_f).func_187315_a(this.rotator.getUV(2, true), this.rotator.getUV(2, false)).func_181675_d();
            vertexbuffer.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72334_f).func_187315_a(this.rotator.getUV(3, true), this.rotator.getUV(3, false)).func_181675_d();
            tessellator.func_78381_a();
            this.rotator.setSide(EnumFacing.WEST);
            vertexbuffer.func_181668_a(6, DefaultVertexFormats.field_181707_g);
            vertexbuffer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72334_f).func_187315_a(this.rotator.getUV(0, true), this.rotator.getUV(0, false)).func_181675_d();
            vertexbuffer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72334_f).func_187315_a(this.rotator.getUV(1, true), this.rotator.getUV(1, false)).func_181675_d();
            vertexbuffer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72339_c).func_187315_a(this.rotator.getUV(2, true), this.rotator.getUV(2, false)).func_181675_d();
            vertexbuffer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72339_c).func_187315_a(this.rotator.getUV(3, true), this.rotator.getUV(3, false)).func_181675_d();
            tessellator.func_78381_a();
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (this.mc.field_71439_g == null || event.phase == TickEvent.Phase.START) {
            return;
        }
        if (this.mc.field_71441_e == null) {
            if (this.lastWorld != null) {
                this.lastWorld = null;
            }
            return;
        }
        if (this.lastWorld == null || this.mc.field_71441_e.field_73011_w.getDimension() != this.lastWorld.field_73011_w.getDimension()) {
            for (Tuple tuple : this.renderStorage) {
                for (RenderPath path : (List)tuple.func_76340_b()) {
                    path.clear();
                }
            }
            this.renderStorage.clear();
            this.lastWorld = this.mc.field_71441_e;
        }
        if (this.lastWorld == null) {
            return;
        }
        if (this.renderStorage.isEmpty()) {
            return;
        }
        this.isLockt = true;
        Iterator iter = this.renderStorage.iterator();
        while (iter.hasNext()) {
            Tuple tuple = (Tuple)iter.next();
            IRenderValidator validator = (IRenderValidator)tuple.func_76341_a();
            if (!validator.isValid((EntityPlayer)this.mc.field_71439_g)) {
                iter.remove();
                continue;
            }
            List paths = (List)tuple.func_76340_b();
            if (paths.isEmpty()) {
                iter.remove();
                continue;
            }
            Iterator pathIter = paths.iterator();
            while (pathIter.hasNext()) {
                RenderPath path = (RenderPath)pathIter.next();
                path.onTick();
                if (path.hasWork()) continue;
                pathIter.remove();
            }
            if (!paths.isEmpty()) continue;
            iter.remove();
        }
        this.isLockt = false;
        if (this.backlog.size() > 0) {
            this.renderStorage.addAll(this.backlog);
            this.backlog.clear();
            while (this.renderStorage.size() > this.limit) {
                this.renderStorage.remove();
            }
        }
    }

    @SubscribeEvent
    public void onExpBarRenderer(RenderGameOverlayEvent.Post evt) {
        RenderGameOverlayEvent.ElementType elementType = evt.getType();
        evt.getType();
        if (elementType != RenderGameOverlayEvent.ElementType.EXPERIENCE) {
            return;
        }
        EntityPlayerSP player = this.mc.field_71439_g;
        if (player == null || this.mc.field_71442_b == null || this.renderStorage.isEmpty()) {
            return;
        }
        float max = 10.0f;
        Vec3d playerPos = player.func_174824_e(evt.getPartialTicks());
        Vec3d playerLook = player.func_70676_i(evt.getPartialTicks());
        if (this.lastViewed != null) {
            if (this.lastViewed.isValid() && this.isLookingAt(playerPos, playerLook, this.lastViewed, 16.0)) {
                this.renderStuff(evt.getResolution());
                return;
            }
            this.lastViewed = null;
        }
        if (this.delay > 0) {
            --this.delay;
            return;
        }
        this.delay = 5;
        this.isLockt = true;
        RenderEntry target = this.getTarget(playerPos, playerLook, 16.0f);
        this.isLockt = false;
        if (target != null) {
            this.lastViewed = target;
            this.renderStuff(evt.getResolution());
        }
    }

    private void renderStuff(ScaledResolution resolution) {
        int i = resolution.func_78326_a();
        int b0 = resolution.func_78328_b() - 50;
        String s = Ic2Lang.pathLoss.getLocalizedFormatted(ElectricToolTipManager.format.format(this.lastViewed.getLoss()));
        this.mc.field_71466_p.func_175063_a(s, (float)(i / 2 - this.mc.field_71466_p.func_78256_a(s) / 2), (float)(b0 - 2), 0xFFFFFF);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.func_110434_K().func_110577_a(Gui.field_110324_m);
    }

    private RenderEntry getTarget(Vec3d playerPos, Vec3d playerLook, float maxDistance) {
        RenderEntry result = null;
        double realMaxDistance = maxDistance;
        for (Tuple tuple : this.renderStorage) {
            for (RenderPath path : (List)tuple.func_76340_b()) {
                for (RenderEntry target : path) {
                    if (!target.isValid() || !this.isLookingAt(playerPos, playerLook, target, realMaxDistance)) continue;
                    result = target;
                    realMaxDistance = playerPos.func_72438_d(target.getPosition());
                }
            }
        }
        return result;
    }

    private boolean isLookingAt(Vec3d playerPos, Vec3d playerLook, RenderEntry entry, double maxDistance) {
        double distance = playerPos.func_72438_d(entry.getPosition()) - 0.5;
        if (distance > maxDistance) {
            return false;
        }
        Vec3d targetPos = playerPos.func_72441_c(playerLook.field_72450_a * distance, playerLook.field_72448_b * distance, playerLook.field_72449_c * distance);
        return this.isInBox(targetPos, entry.getPosition());
    }

    private boolean isInBox(Vec3d look, Vec3d target) {
        double minX = target.field_72450_a;
        double minY = target.field_72448_b;
        double minZ = target.field_72449_c;
        double maxX = target.field_72450_a + 1.0;
        double maxY = target.field_72448_b + 1.0;
        double maxZ = target.field_72449_c + 1.0;
        return minX <= look.field_72450_a && maxX >= look.field_72450_a && minY <= look.field_72448_b && maxY >= look.field_72448_b && minZ <= look.field_72449_c && maxZ >= look.field_72449_c;
    }

    public void addRenderer(Tuple<IRenderValidator, List<RenderPath>> renderer) {
        if (this.isLockt) {
            this.backlog.add(renderer);
            return;
        }
        this.renderStorage.add(renderer);
        while (this.renderStorage.size() > this.limit) {
            this.renderStorage.remove();
        }
    }

    public void setLimit(int newLimit) {
        this.limit = newLimit;
        if (newLimit < 5) {
            this.limit = 5;
        }
    }
}

