/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.inventory.gui.components.personalBlocks;

import ic2.api.classic.trading.trades.IModifyableTrade;
import ic2.api.classic.trading.trades.ISubTrade;
import ic2.api.classic.trading.trades.ITrade;
import ic2.api.classic.trading.trades.TradeType;
import ic2.core.IC2;
import ic2.core.block.personal.base.trades.builder.ItemTradeFabricator;
import ic2.core.block.personal.base.util.TradeSyncer;
import ic2.core.block.personal.container.ContainerEnergyOMatOpen;
import ic2.core.block.personal.tile.TileEntityEnergyOMat;
import ic2.core.inventory.gui.GuiIC2;
import ic2.core.inventory.gui.buttons.IC2Button;
import ic2.core.inventory.gui.buttons.IconButton;
import ic2.core.inventory.gui.buttons.ToggleButton;
import ic2.core.inventory.gui.buttons.ToolTipButton;
import ic2.core.inventory.gui.components.GuiComponent;
import ic2.core.network.fieldEvents.custom.PayloadFieldPacket;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.components.special.DisplayLocaleComp;
import ic2.core.platform.lang.storage.Ic2GuiLang;
import ic2.core.platform.registry.Ic2Formatters;
import ic2.core.platform.registry.Ic2GuiComp;
import ic2.core.platform.registry.Ic2Items;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EnergyOMatOpenComp
extends GuiComponent {
    public static final LocaleComp time = new DisplayLocaleComp("1 ");
    public static final ItemStack cancelIcon = Ic2Items.displayIcons[1].func_77946_l();
    public static final ItemStack okIcon = Ic2Items.displayIcons[0].func_77946_l();
    TileEntityEnergyOMat trade;
    Map<ITrade, String> currentCustomTrades = new LinkedHashMap<ITrade, String>();
    TradeSyncer.ServerEntry server;
    TradeSyncer.ClientEntry clientData;
    List<String> infoText = new LinkedList<String>();
    boolean showText = false;
    int ticks = 0;

    public EnergyOMatOpenComp(TileEntityEnergyOMat tile) {
        super(Ic2GuiComp.nullBox);
        this.trade = tile;
        this.clientData = this.trade.getSyncer().getClientData();
        this.server = new TradeSyncer.ServerEntry(IC2.platform.getPlayerInstance(), false);
    }

    @Override
    public List<GuiComponent.ActionRequest> getNeededRequests() {
        return Arrays.asList(GuiComponent.ActionRequest.BackgroundDraw, GuiComponent.ActionRequest.FrontgroundDraw, GuiComponent.ActionRequest.GuiInit, GuiComponent.ActionRequest.GuiTick, GuiComponent.ActionRequest.ButtonNotify, GuiComponent.ActionRequest.ToolTip);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onGuiInit(GuiIC2 gui) {
        int x = gui.getXOffset();
        int y = gui.getYOffset();
        int state = this.trade.state;
        List<LocaleComp> list = Arrays.asList(Ic2GuiLang.getCtrlKey("1000"), Ic2GuiLang.getShiftKey("100"), Ic2GuiLang.getAltKey("10"));
        if (state == 0) {
            gui.registerButton(new IC2Button(0, x + 25, y + 15, 8, 10, "<"));
            gui.registerButton(new IC2Button(1, x + 52, y + 15, 8, 10, ">"));
            gui.registerButton(new IC2Button(2, x + 12, y + 27, 10, 20, "<"));
            gui.registerButton(new IC2Button(3, x + 155, y + 27, 10, 20, ">"));
            gui.registerButton(new IconButton(4, x + 89, y + 27, 20, 20).setItemStack(cancelIcon).addText(Ic2GuiLang.tradeDeleteTrade));
            gui.registerButton(new IconButton(5, x + 67, y + 27, 20, 20).setItemStack(new ItemStack(Items.field_151121_aF)).addText(Ic2GuiLang.tradeNewTrade));
            gui.registerButton(new IconButton(6, x + 89, y + 49, 20, 20).setItemStack(cancelIcon).addText(Ic2GuiLang.tradeDeleteSubTrade));
            gui.registerButton(new IconButton(7, x + 67, y + 49, 20, 20).setItemStack(new ItemStack(Items.field_151122_aG)).addText(Ic2GuiLang.tradeAddCustomTrade));
            gui.registerButton(new IconButton(8, x + 89, y + 71, 20, 20).setItemStack(new ItemStack(Items.field_151164_bB)).addText(Ic2GuiLang.tradeCustomInfo));
        } else if (state == 1) {
            ItemTradeFabricator.ItemTradeRules rule = this.trade.fab.getRules(this.trade.currentSubTrade);
            gui.registerButton(new IC2Button(20, x + 25, y + 15, 8, 10, "<"));
            gui.registerButton(new ToolTipButton(21, x + 52, y + 15, 8, 10, ">").addText(Ic2GuiLang.tradeNewSubTrade));
            gui.registerButton(new ToggleButton(24, x + 90, y + 27, 20, 20).setIcons(cancelIcon, okIcon).addToolTip(Ic2GuiLang.tradeSetCreative).setState(rule.creative));
            gui.registerButton(new ToggleButton(25, x + 65, y + 27, 20, 20).setIcons(cancelIcon, okIcon).addToolTip(Ic2GuiLang.tradeSetMoney).setState(rule.money));
            gui.registerButton(new ToggleButton(28, x + 90, y + 49, 20, 20).setIcons(cancelIcon, okIcon).addToolTip(Ic2GuiLang.tradeSetDelay).setState(rule.waitingAfterBuy));
            gui.registerButton(new ToggleButton(29, x + 65, y + 49, 20, 20).setIcons(cancelIcon, okIcon).addToolTip(Ic2GuiLang.tradeSetCap).setState(rule.tradeLimit));
            gui.registerButton(new IconButton(22, x + 90, y + 80, 20, 20).setItemStack(cancelIcon).addText(Ic2GuiLang.tradeCancelTrade));
            gui.registerButton(new IconButton(23, x + 65, y + 80, 20, 20).setItemStack(okIcon).addText(Ic2GuiLang.tradeFinalizeTrade));
            gui.registerButton(new ToolTipButton(38, x + 115, y + 60, 8, 10, "-").addComponents(list));
            gui.registerButton(new ToolTipButton(39, x + 160, y + 60, 8, 10, "+").addComponents(list));
            if (rule.money) {
                gui.registerButton(new ToolTipButton(32, x - 68, y + 45, 30, 12, "-").addComponents(list));
                gui.registerButton(new ToolTipButton(33, x - 35, y + 45, 30, 12, "+").addComponents(list));
            } else {
                gui.registerButton(new ToggleButton(30, x + 175, y, 20, 20).setIcons(okIcon, cancelIcon).addToolTip(Ic2GuiLang.tradeUseNBT).setState(rule.ignoreNBT));
                gui.registerButton(new ToggleButton(31, x + 175, y + 21, 20, 20).setIcons(cancelIcon, okIcon).addToolTip(Ic2GuiLang.tradeUseOreDict).setState(rule.useOreDictionary));
            }
            if (rule.tradeLimit) {
                gui.registerButton(new ToolTipButton(34, x - 68, y + 95, 30, 12, "-").addComponents(list));
                gui.registerButton(new ToolTipButton(35, x - 35, y + 95, 30, 12, "+").addComponents(list));
            }
            if (rule.waitingAfterBuy) {
                List<LocaleComp> timeList = Arrays.asList(Ic2GuiLang.getCombined(Ic2GuiLang.buttonCtrl, time, Ic2GuiLang.day), Ic2GuiLang.getCombined(Ic2GuiLang.buttonShift, time, Ic2GuiLang.hour), Ic2GuiLang.getCombined(Ic2GuiLang.buttonAlt, time, Ic2GuiLang.minute));
                gui.registerButton(new ToolTipButton(36, x - 68, y + 145, 30, 12, "-").addComponents(timeList));
                gui.registerButton(new ToolTipButton(37, x - 35, y + 145, 30, 12, "+").addComponents(timeList));
            }
        } else if (state == 2) {
            gui.registerButton(new IC2Button(50, x + 25, y + 15, 8, 10, "<"));
            gui.registerButton(new ToolTipButton(51, x + 52, y + 15, 8, 10, ">"));
            gui.registerButton(new IC2Button(52, x + 12, y + 27, 10, 20, "<"));
            gui.registerButton(new IC2Button(53, x + 155, y + 27, 10, 20, ">"));
            gui.registerButton(new IconButton(54, x + 90, y + 80, 20, 20).setItemStack(cancelIcon).addText(Ic2GuiLang.tradeCancelTrade));
            gui.registerButton(new IconButton(55, x + 65, y + 80, 20, 20).setItemStack(okIcon).addText(Ic2GuiLang.tradeLoad));
            gui.registerButton(new IconButton(8, x + 89, y + 27, 20, 20).setItemStack(new ItemStack(Items.field_151164_bB)).addText(Ic2GuiLang.tradeCustomInfo));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onButtonClick(GuiIC2 gui, GuiButton button) {
        int id = button.field_146127_k;
        ContainerEnergyOMatOpen open = gui.getContainer(ContainerEnergyOMatOpen.class);
        if (this.showText) {
            this.ticks = 0;
            this.infoText.clear();
        }
        if (id == 0) {
            if (this.clientData.canMoveSubTrade(false)) {
                this.clientData.moveSubTrade(false);
            }
        } else if (id == 1) {
            if (this.clientData.canMoveSubTrade(true)) {
                this.clientData.moveSubTrade(true);
            }
        } else if (id == 2) {
            if (this.clientData.canMoveTrade(false)) {
                this.trade.getNetwork().initiateClientTileEntityEvent(this.trade, 0);
            }
        } else if (id == 3) {
            if (this.clientData.canMoveTrade(true)) {
                this.trade.getNetwork().initiateClientTileEntityEvent(this.trade, 1);
            }
        } else if (id == 4) {
            if (this.clientData.focus != null) {
                this.trade.getNetwork().initiateClientTileEntityEvent(this.trade, 2);
            }
        } else if (id == 5) {
            this.trade.state = 1;
            this.currentCustomTrades.clear();
            this.trade.getNetwork().initiateClientTileEntityEvent(this.trade, 0, 1);
            open.unlock();
        } else if (id == 6) {
            if (this.clientData.focus instanceof IModifyableTrade) {
                this.trade.getNetwork().initiateClientTileEntityEvent(this.trade, 2, this.clientData.currentSubTrade);
            }
        } else if (id == 7) {
            this.trade.state = 2;
            this.currentCustomTrades.clear();
            this.trade.getNetwork().initiateClientTileEntityEvent(this.trade, 0, 2);
            open.lock();
        } else if (id == 8) {
            if (!this.showText) {
                this.showText = true;
                this.ticks = 500;
                return;
            }
            if (this.showText && this.ticks == 0) {
                this.showText = false;
            }
        } else if (id == 20) {
            if (this.trade.currentSubTrade > 0) {
                this.trade.getNetwork().initiateClientTileEntityEvent(this.trade, 4, -1);
            }
        } else if (id == 21) {
            if (this.trade.currentSubTrade < 3 && this.canDoNextSubTrade()) {
                this.trade.getNetwork().initiateClientTileEntityEvent(this.trade, 4, 1 + (gui.func_146271_m() ? 1 : 0) + (gui.func_146272_n() ? 2 : 0));
                ++this.trade.currentSubTrade;
                gui.requestGuiReload();
            }
        } else if (id == 22) {
            this.trade.state = 0;
            this.currentCustomTrades.clear();
            this.trade.fab.clear();
            this.trade.getNetwork().initiateClientTileEntityEvent(this.trade, 0, 0);
            open.lock();
        } else if (id == 23) {
            this.currentCustomTrades.clear();
            this.trade.fab.clear();
            open.lock();
            this.trade.state = 0;
            this.trade.getNetwork().initiateClientTileEntityEvent(this.trade, 10, 0);
        } else if (id >= 24 && id <= 31) {
            int value = id - 24;
            ItemTradeFabricator.ItemTradeRules rules = this.trade.fab.getRules(this.trade.currentSubTrade);
            if (value == 0) {
                rules.creative = !rules.creative;
            } else if (value == 1) {
                boolean bl = rules.money = !rules.money;
                if (rules.money) {
                    open.lockInput();
                } else {
                    open.unlockInput();
                }
            } else if (value == 4) {
                rules.waitingAfterBuy = !rules.waitingAfterBuy;
            } else if (value == 5) {
                rules.tradeLimit = !rules.tradeLimit;
            } else if (value == 6) {
                rules.ignoreNBT = !rules.ignoreNBT;
            } else if (value == 7) {
                rules.useOreDictionary = !rules.useOreDictionary;
            }
            this.trade.getNetwork().initiateClientTileEntityEvent(this.trade, 5, value);
        } else if (id == 32 || id == 33) {
            int newValue;
            ItemTradeFabricator.ItemTradeRules rules = this.trade.fab.getRules(this.trade.currentSubTrade);
            int value = this.getButtonNumber();
            if (id == 32) {
                value = -value;
            }
            if (rules.moneyNeeded != (newValue = Math.min(Short.MAX_VALUE, Math.max(1, value + rules.moneyNeeded)))) {
                rules.moneyNeeded = newValue;
                this.trade.getNetwork().initiateClientTileEntityEvent(this.trade, 6, newValue);
            }
        } else if (id == 34 || id == 35) {
            int newValue;
            ItemTradeFabricator.ItemTradeRules rules = this.trade.fab.getRules(this.trade.currentSubTrade);
            int value = this.getButtonNumber();
            if (id == 34) {
                value = -value;
            }
            if (rules.limitPerPlayer != (newValue = Math.min(Short.MAX_VALUE, Math.max(1, value + rules.limitPerPlayer)))) {
                rules.limitPerPlayer = newValue;
                this.trade.getNetwork().initiateClientTileEntityEvent(this.trade, 7, newValue);
            }
        } else if (id == 36 || id == 37) {
            int newValue;
            ItemTradeFabricator.ItemTradeRules rules = this.trade.fab.getRules(this.trade.currentSubTrade);
            int value = this.getTimeNumber();
            if (id == 36) {
                value = -value;
            }
            if (rules.waitingTime != (newValue = Math.min(172799980, Math.max(20, value + rules.waitingTime)))) {
                rules.waitingTime = newValue;
                this.trade.getNetwork().initiateClientTileEntityEvent(this.trade, 8, newValue);
            }
        } else if (id == 38 || id == 39) {
            int newValue;
            int value = this.getButtonNumber();
            if (id == 38) {
                value = -value;
            }
            if ((newValue = Math.min(Integer.MAX_VALUE, Math.max(0, this.trade.currentEnergy.getValue() + value))) != this.trade.currentEnergy.getValue()) {
                this.trade.getNetwork().initiateClientTileEntityEvent(this.trade, 11, newValue);
            }
        } else if (id == 50) {
            if (this.clientData.canMoveTrade(false)) {
                this.clientData.moveSubTrade(false);
            }
        } else if (id == 51) {
            if (this.clientData.canMoveTrade(true)) {
                this.clientData.moveSubTrade(true);
            }
        } else if (id == 52) {
            if (this.clientData.canMoveTrade(false)) {
                this.server.moveDir(-1);
                this.clientData.loadFromServer(this.server);
            }
        } else if (id == 53) {
            if (this.clientData.canMoveTrade(true)) {
                this.server.moveDir(1);
                this.clientData.loadFromServer(this.server);
            }
        } else if (id == 54) {
            this.trade.state = 0;
            this.trade.fab.clear();
            this.currentCustomTrades.clear();
            this.trade.getNetwork().initiateClientTileEntityEvent(this.trade, 0, 0);
            open.lock();
        } else if (id == 55) {
            PayloadFieldPacket payload = new PayloadFieldPacket(1, 0, 0);
            payload.addString(0, this.currentCustomTrades.get(this.clientData.focus));
            this.trade.state = 0;
            this.trade.fab.clear();
            this.currentCustomTrades.clear();
            this.trade.getNetwork().initiateClientTileEntityEvent(this.trade, 0, 0);
            this.trade.getNetwork().initiateCustomClientTileEntityEvent(this.trade, payload);
            open.lock();
        }
        gui.requestGuiReload();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onGuiTick(GuiIC2 gui) {
        block15: {
            ContainerEnergyOMatOpen open;
            int state;
            block14: {
                state = this.trade.state;
                if (state == 0) {
                    gui.getButton((int)0).field_146124_l = this.clientData.canMoveSubTrade(false);
                    gui.getButton((int)1).field_146124_l = this.clientData.canMoveSubTrade(true);
                    gui.getButton((int)2).field_146124_l = this.clientData.canMoveTrade(false);
                    gui.getButton((int)3).field_146124_l = this.clientData.canMoveTrade(true);
                    gui.getButton((int)4).field_146124_l = this.clientData.focus != null;
                    gui.getButton((int)6).field_146124_l = this.clientData.getSubTrade() != null && this.canRemoveSubTrade();
                } else if (state == 1) {
                    gui.getButton((int)20).field_146124_l = this.trade.currentSubTrade > 0;
                    gui.getButton((int)21).field_146124_l = this.canDoNextSubTrade() && this.trade.currentSubTrade < 2;
                    gui.getButton((int)23).field_146124_l = this.canDoNextSubTrade();
                    gui.getButton((int)24).field_146125_m = gui.getPlayer().field_71075_bZ.field_75098_d;
                } else if (state == 2) {
                    gui.getButton((int)50).field_146124_l = this.clientData.canMoveSubTrade(false);
                    gui.getButton((int)51).field_146124_l = this.clientData.canMoveSubTrade(true);
                    gui.getButton((int)52).field_146124_l = this.clientData.canMoveTrade(false);
                    gui.getButton((int)53).field_146124_l = this.clientData.canMoveTrade(true);
                    boolean bl = gui.getButton((int)55).field_146124_l = this.clientData.focus != null && this.clientData.getSubTrade() != null;
                }
                if (state == 1) {
                    return;
                }
                open = gui.getContainer(ContainerEnergyOMatOpen.class);
                if (state != 0) break block14;
                open.clear();
                ISubTrade sub = this.clientData.getSubTrade();
                if (sub == null) {
                    return;
                }
                int slot = 0;
                List<ItemStack> list = sub.isMoneyTrade() ? this.trade.generateCoins(sub.getNeededMoney()) : sub.getRequiredItems(gui.getPlayerID());
                for (ItemStack stack : list) {
                    open.func_75141_a(slot, stack);
                    if (++slot <= 7) continue;
                    break;
                }
                slot = 0;
                this.trade.currentEnergy.reset();
                for (Integer amount : sub.getTrade().getTradeResults(sub)) {
                    this.trade.currentEnergy.increase(amount);
                }
                break block15;
            }
            if (state != 2) break block15;
            if (this.server.hasNoTrades()) {
                Map<String, ITrade> customTrades = IC2.manager.getCustomTrades(TradeType.Energy);
                ArrayList<ITrade> trades = new ArrayList<ITrade>();
                for (Map.Entry<String, ITrade> entry : customTrades.entrySet()) {
                    ITrade tradeEntry = entry.getValue().newInstance(gui.getPlayerID());
                    this.currentCustomTrades.put(tradeEntry, entry.getKey());
                    trades.add(tradeEntry);
                }
                this.server.addTrades(trades);
                this.clientData.loadFromServer(this.server);
            }
            open.clear();
            ISubTrade sub = this.clientData.getSubTrade();
            if (sub == null) {
                return;
            }
            int slot = 0;
            List<ItemStack> list = sub.isMoneyTrade() ? this.trade.generateCoins(sub.getNeededMoney()) : sub.getRequiredItems(gui.getPlayerID());
            Iterator<Object> iterator = list.iterator();
            while (iterator.hasNext()) {
                ItemStack stack = (ItemStack)iterator.next();
                open.func_75141_a(slot, stack);
                if (++slot <= 7) continue;
                break;
            }
            slot = 0;
            this.trade.currentEnergy.reset();
            for (Integer amount : sub.getTrade().getTradeResults(sub)) {
                this.trade.currentEnergy.increase(amount);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawBackground(GuiIC2 gui, int mouseX, int mouseY, float particalTicks) {
        if (this.trade.state == 1) {
            int x = gui.getXOffset();
            int y = gui.getYOffset();
            ItemTradeFabricator.ItemTradeRules rule = this.trade.fab.getRules(this.trade.currentSubTrade);
            if (rule.money) {
                gui.func_73729_b(x - 73, y + 20, 0, 192, 73, 43);
            }
            if (rule.tradeLimit) {
                gui.func_73729_b(x - 73, y + 70, 0, 192, 73, 43);
            }
            if (rule.waitingAfterBuy) {
                gui.func_73729_b(x - 73, y + 120, 0, 192, 73, 43);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawFrontground(GuiIC2 gui, int mouseX, int mouseY) {
        if (this.trade.state == 1) {
            ItemTradeFabricator.ItemTradeRules rule = this.trade.fab.getRules(this.trade.currentSubTrade);
            if (rule.money) {
                gui.drawString(Ic2GuiLang.tradeMoneyNeeded, -69, 22, 0x404040);
                gui.drawString("" + rule.moneyNeeded, -69, 32, 0x404040);
            }
            if (rule.tradeLimit) {
                gui.drawString(Ic2GuiLang.tradeTradingCap, -69, 73, 0x404040);
                gui.drawString("" + rule.limitPerPlayer, -69, 83, 0x404040);
            }
            if (rule.waitingAfterBuy) {
                gui.drawString(Ic2GuiLang.tradeDelay, -69, 123, 0x404040);
                DecimalFormat form = Ic2Formatters.timeFormat;
                int delay = rule.waitingTime / 20;
                int seconds = delay % 60;
                int minutes = delay / 60 % 60;
                int hours = delay / 3600 % 24;
                int days = delay / 86400;
                gui.drawString("" + form.format(days) + ":" + form.format(hours) + ":" + form.format(minutes) + ":" + form.format(seconds), -69, 133, 0x404040);
            }
        }
        gui.drawCenteredString(Ic2GuiLang.tradeEnergyProvided, 140, 50, 0x404040);
        gui.drawCenteredString("" + this.trade.currentEnergy.getValue(), 140, 60, 0x404040);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onToolTipCollecting(GuiIC2 gui, int mouseX, int mouseY, List<String> tooltips) {
        if (!this.showText) {
            if (this.infoText.size() > 0) {
                this.infoText.clear();
            }
            return;
        }
        if (this.infoText.isEmpty()) {
            ISubTrade sub = this.clientData.getSubTrade();
            if (sub == null) {
                this.infoText.add(Ic2GuiLang.tradeNothing.getLocalized());
                return;
            }
            List<String> tooltip = sub.getToolTip();
            if (tooltip == null || tooltip.isEmpty()) {
                this.infoText.add(Ic2GuiLang.tradeNothing.getLocalized());
                return;
            }
            this.infoText.addAll(tooltip);
            return;
        }
        if (--this.ticks <= 0) {
            this.infoText.clear();
            this.showText = false;
            return;
        }
        tooltips.addAll(this.infoText);
    }

    public boolean canRemoveSubTrade() {
        return this.clientData.focus instanceof IModifyableTrade;
    }

    public boolean canDoNextSubTrade() {
        if (this.trade.currentEnergy.getValue() == 0) {
            return false;
        }
        boolean input = this.trade.fab.getRules((int)this.trade.currentSubTrade).money;
        if (input) {
            return true;
        }
        for (int i = 0; i < 8; ++i) {
            ItemStack in = this.trade.display.getStackInSlot(i);
            if (in == null) continue;
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int getButtonNumber() {
        if (GuiScreen.func_146271_m()) {
            return 1000;
        }
        if (GuiScreen.func_146272_n()) {
            return 100;
        }
        if (GuiScreen.func_175283_s()) {
            return 10;
        }
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public int getTimeNumber() {
        if (GuiScreen.func_146271_m()) {
            return 1728000;
        }
        if (GuiScreen.func_146272_n()) {
            return 72000;
        }
        if (GuiScreen.func_175283_s()) {
            return 1200;
        }
        return 20;
    }
}

