/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.playerrevive;

import com.creativemd.creativecore.common.gui.container.SubContainer;
import com.creativemd.creativecore.common.gui.container.SubGui;
import com.creativemd.creativecore.common.gui.opener.CustomGuiHandler;
import com.creativemd.creativecore.common.gui.opener.GuiHandler;
import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.playerrevive.api.IRevival;
import com.creativemd.playerrevive.api.capability.CapaRevive;
import com.creativemd.playerrevive.config.PlayerReviveConfig;
import com.creativemd.playerrevive.gui.SubContainerRevive;
import com.creativemd.playerrevive.gui.SubGuiRevive;
import com.creativemd.playerrevive.packet.ReviveUpdatePacket;
import com.creativemd.playerrevive.server.PlayerReviveServer;
import com.creativemd.playerrevive.server.ReviveEventServer;
import java.util.UUID;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(modid="playerrevive", version="1.0", name="Player Revive", acceptedMinecraftVersions="", dependencies="required-before:creativecore")
public class PlayerRevive {
    @SidedProxy(clientSide="com.creativemd.playerrevive.client.PlayerReviveClient", serverSide="com.creativemd.playerrevive.server.PlayerReviveServer")
    public static PlayerReviveServer proxy;
    public static SoundEvent deathSound;
    public static SoundEvent revivedSound;
    public static final String modid = "playerrevive";
    public static final String version = "1.0";
    public static int playerReviveTime;
    public static int playerReviveSurviveTime;
    public static int playerHealthAfter;
    public static int playerFoodAfter;
    public static boolean banPlayerAfterDeath;
    public static Configuration config;
    public static float volumeModifier;
    public static float exhaustion;
    public static boolean disableMusic;
    public static boolean disableSounds;
    public static boolean disableBleedingMessage;
    public static boolean particleBeacon;
    public static boolean disableGiveUp;
    public static boolean disableDisconnect;

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<SoundEvent> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new SoundEvent[]{deathSound, revivedSound});
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandBase(){

            public String func_71518_a(ICommandSender sender) {
                return "revive a bleeding player";
            }

            public String func_71517_b() {
                return "revive";
            }

            public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
                EntityPlayer player = null;
                if (args.length > 1) {
                    player = server.func_184103_al().func_152612_a(args[0]);
                } else if (sender instanceof EntityPlayer) {
                    player = (EntityPlayer)sender;
                }
                if (player != null) {
                    PlayerReviveServer.revive(player);
                }
            }

            public boolean func_82358_a(String[] args, int index) {
                return index == 1;
            }
        });
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        volumeModifier = config.getFloat("volume", "Sound", 1.0f, 0.0f, 2.0f, "Volume of the music played while bleeding");
        playerReviveTime = config.getInt("playerReviveTime", "General", playerReviveTime, 1, Integer.MAX_VALUE, "How long it takes to revive someone (in ticks). Will not be synchronized, therefore it's recommended to install IGCM.");
        playerReviveSurviveTime = config.getInt("playerReviveSurviveTime", "General", playerReviveSurviveTime, 1, Integer.MAX_VALUE, "How long a bleeding player will survive (in ticks). Will not be synchronized, therefore it's recommended to install IGCM.");
        playerHealthAfter = config.getInt("playerHealthAfter", "General", playerHealthAfter, 1, 20, "How much health a player will have after being revived.");
        playerFoodAfter = config.getInt("playerFoodAfter", "General", playerFoodAfter, 1, 20, "How much food a player will have after being revived.");
        banPlayerAfterDeath = config.getBoolean("banPlayerAfterDeath", "General", banPlayerAfterDeath, "If true someone who died will be banned from the server.");
        exhaustion = config.getFloat("exhaustion", "General", exhaustion, 0.0f, 10000.0f, "How exhausted helping players are (determines how much food will be drained).");
        disableMusic = config.getBoolean("disableMusic", "Sound", false, "Disable revive and dead sound");
        disableSounds = config.getBoolean("disableSounds", "Sound", false, "Disable revive and dead sound");
        disableBleedingMessage = config.getBoolean("disableBleedingMessage", "General", false, "");
        particleBeacon = config.getBoolean("particleBeacon", "General", false, "Will spawn particles above the player hinted at his location.");
        disableGiveUp = config.getBoolean("disableGiveUp", "General", false, "Disables give up button");
        disableDisconnect = config.getBoolean("disableDisconnect", "General", false, "Disables disconnect button");
        config.save();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        CreativeCorePacket.registerPacket(ReviveUpdatePacket.class, (String)"PRUpdate");
        GuiHandler.registerGuiHandler((String)"plrevive", (CustomGuiHandler)new CustomGuiHandler(){

            @SideOnly(value=Side.CLIENT)
            public SubGui getGui(EntityPlayer player, NBTTagCompound nbt) {
                return new SubGuiRevive();
            }

            public SubContainer getContainer(EntityPlayer player, NBTTagCompound nbt) {
                return new SubContainerRevive(player, PlayerReviveServer.getRevival(player), false);
            }
        });
        GuiHandler.registerGuiHandler((String)"plreviver", (CustomGuiHandler)new CustomGuiHandler(){

            @SideOnly(value=Side.CLIENT)
            public SubGui getGui(EntityPlayer player, NBTTagCompound nbt) {
                return new SubGuiRevive();
            }

            public SubContainer getContainer(EntityPlayer player, NBTTagCompound nbt) {
                IRevival revive = null;
                revive = player.field_70170_p.field_72995_K ? PlayerReviveServer.getRevival(player.field_70170_p.func_152378_a(UUID.fromString(nbt.func_74779_i("uuid")))) : PlayerReviveServer.getRevival((EntityPlayer)player.func_184102_h().func_184103_al().func_177451_a(UUID.fromString(nbt.func_74779_i("uuid"))));
                return new SubContainerRevive(player, revive, true);
            }
        });
        CapaRevive.register();
        MinecraftForge.EVENT_BUS.register((Object)new ReviveEventServer());
        proxy.loadSide();
        if (Loader.isModLoaded((String)"igcm")) {
            PlayerReviveConfig.loadConfig();
        }
    }

    static {
        deathSound = (SoundEvent)new SoundEvent(new ResourceLocation(modid, "death")).setRegistryName(new ResourceLocation(modid, "death"));
        revivedSound = (SoundEvent)new SoundEvent(new ResourceLocation(modid, "revived")).setRegistryName(new ResourceLocation(modid, "revived"));
        playerReviveTime = 100;
        playerReviveSurviveTime = 1200;
        playerHealthAfter = 2;
        playerFoodAfter = 6;
        banPlayerAfterDeath = false;
        volumeModifier = 1.0f;
        exhaustion = 0.5f;
        disableMusic = false;
        disableSounds = false;
        disableBleedingMessage = false;
        particleBeacon = false;
    }
}

