/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.playerrevive;

import com.creativemd.playerrevive.PlayerRevive;
import com.creativemd.playerrevive.api.CombatTrackerClone;
import com.creativemd.playerrevive.api.DamageBledToDeath;
import com.creativemd.playerrevive.api.IRevival;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;

public class Revival
implements IRevival {
    private boolean healty = true;
    private float progress = 0.0f;
    private int timeLeft;
    private DamageSource lastSource;
    private CombatTrackerClone trackerClone;
    public final ArrayList<EntityPlayer> revivingPlayers = new ArrayList();

    public Revival() {
        this.timeLeft = PlayerRevive.playerReviveSurviveTime;
    }

    @Override
    public void tick() {
        --this.timeLeft;
        this.progress += (float)this.revivingPlayers.size();
        for (int i = 0; i < this.revivingPlayers.size(); ++i) {
            this.revivingPlayers.get(i).func_71020_j(PlayerRevive.exhaustion);
        }
    }

    @Override
    public List<EntityPlayer> getRevivingPlayers() {
        return this.revivingPlayers;
    }

    @Override
    public boolean isHealty() {
        return this.healty;
    }

    @Override
    public void stopBleeding() {
        this.timeLeft = PlayerRevive.playerReviveSurviveTime;
        this.progress = 0.0f;
        this.healty = true;
        this.lastSource = null;
        this.trackerClone = null;
    }

    @Override
    public void startBleeding(EntityPlayer player, DamageSource source) {
        this.healty = false;
        this.progress = 0.0f;
        this.timeLeft = PlayerRevive.playerReviveSurviveTime;
        this.lastSource = source;
        this.trackerClone = new CombatTrackerClone(player.func_110142_aN());
    }

    @Override
    public float getProgress() {
        return this.progress;
    }

    @Override
    public boolean isRevived() {
        return this.progress >= (float)PlayerRevive.playerReviveTime;
    }

    @Override
    public boolean isDead() {
        return this.timeLeft <= 0;
    }

    @Override
    public int getTimeLeft() {
        return this.timeLeft;
    }

    @Override
    public void kill() {
        this.timeLeft = 0;
        this.progress = 0.0f;
        this.healty = true;
        this.lastSource = null;
        this.trackerClone = null;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("timeLeft", this.timeLeft);
        nbt.func_74776_a("progress", this.progress);
        nbt.func_74757_a("healty", this.healty);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.timeLeft = nbt.func_74762_e("timeLeft");
        this.progress = nbt.func_74760_g("progress");
        this.healty = nbt.func_74767_n("healty");
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeToNBT(nbt);
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.readFromNBT(nbt);
    }

    @Override
    public DamageSource getSource() {
        if (this.lastSource != null) {
            return this.lastSource;
        }
        return DamageBledToDeath.bledToDeath;
    }

    @Override
    public CombatTrackerClone getTrackerClone() {
        return this.trackerClone;
    }
}

