/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.playerrevive.client;

import com.creativemd.creativecore.common.gui.container.SubGui;
import com.creativemd.creativecore.common.gui.mc.ContainerSub;
import com.creativemd.creativecore.common.gui.opener.GuiHandler;
import com.creativemd.playerrevive.PlayerRevive;
import com.creativemd.playerrevive.api.IRevival;
import com.creativemd.playerrevive.client.TensionSound;
import com.creativemd.playerrevive.gui.SubContainerRevive;
import com.creativemd.playerrevive.gui.SubGuiRevive;
import com.creativemd.playerrevive.server.PlayerReviveServer;
import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ReviveEventClient {
    public static Minecraft mc = Minecraft.func_71410_x();
    public static Field sleeping = ReflectionHelper.findField(EntityPlayer.class, (String[])new String[]{"sleeping", "field_71083_bS"});
    public boolean lastShader = false;
    public boolean lastHighTension = false;
    public static TensionSound sound;

    @SubscribeEvent
    public void renderPlayer(RenderPlayerEvent.Pre event) {
        EntityPlayer player = event.getEntityPlayer();
        IRevival revive = PlayerReviveServer.getRevival(player);
        if (!revive.isHealty()) {
            if (PlayerRevive.particleBeacon) {
                for (int i = 0; i < 4; ++i) {
                    double size = Math.random();
                    double random = Math.random() * Math.PI;
                    player.field_70170_p.func_175688_a(EnumParticleTypes.SUSPENDED_DEPTH, player.field_70165_t - 1.0 + Math.sin(random) * size, player.field_70163_u + (Math.random() - 0.5) * 50.0, player.field_70161_v + Math.cos(random) * size, 0.0, 0.0, 0.0, new int[0]);
                }
            } else {
                double percentage = 1.0 - (double)revive.getTimeLeft() / (double)PlayerRevive.playerReviveSurviveTime;
                int amount = (int)Math.floor(percentage * 1.3);
                for (int i = 0; i < amount; ++i) {
                    player.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, player.field_70165_t - 1.0, player.field_70163_u, player.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
                }
            }
            player.field_71079_bU = 0.0f;
            player.field_71082_cx = 0.0f;
            player.field_71089_bV = 0.0f;
            try {
                sleeping.set(event.getEntityPlayer(), true);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public void renderPlayer(RenderPlayerEvent.Post event) {
        IRevival revive = PlayerReviveServer.getRevival(event.getEntityPlayer());
        if (!revive.isHealty()) {
            try {
                sleeping.set(event.getEntityPlayer(), false);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public void cameraSetup(EntityViewRenderEvent.CameraSetup event) {
        IRevival revive = PlayerReviveServer.getRevival((EntityPlayer)ReviveEventClient.mc.field_71439_g);
        if (!revive.isHealty()) {
            GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)-1.5);
            event.setYaw(0.0f);
            event.setPitch(-90.0f);
        }
    }

    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        IRevival revive = PlayerReviveServer.getRevival(event.player);
        if (!revive.isHealty() && event.player != ReviveEventClient.mc.field_71439_g) {
            AxisAlignedBB axisalignedbb = event.player.func_174813_aQ();
            double width = 0.6;
            double height = 1.8;
            event.player.func_174826_a(new AxisAlignedBB(event.player.field_70165_t - height, event.player.field_70163_u - width / 2.0, event.player.field_70161_v - width / 2.0, event.player.field_70165_t, event.player.field_70163_u + width / 2.0, event.player.field_70161_v + width / 2.0));
        }
    }

    @SubscribeEvent
    public void tick(TickEvent.RenderTickEvent event) {
        EntityPlayerSP player = ReviveEventClient.mc.field_71439_g;
        if (event.phase == TickEvent.Phase.END && player != null) {
            IRevival revive = PlayerReviveServer.getRevival((EntityPlayer)player);
            SubGuiRevive gui = null;
            if (player.field_71070_bA instanceof ContainerSub) {
                for (SubGui subGui : ((ContainerSub)player.field_71070_bA).gui.getLayers()) {
                    if (!(subGui instanceof SubGuiRevive)) continue;
                    gui = (SubGuiRevive)subGui;
                }
            }
            if (revive.isHealty()) {
                this.lastHighTension = false;
                if (this.lastShader) {
                    ReviveEventClient.mc.field_71460_t.func_175066_a(mc.func_175606_aa());
                    this.lastShader = false;
                }
                if (sound != null) {
                    mc.func_147118_V().func_147683_b((ISound)sound);
                    sound = null;
                }
                if (gui != null && !((SubContainerRevive)gui.container).isHelping) {
                    ((SubContainerRevive)gui.container).isHelping = true;
                    gui.closeGui();
                }
            } else {
                if (revive.getTimeLeft() < 400) {
                    if (!this.lastHighTension) {
                        if (!PlayerRevive.disableMusic) {
                            mc.func_147118_V().func_147683_b((ISound)sound);
                            sound = new TensionSound(new ResourceLocation("playerrevive", "hightension"), PlayerRevive.volumeModifier, 1.0f, false);
                            mc.func_147118_V().func_147682_a((ISound)sound);
                        }
                        this.lastHighTension = true;
                    }
                } else if (!this.lastShader) {
                    if (sound != null) {
                        mc.func_147118_V().func_147683_b((ISound)sound);
                    }
                    if (!PlayerRevive.disableMusic) {
                        sound = new TensionSound(new ResourceLocation("playerrevive", "tension"), PlayerRevive.volumeModifier, 1.0f, true);
                        mc.func_147118_V().func_147682_a((ISound)sound);
                    }
                }
                if (!this.lastShader) {
                    ReviveEventClient.mc.field_71460_t.func_175069_a(new ResourceLocation("shaders/post/blur.json"));
                    this.lastShader = true;
                }
                if (gui == null) {
                    GuiHandler.openGui((String)"plrevive", (NBTTagCompound)new NBTTagCompound());
                }
            }
        }
    }
}

