/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats;

import net.minecraftforge.common.config.Configuration;

public class RatConfig {
    public boolean spawnRats = true;
    public boolean spawnPiper = true;
    public int ratSpawnRate = 80;
    public int ratSpawnDecrease = 2;
    public int piperSpawnDecrease = 1;
    public int piperSpawnRate = 6;
    public float piperHatDropRate = 0.09f;
    public float plagueEssenceDropRate = 0.05f;
    public float archeologistHatSpawnRate = 0.12f;
    public float ratlanteanAutomatonHealth = 600.0f;
    public float ratlanteanAutomatonAttack = 6.0f;
    public float neoRatlanteanHealth = 300.0f;
    public float neoRatlanteanAttack = 8.0f;
    public boolean ratsSpawnLikeMonsters = true;
    public boolean cheesemaking = true;
    public boolean plagueRats = true;
    public int milkCauldronTime = 150;
    public boolean ratsDigBlocks = true;
    public boolean ratsBreakCrops = true;
    public boolean ratsStealItems = true;
    public boolean ratsContaminateFood = true;
    public boolean golemsTargetRats = true;
    public boolean villagePetShops = true;
    public boolean villageGarbageHeaps = true;
    public boolean villagePlagueDoctors = true;
    public boolean disablePlastic = false;
    public boolean ratsBreakBlockOnHarvest = true;
    public boolean plagueSpread = true;
    public boolean plagueHearts = true;
    public float ratStrengthThreshold = 4.0f;
    public int ratFluteDistance = 2;
    public int ratCageCramming = 4;
    public int ratUpdateDelay = 100;
    public int tokenDropRate = 10000;
    public String[] blacklistedRatBlocks = new String[0];
    public int[] blacklistedRatDimensions = new int[0];
    public boolean disableRatlantis = false;
    public int ratlantisDimensionId = -8;
    public int ratlantisPortalExitDimension = 0;
    public int maxDestroyedLeaves = 10000;
    public float blackDeathHealth = 400.0f;
    public float blackDeathAttack = 4.0f;
    public boolean ratsDespawn = true;
    public double ratDespawnFarDistance = 96.0;
    public double ratDespawnCloseDistance = 20.0;
    public int ratDespawnRandomChance = 400;
    public boolean ratFartNoises = true;
    public int ratRFTransferBasic = 100;
    public int ratRFTransferAdvanced = 500;
    public int ratRFTransferElite = 1000;
    public int ratRFTransferExtreme = 100000;
    public double ratVoodooDistance = 32.0;
    public boolean addLoot = true;

    public void init(Configuration config) {
        this.spawnRats = config.getBoolean("Spawn Rats", "all", true, "True if rats are to spawn naturally");
        this.ratSpawnDecrease = config.getInt("Rat Spawn Decrease", "all", 5, 0, Integer.MAX_VALUE, "A seperate random roll that only spawns rats if a one-out-of-X chance, x being this number. raise this number to make them more rare.");
        this.plagueRats = config.getBoolean("Plague Rats", "all", true, "True if plague rats are to spawn naturally");
        this.spawnPiper = config.getBoolean("Spawn Piper", "all", true, "True if Pied Pipers are to spawn naturally");
        this.piperSpawnDecrease = config.getInt("Piper Spawn Decrease", "all", 5, 0, Integer.MAX_VALUE, "A seperate random roll that only spawns pipers if a one-out-of-X chance, x being this number. raise this number to make them more rare.");
        this.ratSpawnRate = config.getInt("Rat Spawn Weight", "all", 80, 1, 300, "The weight of rats in vanilla's spawn rate");
        this.piperSpawnRate = config.getInt("Pied Piper Spawn Weight", "all", 6, 1, 300, "The weight of pied pipers in vanilla's spawn rate");
        this.piperHatDropRate = config.getFloat("Pied Piper Hat Drop Rate", "all", 0.09f, 0.0f, 1.0f, "percent chance for piper to drop hat on death");
        this.plagueEssenceDropRate = config.getFloat("Plague Essence Drop Rate", "all", 0.1f, 0.0f, 1.0f, "percent chance for plague rat to drop plague essence on death");
        this.archeologistHatSpawnRate = config.getFloat("Archeologist Hat Spawn Rate", "all", 0.12f, 0.0f, 1.0f, "percent chance for a husk or jungle skeleton to spawn with an archeologist hat");
        this.ratlanteanAutomatonHealth = config.getFloat("Ratlantean Automaton Max Health", "all", 600.0f, 0.0f, Float.MAX_VALUE, "Ratlantean Automaton Max Health");
        this.ratlanteanAutomatonAttack = config.getFloat("Ratlantean Automaton Attack Damage", "all", 6.0f, 0.0f, Float.MAX_VALUE, "Ratlantean Automaton Attack Damage");
        this.neoRatlanteanHealth = config.getFloat("Neo-Ratlantean Max Health", "all", 300.0f, 0.0f, Float.MAX_VALUE, "Neo-Ratlantean Max Health");
        this.neoRatlanteanAttack = config.getFloat("Neo-Ratlantean Automaton Attack Damage", "all", 8.0f, 0.0f, Float.MAX_VALUE, "Neo-Ratlantean Attack Damage");
        this.ratsBreakCrops = config.getBoolean("Rats Raid Crops", "all", true, "True if wild rats will destroy and eat crops");
        this.ratsStealItems = config.getBoolean("Rats Steal From Chests", "all", true, "True if wild rats will steal from chests");
        this.ratsContaminateFood = config.getBoolean("Rats Contaminate Food", "all", true, "True if wild rats contaminate food when they steal from chests");
        this.golemsTargetRats = config.getBoolean("Golems Target Rats", "all", true, "True if iron golems will attack wild rats");
        this.villagePetShops = config.getBoolean("Village Pet Shops", "all", true, "True if pet shops can spawn in villages");
        this.villageGarbageHeaps = config.getBoolean("Village Garbage Heap", "all", true, "True if garbage heaps can spawn in villages");
        this.villagePlagueDoctors = config.getBoolean("Village Plague Doctors", "all", true, "True if plague doctor huts can spawn in villages");
        this.ratsDigBlocks = config.getBoolean("Rats Dig Holes", "all", true, "True if rats can dig holes");
        this.ratsSpawnLikeMonsters = config.getBoolean("Rats Spawn Like Monsters", "all", true, "True if rats should spawn like monsters. False if they should only spawn once per world, like pigs and sheep.");
        this.ratsBreakBlockOnHarvest = config.getBoolean("Rats Break Crops on Harvest", "all", true, "True if tamed rats will destroy crops when they harvest them");
        this.ratFartNoises = config.getBoolean("Rat Fart Noises", "all", true, "True if rats should rarely make a funny noise when creating rats nuggets.");
        this.plagueSpread = config.getBoolean("Other Mobs can spread Plague", "all", true, "True if infected mobs with plague can spread it by interacting or attacking.");
        this.plagueHearts = config.getBoolean("Plague Heart Overlay", "all", true, "True if player UI has plague hearts render when the effect is active.");
        this.cheesemaking = config.getBoolean("Cheesemaking", "all", true, "True if cheese can be created in cauldrons");
        this.milkCauldronTime = config.getInt("Milk Curdling Time", "all", 150, 20, 1000000, "The time in ticks(20 per second) it takes for milk to turn into cheese in a cauldron");
        this.ratStrengthThreshold = config.getFloat("Rat Dig Strength", "all", 4.0f, 0.0f, 1000000.0f, "The max block hardness that rats are allowed to dig through. (Dirt = 0.5F, Cobblestone = 2.0F, Obsidian = 50.0F)");
        this.ratFluteDistance = config.getInt("Rat Flute Distance", "all", 2, 1, 100, "The how many chunks away can a rat here a rat flute");
        this.ratCageCramming = config.getInt("Rat Cage Max Occupancy", "all", 5, 1, 10000, "Rats will continue to breed in cages until there are this many rats in one cage block");
        this.ratUpdateDelay = config.getInt("Rat Upgrade Delay", "all", 100, 1, 10000, "Rats will conduct expensive CPU operations like looking for crops or chests, once every this number of ticks(with added standard deviation for servers)");
        this.blacklistedRatBlocks = config.getStringList("Blacklisted Rat Inventory Blocks", "all", new String[0], "Blacklist for blocks that rats are not allowed to steal from. Ex. \"minecraft:chest\" or \"rats:rat_crafting_table\"");
        this.blacklistedRatDimensions = config.get("all", "Blacklisted Rat Spawn Dimensions", new int[0], "Blacklist for dimensions that rats and pipers cannot spawn in").getIntList();
        this.tokenDropRate = config.getInt("Rat Token Drop Rate", "all", 10000, 1, Integer.MAX_VALUE, "1/This number chance for a rat to drop a Token");
        this.disableRatlantis = config.getBoolean("Disable Ratlantis", "all", false, "True if Ratlantis dimension is disabled - alternative methods of getting resources will be provided. WARNING: Leave the dimension and restart the game before changing this. You must be fun at parties.");
        this.disablePlastic = config.getBoolean("Disable Plastic", "all", false, "True if Plastic item is disabled - alternative methods of getting rat cage deco will be provided. WARNING: Leave the restard the game after changing this. You must be fun at parties.");
        this.ratlantisDimensionId = config.getInt("Ratlantis Dimension ID", "all", -8, Integer.MIN_VALUE, Integer.MAX_VALUE, "Ratlantis Dimension ID");
        this.ratlantisPortalExitDimension = config.getInt("Ratlantis Portal Exit Dimension ID", "all", 0, Integer.MIN_VALUE, Integer.MAX_VALUE, "What Dimension ID you are teleported to upon leaving Ratlantis");
        this.maxDestroyedLeaves = config.getInt("Rat Upgrade Lumberjack: Max Tree Blocks", "all", 10000, 0, Integer.MAX_VALUE, "How many blocks the Lumberjack Rat is able to destroy when felling a tree. Be careful when changing this to a large number.");
        this.blackDeathHealth = config.getFloat("Black Death Max Health", "all", 400.0f, 0.0f, Float.MAX_VALUE, "Black Death Max Health");
        this.blackDeathAttack = config.getFloat("Black Death Automaton Attack Damage", "all", 4.0f, 0.0f, Float.MAX_VALUE, "Black Death Attack Damage");
        this.ratsDespawn = config.getBoolean("Can Rats Despawn", "all", true, "True if wild, untamed rats can despawn.");
        this.ratDespawnFarDistance = config.getFloat("Rat Immediate Despawn Distance", "all", 96.0f, 0.0f, Float.MAX_VALUE, "Distance that untamed rats will immediately despawn. For Vanilla mobs, this is 128 blocks.");
        this.ratDespawnCloseDistance = config.getFloat("Rat Potential Despawn Distance", "all", 20.0f, 0.0f, Float.MAX_VALUE, "Distance that untamed rats could possibly despawn. For Vanilla mobs, this is 32 blocks.");
        this.ratDespawnRandomChance = config.getInt("Rat Potential Despawn Chance", "all", 400, 1, Integer.MAX_VALUE, "When a rat is farther than its potential despawn distance, a random roll is taken to see if it despawns. Lower this number will make rats more likely to despawn.");
        this.ratRFTransferBasic = config.getInt("Rat RF Transfer Rate Basic (kRF)", "all", 100, 1, Integer.MAX_VALUE, "How much kRF (1000 RF) a rat with a basic energy transfer upgrade can transport at a time.");
        this.ratRFTransferAdvanced = config.getInt("Rat RF Transfer Rate Advanced (kRF)", "all", 500, 1, Integer.MAX_VALUE, "How much kRF (1000 RF) a rat with an advanced energy transfer upgrade can transport at a time.");
        this.ratRFTransferElite = config.getInt("Rat RF Transfer Rate Elite (kRF)", "all", 1000, 1, Integer.MAX_VALUE, "How much kRF (1000 RF) a rat with an elite energy transfer upgrade can transport at a time.");
        this.ratRFTransferExtreme = config.getInt("Rat RF Transfer Rate Extreme (kRF)", "all", 100000, 1, Integer.MAX_VALUE, "How much kRF (1000 RF) a rat with an extreme energy transfer upgrade can transport at a time.");
        this.ratVoodooDistance = config.getFloat("Voodoo Doll Rat distance", "all", 32.0f, 0.0f, Float.MAX_VALUE, "How far away from players the Rat Upgrade: Voodoo Doll is effective.");
        this.addLoot = config.getBoolean("Add Loot", "all", true, "True if loot from rats can spawn in chests");
    }
}

