/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.client.event;

import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.server.misc.RatsSoundRegistry;
import java.util.Random;
import net.ilexiconn.llibrary.LLibrary;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ClientEvents {
    public static final ResourceLocation PLAGUE_HEART_TEXTURE = new ResourceLocation("rats:textures/gui/plague_hearts.png");
    private int updateCounter = 0;
    private int playerHealth = 0;
    private int lastPlayerHealth = 0;
    private long healthUpdateCounter = 0L;
    private long lastSystemTime = 0L;
    private Random rand = new Random();
    public static int left_height = 39;
    public static int right_height = 39;
    private float synesthesiaProgress = 0.0f;
    private float prevSynesthesiaProgress = 0.0f;
    private float maxSynesthesiaProgress = 40.0f;
    private static final ResourceLocation SYNESTHESIA = new ResourceLocation("rats:shaders/post/synesthesia.json");

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onPlayerInteract(RenderGameOverlayEvent.Pre event) {
        boolean highlight;
        if (event.getType() != RenderGameOverlayEvent.ElementType.HEALTH || event.isCanceled() || !Minecraft.func_71410_x().field_71439_g.func_70644_a(RatsMod.PLAGUE_POTION) || !RatsMod.CONFIG_OPTIONS.plagueHearts) {
            return;
        }
        left_height = 39;
        ScaledResolution resolution = event.getResolution();
        int width = resolution.func_78326_a();
        int height = resolution.func_78328_b();
        GlStateManager.func_179147_l();
        EntityPlayer player = (EntityPlayer)Minecraft.func_71410_x().func_175606_aa();
        int health = MathHelper.func_76123_f((float)player.func_110143_aJ());
        boolean bl = highlight = this.healthUpdateCounter > (long)this.updateCounter && (this.healthUpdateCounter - (long)this.updateCounter) / 3L % 2L == 1L;
        if (health < this.playerHealth && player.field_70172_ad > 0) {
            this.lastSystemTime = Minecraft.func_71386_F();
            this.healthUpdateCounter = this.updateCounter + 20;
        } else if (health > this.playerHealth && player.field_70172_ad > 0) {
            this.lastSystemTime = Minecraft.func_71386_F();
            this.healthUpdateCounter = this.updateCounter + 10;
        }
        if (Minecraft.func_71386_F() - this.lastSystemTime > 1000L) {
            this.playerHealth = health;
            this.lastPlayerHealth = health;
            this.lastSystemTime = Minecraft.func_71386_F();
        }
        this.playerHealth = health;
        int healthLast = this.lastPlayerHealth;
        IAttributeInstance attrMaxHealth = player.func_110148_a(SharedMonsterAttributes.field_111267_a);
        float healthMax = (float)attrMaxHealth.func_111126_e();
        float absorb = MathHelper.func_76123_f((float)player.func_110139_bj());
        int healthRows = MathHelper.func_76123_f((float)((healthMax + absorb) / 2.0f / 10.0f));
        int rowHeight = Math.max(10 - (healthRows - 2), 3);
        this.rand.setSeed(this.updateCounter * 312871);
        int left = width / 2 - 91;
        int top = height - left_height;
        left_height += healthRows * rowHeight;
        if (rowHeight != 10) {
            left_height += 10 - rowHeight;
        }
        int regen = -1;
        if (player.func_70644_a(MobEffects.field_76428_l)) {
            regen = this.updateCounter % 25;
        }
        boolean TOP = false;
        int MARGIN = 0;
        int BACKGROUND = 9;
        float absorbRemaining = absorb;
        for (int i = MathHelper.func_76123_f((float)((healthMax + absorb) / 2.0f)) - 1; i >= 0; --i) {
            int row = MathHelper.func_76123_f((float)((float)(i + 1) / 10.0f)) - 1;
            int x = left + i % 10 * 8;
            int y = top - row * rowHeight;
            if (health <= 4) {
                y += this.rand.nextInt(2);
            }
            if (i == regen) {
                y -= 2;
            }
            this.drawTexturedModalRect(x, y, MARGIN, BACKGROUND, 9, 9);
            if (highlight) {
                if (i * 2 + 1 < healthLast) {
                    this.drawTexturedModalRect(x, y, MARGIN, 0, 9, 9);
                } else if (i * 2 + 1 == healthLast) {
                    this.drawTexturedModalRect(x, y, MARGIN + 9, 0, 9, 9);
                }
            }
            if (absorbRemaining > 0.0f) {
                if (absorbRemaining == absorb && absorb % 2.0f == 1.0f) {
                    this.drawTexturedModalRect(x, y, MARGIN, 0, 9, 9);
                    absorbRemaining -= 1.0f;
                    continue;
                }
                this.drawTexturedModalRect(x, y, MARGIN + 9, 0, 9, 9);
                absorbRemaining -= 2.0f;
                continue;
            }
            if (i * 2 + 1 < health) {
                this.drawTexturedModalRect(x, y, MARGIN, 0, 9, 9);
                continue;
            }
            if (i * 2 + 1 != health) continue;
            this.drawTexturedModalRect(x, y, MARGIN + 9, 0, 9, 9);
        }
        GlStateManager.func_179084_k();
        Minecraft.func_71410_x().field_71424_I.func_76319_b();
    }

    private void drawTexturedModalRect(int x, int y, int textureX, int textureY, int width, int height) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(PLAGUE_HEART_TEXTURE);
        Minecraft.func_71410_x().field_71456_v.func_73729_b(x, y, textureX, textureY, width, height);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() == Minecraft.func_71410_x().field_71439_g) {
            boolean synesthesia;
            EntityRenderer renderer = Minecraft.func_71410_x().field_71460_t;
            PotionEffect active = event.getEntityLiving().func_70660_b(RatsMod.CONFIT_BYALDI_POTION);
            boolean bl = synesthesia = active != null;
            if (synesthesia && !renderer.func_147702_a()) {
                renderer.func_175069_a(SYNESTHESIA);
            }
            if (!synesthesia && renderer.func_147702_a() && renderer != null && renderer.func_147706_e() != null && renderer.func_147706_e().func_148022_b() != null && SYNESTHESIA.toString().equals(renderer.func_147706_e().func_148022_b())) {
                renderer.func_181022_b();
            }
            if (this.prevSynesthesiaProgress == 2.0f && synesthesia) {
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)RatsSoundRegistry.POTION_EFFECT_BEGIN, (float)1.0f));
            }
            if (this.prevSynesthesiaProgress == 38.0f && !synesthesia) {
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)RatsSoundRegistry.POTION_EFFECT_END, (float)1.0f));
            }
            this.prevSynesthesiaProgress = this.synesthesiaProgress;
            if (synesthesia && this.synesthesiaProgress < this.maxSynesthesiaProgress) {
                this.synesthesiaProgress += 2.0f;
            } else if (!synesthesia && this.synesthesiaProgress > 0.0f) {
                this.synesthesiaProgress -= 2.0f;
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onGetFOVModifier(EntityViewRenderEvent.FOVModifier event) {
        if (event.getEntity() == Minecraft.func_71410_x().field_71439_g && this.prevSynesthesiaProgress > 0.0f) {
            float prog = this.prevSynesthesiaProgress + (this.synesthesiaProgress - this.prevSynesthesiaProgress) * LLibrary.PROXY.getPartialTicks();
            float renderProg = this.prevSynesthesiaProgress > this.synesthesiaProgress ? (float)Math.sin((double)(prog / this.maxSynesthesiaProgress) * Math.PI) * 40.0f : -((float)Math.sin((double)(prog / this.maxSynesthesiaProgress) * Math.PI)) * 40.0f;
            event.setFOV(event.getFOV() + renderProg);
        }
    }
}

