/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.client.render.entity;

import com.github.alexthe666.rats.client.model.ModelRat;
import com.github.alexthe666.rats.client.render.entity.RenderRat;
import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;

public class LayerRatPlague
implements LayerRenderer<EntityRat> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("rats:textures/entity/rat/rat_plague_overlay.png");
    private static final ResourceLocation TEXTURE_LUMBERJACK = new ResourceLocation("rats:textures/entity/rat/rat_lumberjack_upgrade.png");
    private static final ResourceLocation TEXTURE_TOGA = new ResourceLocation("rats:textures/entity/rat/toga.png");
    private static final ResourceLocation TEXTURE_RATINATOR = new ResourceLocation("rats:textures/entity/rat/rat_ratinator_upgrade.png");
    private static final ResourceLocation TEXTURE_PSYCHIC = new ResourceLocation("rats:textures/entity/ratlantis/psychic.png");
    private static final ModelRat RAT_MODEL = new ModelRat(0.5f);
    private final RenderRat ratRenderer;

    public LayerRatPlague(RenderRat ratRendererIn) {
        this.ratRenderer = ratRendererIn;
    }

    public void doRenderLayer(EntityRat rat, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        if (!(this.ratRenderer.func_177087_b() instanceof ModelRat)) {
            return;
        }
        if (rat.hasPlague()) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179108_z();
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            this.ratRenderer.func_110776_a(TEXTURE);
            this.ratRenderer.func_177087_b().func_78088_a((Entity)rat, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
            GlStateManager.func_179084_k();
            GlStateManager.func_179133_A();
        }
        if (rat.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_BASIC_ENERGY) && rat.getHeldRF() > 0) {
            float alpha = (float)rat.getHeldRF() / Math.max(1.0f, (float)rat.getRFTransferRate());
            GlStateManager.func_179094_E();
            boolean flag = true;
            GlStateManager.func_179132_a((!flag ? 1 : 0) != 0);
            this.ratRenderer.func_110776_a(TEXTURE_PSYCHIC);
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179096_D();
            float f = (float)rat.field_70173_aa + partialTicks;
            GlStateManager.func_179109_b((float)(f * 0.01f), (float)(f * 0.01f), (float)0.0f);
            GlStateManager.func_179128_n((int)5888);
            GlStateManager.func_179147_l();
            GlStateManager.func_179131_c((float)0.5f, (float)0.5f, (float)0.5f, (float)alpha);
            GlStateManager.func_179140_f();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            Minecraft.func_71410_x().field_71460_t.func_191514_d(true);
            RAT_MODEL.func_78088_a((Entity)rat, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
            Minecraft.func_71410_x().field_71460_t.func_191514_d(false);
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179096_D();
            GlStateManager.func_179128_n((int)5888);
            GlStateManager.func_179145_e();
            GlStateManager.func_179084_k();
            GlStateManager.func_179132_a((boolean)flag);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179121_F();
        }
        if (rat.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_RATINATOR)) {
            this.ratRenderer.func_110776_a(TEXTURE_RATINATOR);
            this.ratRenderer.func_177087_b().func_78088_a((Entity)rat, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
        }
        if (rat.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_LUMBERJACK)) {
            this.ratRenderer.func_110776_a(TEXTURE_LUMBERJACK);
            this.ratRenderer.func_177087_b().func_78088_a((Entity)rat, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
        }
        if (rat.hasToga()) {
            this.ratRenderer.func_110776_a(TEXTURE_TOGA);
            this.ratRenderer.func_177087_b().func_78088_a((Entity)rat, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
        }
    }

    public boolean func_177142_b() {
        return false;
    }
}

