/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.client.render.entity;

import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.client.model.ModelPinkie;
import com.github.alexthe666.rats.client.model.ModelRat;
import com.github.alexthe666.rats.client.render.entity.LayerRatEyes;
import com.github.alexthe666.rats.client.render.entity.LayerRatHeldItem;
import com.github.alexthe666.rats.client.render.entity.LayerRatHelmet;
import com.github.alexthe666.rats.client.render.entity.LayerRatPlague;
import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderRat
extends RenderLiving<EntityRat> {
    private static final Map<String, ResourceLocation> LAYERED_LOCATION_CACHE = Maps.newHashMap();
    private static final ModelRat RAT_MODEL = new ModelRat(0.0f);
    private static final ModelPinkie PINKIE_MODEL = new ModelPinkie();
    private static final ResourceLocation PINKIE_TEXTURE = new ResourceLocation("rats:textures/entity/rat/baby.png");
    private static final ResourceLocation ENDER_UPGRADE_TEXTURE = new ResourceLocation("rats:textures/entity/rat/rat_ender_upgrade.png");
    private static final ResourceLocation AQUATIC_UPGRADE_TEXTURE = new ResourceLocation("rats:textures/entity/rat/rat_aquatic_upgrade.png");
    private static final ResourceLocation DRAGON_UPGRADE_TEXTURE = new ResourceLocation("rats:textures/entity/rat/rat_dragon_upgrade.png");
    private static final ResourceLocation JULIAN = new ResourceLocation("rats:textures/entity/rat/patreon/rat_julian.png");
    private static final ResourceLocation SHIZUKA = new ResourceLocation("rats:textures/entity/rat/patreon/rat_shizuka.png");
    private static final ResourceLocation SHARVA = new ResourceLocation("rats:textures/entity/rat/patreon/rat_sharva.png");

    public RenderRat() {
        super(Minecraft.func_71410_x().func_175598_ae(), (ModelBase)RAT_MODEL, 0.15f);
        this.func_177094_a(new LayerRatPlague(this));
        this.func_177094_a(new LayerRatEyes(this));
        this.func_177094_a((LayerRenderer)new LayerRatHelmet(this));
        this.func_177094_a(new LayerRatHeldItem(this));
    }

    protected boolean canRenderName(EntityRat entity) {
        return RatsMod.PROXY.shouldRenderNameplates() && super.func_177070_b((EntityLiving)entity);
    }

    protected void renderModel(EntityRat rat, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor) {
        boolean flag1;
        boolean flag = this.func_193115_c((EntityLivingBase)rat);
        boolean bl = flag1 = !flag && !rat.func_98034_c((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        if (flag || flag1) {
            if (!this.func_180548_c((Entity)rat)) {
                return;
            }
            if (flag1) {
                GlStateManager.func_187408_a((GlStateManager.Profile)GlStateManager.Profile.TRANSPARENT_MODEL);
            }
            this.field_77045_g = rat.func_70631_g_() ? PINKIE_MODEL : RAT_MODEL;
            this.field_77045_g.func_78088_a((Entity)rat, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor);
            if (flag1) {
                GlStateManager.func_187440_b((GlStateManager.Profile)GlStateManager.Profile.TRANSPARENT_MODEL);
            }
        }
    }

    public boolean shouldRender(EntityRat rat, ICamera camera, double camX, double camY, double camZ) {
        if (rat.func_184218_aH() && rat.func_184187_bx() != null && rat.func_184187_bx().func_184188_bt().size() >= 1 && rat.func_184187_bx().func_184188_bt().get(0) == rat && rat.func_184187_bx() instanceof EntityLivingBase && ((EntityLivingBase)rat.func_184187_bx()).func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b() == RatsItemRegistry.CHEF_TOQUE) {
            return false;
        }
        return super.func_177071_a((EntityLiving)rat, camera, camX, camY, camZ);
    }

    protected void preRenderCallback(EntityRat rat, float partialTickTime) {
        GL11.glScaled((double)0.6f, (double)0.6f, (double)0.6f);
        if (rat.func_184218_aH() && rat.func_184187_bx() != null && rat.func_184187_bx().func_184188_bt().size() >= 1 && rat.func_184187_bx() instanceof EntityPlayer) {
            Render playerRender;
            Entity riding = rat.func_184187_bx();
            if (riding.func_184188_bt().get(0) != null && riding.func_184188_bt().get(0) == rat && (playerRender = Minecraft.func_71410_x().func_175598_ae().func_78713_a(riding)) instanceof RenderLivingBase && ((RenderLivingBase)playerRender).func_177087_b() instanceof ModelBiped) {
                ((ModelBiped)((RenderLivingBase)playerRender).func_177087_b()).field_78116_c.func_78794_c(0.0625f);
                GlStateManager.func_179137_b((double)0.0, (double)-0.7f, (double)0.25);
            }
        } else {
            float f7 = rat.prevFlyingPitch + (rat.flyingPitch - rat.prevFlyingPitch) * partialTickTime;
            GL11.glRotatef((float)rat.flyingPitch, (float)1.0f, (float)0.0f, (float)0.0f);
        }
    }

    protected ResourceLocation getEntityTexture(EntityRat entity) {
        ResourceLocation resourcelocation;
        String s = entity.getRatTexture();
        if (entity.func_70631_g_()) {
            return PINKIE_TEXTURE;
        }
        if (entity.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_DRAGON)) {
            return DRAGON_UPGRADE_TEXTURE;
        }
        if (entity.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_ENDER)) {
            return ENDER_UPGRADE_TEXTURE;
        }
        if (entity.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_AQUATIC)) {
            return AQUATIC_UPGRADE_TEXTURE;
        }
        if (!entity.func_95999_t().isEmpty()) {
            if (entity.func_95999_t().contains("julian") || entity.func_95999_t().contains("Julian")) {
                return JULIAN;
            }
            if (entity.func_95999_t().contains("shizuka") || entity.func_95999_t().contains("Shizuka")) {
                return SHIZUKA;
            }
            if (entity.func_95999_t().contains("sharva") || entity.func_95999_t().contains("Sharva")) {
                return SHARVA;
            }
        }
        if ((resourcelocation = LAYERED_LOCATION_CACHE.get(s)) == null) {
            resourcelocation = new ResourceLocation(s);
            LAYERED_LOCATION_CACHE.put(s, resourcelocation);
        }
        return resourcelocation;
    }

    protected float getDeathMaxRotation(EntityRat rat) {
        return rat.isDeadInTrap ? 0.0f : 90.0f;
    }
}

