/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server;

import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.server.blocks.BlockGenericSlab;
import com.github.alexthe666.rats.server.blocks.RatsBlockRegistry;
import com.github.alexthe666.rats.server.entity.EntityBlackDeath;
import com.github.alexthe666.rats.server.entity.EntityCheeseCannonball;
import com.github.alexthe666.rats.server.entity.EntityFeralRatlantean;
import com.github.alexthe666.rats.server.entity.EntityGolemBeam;
import com.github.alexthe666.rats.server.entity.EntityIllagerPiper;
import com.github.alexthe666.rats.server.entity.EntityLaserBeam;
import com.github.alexthe666.rats.server.entity.EntityLaserPortal;
import com.github.alexthe666.rats.server.entity.EntityMarbleCheeseGolem;
import com.github.alexthe666.rats.server.entity.EntityNeoRatlantean;
import com.github.alexthe666.rats.server.entity.EntityPirat;
import com.github.alexthe666.rats.server.entity.EntityPiratBoat;
import com.github.alexthe666.rats.server.entity.EntityPlagueBeast;
import com.github.alexthe666.rats.server.entity.EntityPlagueCloud;
import com.github.alexthe666.rats.server.entity.EntityPlagueDoctor;
import com.github.alexthe666.rats.server.entity.EntityPlagueShot;
import com.github.alexthe666.rats.server.entity.EntityPurifyingLiquid;
import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.entity.EntityRatArrow;
import com.github.alexthe666.rats.server.entity.EntityRatCaptureNet;
import com.github.alexthe666.rats.server.entity.EntityRatDragonFire;
import com.github.alexthe666.rats.server.entity.EntityRatlanteanFlame;
import com.github.alexthe666.rats.server.entity.EntityRatlanteanSpirit;
import com.github.alexthe666.rats.server.entity.EntityThrownBlock;
import com.github.alexthe666.rats.server.entity.EntityVialOfSentience;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import com.github.alexthe666.rats.server.items.RatsUpgradeConflictRegistry;
import com.github.alexthe666.rats.server.misc.RatsSoundRegistry;
import com.github.alexthe666.rats.server.world.RatsWorldRegistry;
import com.github.alexthe666.rats.server.world.village.RatsVillageRegistry;
import java.lang.reflect.Field;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.potion.Potion;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class CommonProxy {
    @SubscribeEvent
    public static void registerPotions(RegistryEvent.Register<Potion> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Potion[]{RatsMod.CONFIT_BYALDI_POTION, RatsMod.PLAGUE_POTION});
    }

    @SubscribeEvent
    public static void registerSoundEvents(RegistryEvent.Register<SoundEvent> event) {
        try {
            for (Field f : RatsSoundRegistry.class.getDeclaredFields()) {
                Object obj = f.get(null);
                if (obj instanceof SoundEvent) {
                    event.getRegistry().register((IForgeRegistryEntry)((SoundEvent)obj));
                    continue;
                }
                if (!(obj instanceof SoundEvent[])) continue;
                for (SoundEvent sound : (SoundEvent[])obj) {
                    event.getRegistry().register((IForgeRegistryEntry)sound);
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @SubscribeEvent
    public static void registerVillagers(RegistryEvent.Register<VillagerRegistry.VillagerProfession> event) {
        event.getRegistry().register((IForgeRegistryEntry)RatsVillageRegistry.PET_SHOP_OWNER);
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        try {
            for (Field f : RatsBlockRegistry.class.getDeclaredFields()) {
                Object obj = f.get(null);
                if (obj instanceof Block) {
                    event.getRegistry().register((IForgeRegistryEntry)((Block)obj));
                    continue;
                }
                if (!(obj instanceof Block[])) continue;
                for (Block block : (Block[])obj) {
                    event.getRegistry().register((IForgeRegistryEntry)block);
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @SubscribeEvent
    public static void registerItemBlocks(RegistryEvent.Register<Item> event) {
        try {
            for (Field f : RatsBlockRegistry.class.getDeclaredFields()) {
                Object obj = f.get(null);
                if (obj instanceof Block) {
                    ItemBlock itemBlock = new ItemBlock((Block)obj);
                    if (obj instanceof BlockGenericSlab) {
                        itemBlock = ((BlockGenericSlab)((Object)obj)).getItemBlock();
                    }
                    itemBlock.setRegistryName(((Block)obj).getRegistryName());
                    event.getRegistry().register((IForgeRegistryEntry)itemBlock);
                    continue;
                }
                if (!(obj instanceof Block[])) continue;
                for (Block block : (Block[])obj) {
                    ItemBlock itemBlock = new ItemBlock(block);
                    if (block instanceof BlockGenericSlab) {
                        itemBlock = ((BlockGenericSlab)((Object)obj)).getItemBlock();
                    }
                    itemBlock.setRegistryName(block.getRegistryName());
                    event.getRegistry().register((IForgeRegistryEntry)itemBlock);
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        try {
            for (Field f : RatsItemRegistry.class.getDeclaredFields()) {
                Object obj = f.get(null);
                if (obj instanceof Item) {
                    if ((obj == RatsItemRegistry.PLASTIC_WASTE || obj == RatsItemRegistry.RAW_PLASTIC) && RatsMod.CONFIG_OPTIONS.disablePlastic) continue;
                    event.getRegistry().register((IForgeRegistryEntry)((Item)obj));
                    continue;
                }
                if (!(obj instanceof Item[])) continue;
                for (Item item : (Item[])obj) {
                    event.getRegistry().register((IForgeRegistryEntry)item);
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        RatsUpgradeConflictRegistry.init();
    }

    @SubscribeEvent
    public static void registerBiomes(RegistryEvent.Register<Biome> event) {
        event.getRegistry().register((IForgeRegistryEntry)RatsWorldRegistry.RATLANTIS_BIOME);
    }

    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityEntry> event) {
        CommonProxy.registerSpawnable(EntityEntryBuilder.create(), event, EntityRat.class, "rat", 1, 0x30333E, 14330785);
        CommonProxy.registerSpawnable(EntityEntryBuilder.create(), event, EntityIllagerPiper.class, "illager_piper", 2, 13286466, 3891299);
        CommonProxy.registerSpawnable(EntityEntryBuilder.create(), event, EntityRatlanteanSpirit.class, "ratlantean_spirit", 3, 15580416, 16771247);
        CommonProxy.registerUnspawnable(EntityEntryBuilder.create(), event, EntityRatlanteanFlame.class, "ratlantean_flame", 4);
        CommonProxy.registerSpawnable(EntityEntryBuilder.create(), event, EntityMarbleCheeseGolem.class, "marbled_cheese_golem", 5, 15262935, 7530837);
        CommonProxy.registerUnspawnable(EntityEntryBuilder.create(), event, EntityGolemBeam.class, "marbled_cheese_golem_beam", 6);
        CommonProxy.registerSpawnable(EntityEntryBuilder.create(), event, EntityFeralRatlantean.class, "feral_ratlantean", 7, 0x30333E, 0xECECEC);
        CommonProxy.registerSpawnable(EntityEntryBuilder.create(), event, EntityNeoRatlantean.class, "neo_ratlantean", 8, 0x30333E, 61423);
        CommonProxy.registerUnspawnable(EntityEntryBuilder.create(), event, EntityLaserBeam.class, "laser_beam", 9);
        CommonProxy.registerUnspawnable(EntityEntryBuilder.create(), event, EntityLaserPortal.class, "neo_ratlantean_portal", 10);
        CommonProxy.registerUnspawnable(EntityEntryBuilder.create(), event, EntityThrownBlock.class, "thrown_block", 11);
        CommonProxy.registerUnspawnable(EntityEntryBuilder.create(), event, EntityVialOfSentience.class, "vial_of_sentience", 12);
        CommonProxy.registerUnspawnable(EntityEntryBuilder.create(), event, EntityPiratBoat.class, "pirat_boat", 13);
        CommonProxy.registerSpawnable(EntityEntryBuilder.create(), event, EntityPirat.class, "pirat", 14, 0x30333E, 11482682);
        CommonProxy.registerUnspawnable(EntityEntryBuilder.create(), event, EntityCheeseCannonball.class, "cheese_cannonball", 15);
        CommonProxy.registerSpawnable(EntityEntryBuilder.create(), event, EntityPlagueDoctor.class, "plague_doctor", 16, 0x2A292A, 5329753);
        CommonProxy.registerUnspawnable(EntityEntryBuilder.create(), event, EntityPurifyingLiquid.class, "purifying_liquid", 17);
        CommonProxy.registerSpawnable(EntityEntryBuilder.create(), event, EntityBlackDeath.class, "black_death", 18, 0, 0);
        CommonProxy.registerSpawnable(EntityEntryBuilder.create(), event, EntityPlagueCloud.class, "plague_cloud", 19, 0, 5396301);
        CommonProxy.registerSpawnable(EntityEntryBuilder.create(), event, EntityPlagueBeast.class, "plague_beast", 20, 0, 0xECECEC);
        CommonProxy.registerUnspawnable(EntityEntryBuilder.create(), event, EntityPlagueShot.class, "plague_shot", 21);
        CommonProxy.registerUnspawnable(EntityEntryBuilder.create(), event, EntityRatCaptureNet.class, "rat_capture_net", 22);
        CommonProxy.registerUnspawnable(EntityEntryBuilder.create(), event, EntityRatDragonFire.class, "rat_dragon_fire", 23);
        CommonProxy.registerUnspawnable(EntityEntryBuilder.create(), event, EntityRatArrow.class, "rat_arrow", 24);
        EntitySpawnPlacementRegistry.setPlacementType(EntityPirat.class, (EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.IN_WATER);
    }

    public static void registerSpawnable(EntityEntryBuilder builder, RegistryEvent.Register<EntityEntry> event, Class<? extends Entity> entityClass, String name, int id, int mainColor, int subColor) {
        builder.entity(entityClass);
        builder.id(new ResourceLocation("rats", name), id);
        builder.name(name);
        builder.egg(mainColor, subColor);
        builder.tracker(64, 1, true);
        event.getRegistry().register((IForgeRegistryEntry)builder.build());
    }

    public static void registerUnspawnable(EntityEntryBuilder builder, RegistryEvent.Register<EntityEntry> event, Class<? extends Entity> entityClass, String name, int id) {
        builder.entity(entityClass);
        builder.id(new ResourceLocation("rats", name), id);
        builder.name(name);
        builder.tracker(64, 1, true);
        event.getRegistry().register((IForgeRegistryEntry)builder.build());
    }

    public void preInit() {
    }

    public void init() {
    }

    public void postInit() {
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase("rats")) {
            RatsMod.syncConfig();
        }
    }

    public Object getArmorModel(int index) {
        return null;
    }

    public boolean shouldRenderNameplates() {
        return true;
    }

    public void openCheeseStaffGui() {
    }

    public EntityRat getRefrencedRat() {
        return null;
    }

    public void setRefrencedRat(EntityRat rat) {
    }

    public void setCheeseStaffContext(BlockPos pos, EnumFacing facing) {
    }

    public void spawnParticle(String name, double x, double y, double z, double motX, double motY, double motZ) {
    }
}

