/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.blocks;

import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.server.blocks.RatsBlockRegistry;
import com.github.alexthe666.rats.server.entity.EntityMarbleCheeseGolem;
import com.google.common.base.Predicate;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.BlockWorldState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMaterialMatcher;
import net.minecraft.block.state.pattern.BlockPattern;
import net.minecraft.block.state.pattern.BlockStateMatcher;
import net.minecraft.block.state.pattern.FactoryBlockPattern;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockMarbledCheeseRatHead
extends BlockHorizontal {
    private static final AxisAlignedBB HALF_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
    private static final Predicate<IBlockState> IS_MARBLE = new Predicate<IBlockState>(){

        public boolean apply(@Nullable IBlockState p_apply_1_) {
            return p_apply_1_ != null && (p_apply_1_.func_177230_c() == RatsBlockRegistry.MARBLED_CHEESE_RAW || p_apply_1_.func_177230_c() == RatsBlockRegistry.MARBLED_CHEESE || p_apply_1_.func_177230_c() == RatsBlockRegistry.MARBLED_CHEESE_PILLAR || p_apply_1_.func_177230_c() == RatsBlockRegistry.MARBLED_CHEESE_TILE || p_apply_1_.func_177230_c() == RatsBlockRegistry.MARBLED_CHEESE_CHISELED || p_apply_1_.func_177230_c() == RatsBlockRegistry.MARBLED_CHEESE_BRICK || p_apply_1_.func_177230_c() == RatsBlockRegistry.MARBLED_CHEESE_BRICK_CHISELED || p_apply_1_.func_177230_c() == RatsBlockRegistry.MARBLED_CHEESE_BRICK_MOSSY || p_apply_1_.func_177230_c() == RatsBlockRegistry.MARBLED_CHEESE_BRICK_CRACKED);
        }
    };
    private BlockPattern golemBasePattern;
    private BlockPattern golemPattern;

    public BlockMarbledCheeseRatHead() {
        super(Material.field_151576_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_185512_D, (Comparable)EnumFacing.NORTH));
        this.func_149675_a(true);
        this.func_149647_a(RatsMod.TAB);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149711_c(2.5f);
        this.func_149663_c("rats.marbled_cheese_rat_head");
        this.setRegistryName("rats", "marbled_cheese_rat_head");
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return HALF_AABB;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        BlockMarbledCheeseRatHead.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)HALF_AABB);
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        super.func_176213_c(worldIn, pos, state);
        this.trySpawnGolem(worldIn, pos);
    }

    public boolean canDispenserPlace(World worldIn, BlockPos pos) {
        return this.getGolemBasePattern().func_177681_a(worldIn, pos) != null;
    }

    private void trySpawnGolem(World worldIn, BlockPos pos) {
        BlockPattern.PatternHelper blockpattern$patternhelper = this.getGolemPattern().func_177681_a(worldIn, pos);
        if (blockpattern$patternhelper != null) {
            for (int j = 0; j < this.getGolemPattern().func_177684_c(); ++j) {
                for (int k = 0; k < this.getGolemPattern().func_177685_b(); ++k) {
                    worldIn.func_180501_a(blockpattern$patternhelper.func_177670_a(j, k, 0).func_177508_d(), Blocks.field_150350_a.func_176223_P(), 2);
                }
            }
            BlockPos blockpos = blockpattern$patternhelper.func_177670_a(1, 2, 0).func_177508_d();
            EntityMarbleCheeseGolem entityirongolem = new EntityMarbleCheeseGolem(worldIn);
            entityirongolem.func_70012_b((double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + 0.05, (double)blockpos.func_177952_p() + 0.5, 0.0f, 0.0f);
            worldIn.func_72838_d((Entity)entityirongolem);
            for (EntityPlayerMP entityplayermp1 : worldIn.func_72872_a(EntityPlayerMP.class, entityirongolem.func_174813_aQ().func_186662_g(5.0))) {
                CriteriaTriggers.field_192133_m.func_192229_a(entityplayermp1, (Entity)entityirongolem);
            }
            for (int j1 = 0; j1 < 120; ++j1) {
                worldIn.func_175688_a(EnumParticleTypes.SNOWBALL, (double)blockpos.func_177958_n() + worldIn.field_73012_v.nextDouble(), (double)blockpos.func_177956_o() + worldIn.field_73012_v.nextDouble() * 3.9, (double)blockpos.func_177952_p() + worldIn.field_73012_v.nextDouble(), 0.0, 0.0, 0.0, new int[0]);
            }
            for (int k1 = 0; k1 < this.getGolemPattern().func_177684_c(); ++k1) {
                for (int l1 = 0; l1 < this.getGolemPattern().func_177685_b(); ++l1) {
                    BlockWorldState blockworldstate1 = blockpattern$patternhelper.func_177670_a(k1, l1, 0);
                    worldIn.func_175722_b(blockworldstate1.func_177508_d(), Blocks.field_150350_a, false);
                }
            }
        }
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)field_185512_D, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)field_185512_D)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)field_185512_D)));
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)field_185512_D, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)field_185512_D, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176736_b();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_185512_D});
    }

    protected BlockPattern getGolemBasePattern() {
        if (this.golemBasePattern == null) {
            this.golemBasePattern = FactoryBlockPattern.func_177660_a().func_177659_a(new String[]{"~ ~", "#X#", "~#~"}).func_177662_a('#', BlockWorldState.func_177510_a(IS_MARBLE)).func_177662_a('~', BlockWorldState.func_177510_a((Predicate)BlockMaterialMatcher.func_189886_a((Material)Material.field_151579_a))).func_177662_a('X', BlockWorldState.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)RatsBlockRegistry.MARBLED_CHEESE_GOLEM_CORE))).func_177661_b();
        }
        return this.golemBasePattern;
    }

    protected BlockPattern getGolemPattern() {
        if (this.golemPattern == null) {
            this.golemPattern = FactoryBlockPattern.func_177660_a().func_177659_a(new String[]{"~^~", "#X#", "~#~"}).func_177662_a('^', BlockWorldState.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)RatsBlockRegistry.MARBLED_CHEESE_RAT_HEAD))).func_177662_a('#', BlockWorldState.func_177510_a(IS_MARBLE)).func_177662_a('~', BlockWorldState.func_177510_a((Predicate)BlockMaterialMatcher.func_189886_a((Material)Material.field_151579_a))).func_177662_a('X', BlockWorldState.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)RatsBlockRegistry.MARBLED_CHEESE_GOLEM_CORE))).func_177661_b();
        }
        return this.golemPattern;
    }
}

