/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity;

import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.server.entity.EntityLaserBeam;
import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.misc.RatsSoundRegistry;
import com.google.common.base.Predicate;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.IMob;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class EntityLaserPortal
extends Entity {
    public static final Predicate<Entity> MONSTER_NOT_RAT = new Predicate<Entity>(){

        public boolean apply(@Nullable Entity entity) {
            return entity != null && !(entity instanceof EntityRat) && entity instanceof IMob;
        }
    };
    public float scaleOfPortal;
    public float scaleOfPortalPrev;
    @Nullable
    private EntityLivingBase creator;
    @Nullable
    private Entity facingTarget;
    private UUID ownerUniqueId;

    public EntityLaserPortal(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.9f, 1.5f);
        this.field_70178_ae = true;
    }

    public EntityLaserPortal(World worldIn, double x, double y, double z) {
        this(worldIn);
        this.func_70105_a(0.9f, 1.5f);
        this.func_70107_b(x, y, z);
        this.field_70178_ae = true;
    }

    public EntityLaserPortal(World worldIn, double x, double y, double z, EntityLivingBase creator) {
        this(worldIn);
        this.func_70105_a(0.9f, 1.5f);
        this.func_70107_b(x, y, z);
        this.setCreator(creator);
        this.field_70178_ae = true;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa > 300) {
            this.func_70106_y();
        }
        if (this.field_70173_aa < 250 && this.scaleOfPortal < 1.0f) {
            this.scaleOfPortal += 0.05f;
        }
        if (this.field_70173_aa > 250 && this.scaleOfPortal > 0.0f) {
            this.scaleOfPortal -= 0.05f;
        }
        if (this.field_70173_aa % 50 == 0) {
            this.tryFiring();
        } else {
            this.faceTarget();
        }
        if (this.field_70170_p.field_72995_K && this.scaleOfPortal >= 0.5f) {
            RatsMod.PROXY.spawnParticle("rat_lightning", this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N) - (double)this.field_70130_N / 2.0, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N) - (double)this.field_70130_N / 2.0, 0.0, 0.0, 0.0);
        }
        this.scaleOfPortalPrev = this.scaleOfPortal;
    }

    private void faceTarget() {
        if ((this.facingTarget == null || this.getCreator() != null && !this.facingTarget.func_70028_i((Entity)((EntityLiving)this.getCreator()).func_70638_az())) && this.getCreator() != null && this.getCreator() instanceof EntityLiving) {
            EntityLivingBase target = ((EntityLiving)this.getCreator()).func_70638_az();
            if (target == null && this.getCreator() instanceof EntityMob) {
                target = this.field_70170_p.func_184136_b((Entity)this, 30.0);
            }
            this.facingTarget = target;
        }
        if (this.facingTarget != null) {
            double d0 = this.field_70165_t - this.facingTarget.field_70165_t;
            double d2 = this.field_70161_v - this.facingTarget.field_70161_v;
            float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.29577951308232) - 90.0f;
            this.field_70177_z = f % 360.0f;
        }
    }

    private void tryFiring() {
        if (this.getCreator() != null && this.getCreator() instanceof EntityLiving) {
            EntityLivingBase target = ((EntityLiving)this.getCreator()).func_70638_az();
            if (target == null && this.getCreator() instanceof EntityMob) {
                target = this.field_70170_p.func_184136_b((Entity)this, 30.0);
            }
            if (target == null && this.getCreator() instanceof EntityRat && ((EntityRat)this.getCreator()).func_70909_n()) {
                EntityLivingBase closest = null;
                for (Entity entity : this.field_70170_p.func_175674_a((Entity)this.getCreator(), this.func_174813_aQ().func_72314_b(40.0, 10.0, 40.0), MONSTER_NOT_RAT)) {
                    if (!(entity instanceof EntityLivingBase) || closest != null && !(entity.func_70068_e((Entity)this) < closest.func_70068_e((Entity)this))) continue;
                    closest = (EntityLivingBase)entity;
                }
                target = closest;
            }
            if (target != null) {
                double d0 = this.field_70165_t - target.field_70165_t;
                double d1 = this.field_70163_u - target.field_70163_u;
                double d2 = this.field_70161_v - target.field_70161_v;
                double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
                float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.29577951308232) - 90.0f;
                this.field_70177_z = f % 360.0f;
                double targetRelativeX = target.field_70165_t - this.field_70165_t;
                double targetRelativeY = target.field_70163_u + (double)(target.field_70131_O / 2.0f) - this.field_70163_u - 1.0;
                double targetRelativeZ = target.field_70161_v - this.field_70161_v;
                EntityLaserBeam beam = new EntityLaserBeam(this.field_70170_p, this.getCreator());
                this.func_184185_a(RatsSoundRegistry.LASER, 1.0f, 0.75f + this.field_70146_Z.nextFloat() * 0.5f);
                beam.func_70107_b(this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v);
                beam.func_70186_c(targetRelativeX, targetRelativeY, targetRelativeZ, 2.0f, 0.4f);
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_72838_d((Entity)beam);
                }
            }
        }
    }

    @Nullable
    public EntityLivingBase getCreator() {
        Entity entity;
        if (this.creator == null && this.ownerUniqueId != null && this.field_70170_p instanceof WorldServer && (entity = ((WorldServer)this.field_70170_p).func_175733_a(this.ownerUniqueId)) instanceof EntityLivingBase) {
            this.creator = (EntityLivingBase)entity;
        }
        return this.creator;
    }

    public void setCreator(@Nullable EntityLivingBase ownerIn) {
        this.creator = ownerIn;
        this.ownerUniqueId = ownerIn == null ? null : ownerIn.func_110124_au();
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.field_70173_aa = compound.func_74762_e("Age");
        this.ownerUniqueId = compound.func_186857_a("OwnerUUID");
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a("Age", this.field_70173_aa);
        if (this.ownerUniqueId != null) {
            compound.func_186854_a("OwnerUUID", this.ownerUniqueId);
        }
    }

    public EnumPushReaction func_184192_z() {
        return EnumPushReaction.IGNORE;
    }

    protected void func_70088_a() {
    }
}

