/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity;

import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.server.entity.EntityFeralRatlantean;
import com.github.alexthe666.rats.server.entity.EntityLaserPortal;
import com.github.alexthe666.rats.server.entity.EntityThrownBlock;
import com.github.alexthe666.rats.server.entity.IRatlantean;
import com.github.alexthe666.rats.server.message.MessageSyncThrownBlock;
import com.github.alexthe666.rats.server.misc.RatsSoundRegistry;
import com.google.common.base.Predicate;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.ilexiconn.llibrary.server.animation.IAnimatedEntity;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EntityNeoRatlantean
extends EntityMob
implements IAnimatedEntity,
IRangedAttackMob,
IRatlantean {
    public static final ResourceLocation LOOT = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("rats", "neo_ratlantean"));
    private static final Predicate<EntityLivingBase> NOT_RATLANTEAN = new Predicate<EntityLivingBase>(){

        public boolean apply(@Nullable EntityLivingBase entity) {
            return entity.func_70089_S() && !(entity instanceof IRatlantean);
        }
    };
    private static final DataParameter<Integer> COLOR_VARIANT = EntityDataManager.func_187226_a(EntityFeralRatlantean.class, (DataSerializer)DataSerializers.field_187192_b);
    private final BossInfoServer bossInfo = new BossInfoServer(this.func_145748_c_(), BossInfo.Color.BLUE, BossInfo.Overlay.PROGRESS);
    private int animationTick;
    private Animation currentAnimation;
    private int attackSelection = 0;
    private int summonCooldown = 0;
    private int humTicks = 0;

    public EntityNeoRatlantean(World worldIn) {
        super(worldIn);
        this.func_70606_j(this.func_110138_aP());
        this.func_70105_a(0.8f, 1.3f);
        ((PathNavigateGround)this.func_70661_as()).func_179693_d(true);
        this.field_70728_aV = 80;
        this.field_70765_h = new AIMoveControl(this);
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (this.field_70173_aa % 100 == 0) {
            this.func_70691_i(1.0f);
        }
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    public boolean func_184222_aU() {
        return false;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(COLOR_VARIANT, (Object)0);
    }

    public int getColorVariant() {
        return (Integer)this.field_70180_af.func_187225_a(COLOR_VARIANT);
    }

    public void setColorVariant(int color) {
        this.field_70180_af.func_187227_b(COLOR_VARIANT, (Object)color);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("ColorVariant", this.getColorVariant());
        compound.func_74768_a("AttackSelection", this.attackSelection);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setColorVariant(compound.func_74762_e("ColorVariant"));
        this.attackSelection = compound.func_74762_e("AttackSelection");
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_145748_c_());
        }
    }

    public void func_96094_a(String name) {
        super.func_96094_a(name);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        this.setColorVariant(this.func_70681_au().nextInt(4));
        return livingdata;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            RatsMod.PROXY.spawnParticle("rat_lightning", this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N) - (double)this.field_70130_N / 2.0, this.field_70163_u + (double)this.func_70047_e() + (double)(this.field_70146_Z.nextFloat() * 0.35f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N) - (double)this.field_70130_N / 2.0, 0.0, 0.0, 0.0);
        }
        if (this.summonCooldown > 0) {
            --this.summonCooldown;
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.humTicks % 80 == 0) {
            this.func_184185_a(RatsSoundRegistry.NEORATLANTEAN_LOOP, 1.0f, 1.0f);
        }
        ++this.humTicks;
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() != null) {
            int i;
            int bounds;
            EntityLivingBase entity = this.func_70638_az();
            if (this.attackSelection == 0 && this.summonCooldown == 0) {
                this.summonCooldown = 100;
                bounds = 5;
                for (i = 0; i < this.field_70146_Z.nextInt(3) + 3; ++i) {
                    EntityLaserPortal laserPortal = new EntityLaserPortal(this.field_70170_p, entity.field_70165_t + (double)this.field_70146_Z.nextInt(bounds * 2) - (double)bounds, this.field_70163_u + 2.0, entity.field_70161_v + (double)this.field_70146_Z.nextInt(bounds * 2) - (double)bounds, (EntityLivingBase)this);
                    this.field_70170_p.func_72838_d((Entity)laserPortal);
                }
                this.resetAttacks();
            }
            if (this.attackSelection == 1 && this.summonCooldown == 0) {
                bounds = 20;
                this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, false));
                for (i = 0; i < this.field_70146_Z.nextInt(3) + 2; ++i) {
                    this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, entity.field_70165_t + (double)this.field_70146_Z.nextInt(bounds * 2) - (double)bounds, entity.field_70163_u, entity.field_70161_v + (double)this.field_70146_Z.nextInt(bounds * 2) - (double)bounds, false));
                }
                this.summonCooldown = 100;
                this.resetAttacks();
            }
            if (this.attackSelection == 2 && this.summonCooldown == 0) {
                int searchRange = 10;
                BlockPos ourPos = new BlockPos((Entity)this);
                ArrayList<BlockPos> listOfAll = new ArrayList<BlockPos>();
                for (BlockPos pos : BlockPos.func_177980_a((BlockPos)ourPos.func_177982_a(-searchRange, -searchRange, -searchRange), (BlockPos)ourPos.func_177982_a(searchRange, searchRange, searchRange))) {
                    IBlockState state = this.field_70170_p.func_180495_p(pos);
                    if (this.field_70170_p.func_175623_d(pos) || !this.canPickupBlock(state)) continue;
                    listOfAll.add(pos);
                }
                boolean flag = false;
                if (listOfAll.size() > 0) {
                    BlockPos pos;
                    pos = (BlockPos)listOfAll.get(this.field_70146_Z.nextInt(listOfAll.size()));
                    EntityThrownBlock thrownBlock = new EntityThrownBlock(this.field_70170_p, this.field_70170_p.func_180495_p(pos), (EntityLivingBase)this);
                    thrownBlock.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
                    if (!this.field_70170_p.field_72995_K) {
                        this.field_70170_p.func_72838_d((Entity)thrownBlock);
                    }
                    RatsMod.NETWORK_WRAPPER.sendToAll((IMessage)new MessageSyncThrownBlock(thrownBlock.func_145782_y(), pos.func_177986_g()));
                    this.field_70170_p.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                    this.summonCooldown = 40;
                }
                this.resetAttacks();
            }
            if (this.attackSelection == 3 && this.summonCooldown == 0) {
                this.func_70638_az().func_70690_d(new PotionEffect(MobEffects.field_188423_x, 200));
                this.func_70638_az().func_70690_d(new PotionEffect(MobEffects.field_82731_v, 200));
                this.func_70638_az().func_70690_d(new PotionEffect(MobEffects.field_188424_y, 200));
                this.summonCooldown = 40;
                this.resetAttacks();
            }
        }
    }

    public void resetAttacks() {
        this.attackSelection = this.field_70146_Z.nextInt(4);
    }

    public boolean canPickupBlock(IBlockState state) {
        return EntityWither.func_181033_a((Block)state.func_177230_c());
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AIFollowPrey(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AIMoveRandom());
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLiving.class, 0, false, false, NOT_RATLANTEAN));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)RatsMod.CONFIG_OPTIONS.neoRatlanteanHealth);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)RatsMod.CONFIG_OPTIONS.neoRatlanteanAttack);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(128.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(0.0);
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
    }

    public int getAnimationTick() {
        return 0;
    }

    public void setAnimationTick(int tick) {
    }

    public Animation getAnimation() {
        return null;
    }

    public void setAnimation(Animation animation) {
    }

    public Animation[] getAnimations() {
        return new Animation[0];
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
    }

    public void func_184724_a(boolean swingingArms) {
    }

    protected SoundEvent func_184639_G() {
        return RatsSoundRegistry.NEORATLANTEAN_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return RatsSoundRegistry.NEORATLANTEAN_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return RatsSoundRegistry.NEORATLANTEAN_DIE;
    }

    public int func_70627_aG() {
        return 10;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LOOT;
    }

    public class AIMoveRandom
    extends EntityAIBase {
        public AIMoveRandom() {
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            return !EntityNeoRatlantean.this.func_70605_aq().func_75640_a() && EntityNeoRatlantean.this.field_70146_Z.nextInt(2) == 0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75246_d() {
            BlockPos blockpos = new BlockPos((Entity)EntityNeoRatlantean.this);
            for (int i = 0; i < 3; ++i) {
                BlockPos blockpos1 = blockpos.func_177982_a(EntityNeoRatlantean.this.field_70146_Z.nextInt(15) - 7, EntityNeoRatlantean.this.field_70146_Z.nextInt(11) - 5, EntityNeoRatlantean.this.field_70146_Z.nextInt(15) - 7);
                if (!EntityNeoRatlantean.this.field_70170_p.func_175623_d(blockpos1)) continue;
                EntityNeoRatlantean.this.field_70765_h.func_75642_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.5, (double)blockpos1.func_177952_p() + 0.5, 1.0);
                if (EntityNeoRatlantean.this.func_70638_az() != null) break;
                EntityNeoRatlantean.this.func_70671_ap().func_75650_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.5, (double)blockpos1.func_177952_p() + 0.5, 180.0f, 20.0f);
                break;
            }
        }
    }

    public class AIFollowPrey
    extends EntityAIBase {
        private final EntityNeoRatlantean parentEntity;
        public int attackTimer;
        private double followDist;

        public AIFollowPrey(EntityNeoRatlantean ghast) {
            this.parentEntity = ghast;
        }

        public boolean func_75250_a() {
            this.followDist = EntityNeoRatlantean.this.func_174813_aQ().func_72320_b();
            EntityLivingBase entitylivingbase = this.parentEntity.func_70638_az();
            double maxFollow = this.followDist * 5.0;
            return entitylivingbase != null && ((double)entitylivingbase.func_70032_d((Entity)this.parentEntity) >= maxFollow || !this.parentEntity.func_70685_l((Entity)entitylivingbase));
        }

        public void func_75249_e() {
            this.attackTimer = 0;
        }

        public void func_75251_c() {
        }

        public void func_75246_d() {
            EntityLivingBase entitylivingbase = this.parentEntity.func_70638_az();
            double maxFollow = this.followDist * 5.0;
            if ((double)entitylivingbase.func_70032_d((Entity)this.parentEntity) >= maxFollow || !this.parentEntity.func_70685_l((Entity)entitylivingbase)) {
                EntityNeoRatlantean.this.field_70765_h.func_75642_a(entitylivingbase.field_70165_t + (double)EntityNeoRatlantean.this.field_70146_Z.nextInt(10) - 20.0, entitylivingbase.field_70163_u + 3.0, entitylivingbase.field_70161_v + (double)EntityNeoRatlantean.this.field_70146_Z.nextInt(10) - 20.0, 1.0);
            }
        }
    }

    class AIMoveControl
    extends EntityMoveHelper {
        public AIMoveControl(EntityNeoRatlantean vex) {
            super((EntityLiving)vex);
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO) {
                double d0 = this.field_75646_b - EntityNeoRatlantean.this.field_70165_t;
                double d1 = this.field_75647_c - EntityNeoRatlantean.this.field_70163_u;
                double d2 = this.field_75644_d - EntityNeoRatlantean.this.field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if ((d3 = (double)MathHelper.func_76133_a((double)d3)) < EntityNeoRatlantean.this.func_174813_aQ().func_72320_b()) {
                    this.field_188491_h = EntityMoveHelper.Action.WAIT;
                    EntityNeoRatlantean.this.field_70159_w *= 0.5;
                    EntityNeoRatlantean.this.field_70181_x *= 0.5;
                    EntityNeoRatlantean.this.field_70179_y *= 0.5;
                } else {
                    EntityNeoRatlantean.this.field_70159_w += d0 / d3 * 0.25 * this.field_75645_e;
                    EntityNeoRatlantean.this.field_70181_x += d1 / d3 * 0.25 * this.field_75645_e;
                    EntityNeoRatlantean.this.field_70179_y += d2 / d3 * 0.25 * this.field_75645_e;
                    if (EntityNeoRatlantean.this.func_70638_az() == null) {
                        EntityNeoRatlantean.this.field_70761_aq = EntityNeoRatlantean.this.field_70177_z = -((float)MathHelper.func_181159_b((double)EntityNeoRatlantean.this.field_70159_w, (double)EntityNeoRatlantean.this.field_70179_y)) * 57.295776f;
                    } else {
                        double d4 = EntityNeoRatlantean.this.func_70638_az().field_70165_t - EntityNeoRatlantean.this.field_70165_t;
                        double d5 = EntityNeoRatlantean.this.func_70638_az().field_70161_v - EntityNeoRatlantean.this.field_70161_v;
                        EntityNeoRatlantean.this.field_70761_aq = EntityNeoRatlantean.this.field_70177_z = -((float)MathHelper.func_181159_b((double)d4, (double)d5)) * 57.295776f;
                    }
                }
            }
        }
    }
}

