/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.ai;

import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.entity.RatCommand;
import com.github.alexthe666.rats.server.entity.RatUtils;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import com.github.alexthe666.rats.server.message.MessageUpdateRatFluid;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class RatAIDepositFluid
extends EntityAIBase {
    private static final int RADIUS = 16;
    private final EntityRat entity;
    private BlockPos targetBlock = null;
    private int feedingTicks;
    private int breakingTime;
    private int previousBreakProgress;

    public RatAIDepositFluid(EntityRat entity) {
        this.entity = entity;
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        if (!this.entity.canMove() || this.entity.getMBTransferRate() == 0 || !this.entity.func_70909_n() || this.entity.getCommand() != RatCommand.TRANSPORT && this.entity.getCommand() != RatCommand.GATHER && this.entity.getCommand() != RatCommand.HUNT && this.entity.getCommand() != RatCommand.HARVEST || this.entity.func_70638_az() != null) {
            return false;
        }
        if (this.entity.transportingFluid == null || this.entity.transportingFluid.amount == 0) {
            return false;
        }
        this.resetTarget();
        return this.targetBlock != null;
    }

    private void resetTarget() {
        this.targetBlock = this.entity.depositPos;
    }

    public boolean func_75253_b() {
        return this.targetBlock != null && this.entity.transportingFluid != null && this.entity.transportingFluid.amount > 0;
    }

    public void func_75251_c() {
        this.entity.func_70661_as().func_75499_g();
        this.resetTarget();
    }

    public boolean canSeeChest() {
        RayTraceResult rayTrace = RatUtils.rayTraceBlocksIgnoreRatholes(this.entity.field_70170_p, this.entity.func_174791_d(), new Vec3d((double)this.targetBlock.func_177958_n() + 0.5, (double)this.targetBlock.func_177956_o() + 0.5, (double)this.targetBlock.func_177952_p() + 0.5), false);
        if (rayTrace != null && rayTrace.field_72307_f != null) {
            BlockPos sidePos = rayTrace.func_178782_a();
            BlockPos pos = new BlockPos(rayTrace.field_72307_f);
            return this.entity.field_70170_p.func_175623_d(sidePos) || this.entity.field_70170_p.func_175623_d(pos) || this.entity.field_70170_p.func_175625_s(pos) == this.entity.field_70170_p.func_175625_s(this.targetBlock);
        }
        return true;
    }

    private BlockPos getMovePos() {
        return this.targetBlock.func_177972_a(this.entity.depositFacing);
    }

    public void func_75246_d() {
        if (this.targetBlock != null && this.entity.field_70170_p.func_175625_s(this.targetBlock) != null) {
            TileEntity te = this.entity.field_70170_p.func_175625_s(this.targetBlock);
            if (this.entity.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_MINER) && !this.entity.func_70605_aq().func_75640_a() && this.entity.field_70122_E && !this.entity.func_70661_as().func_75492_a((double)this.getMovePos().func_177958_n() + 0.5, (double)this.getMovePos().func_177956_o(), (double)this.getMovePos().func_177952_p() + 0.5, 1.0)) {
                BlockPos rayPos = this.entity.rayTraceBlockPos(this.targetBlock.func_177984_a());
                if (rayPos != null && !rayPos.equals((Object)this.targetBlock)) {
                    IBlockState block = this.entity.field_70170_p.func_180495_p(rayPos);
                    if (RatUtils.canRatBreakBlock(this.entity.field_70170_p, rayPos, this.entity) && block.func_185904_a().func_76230_c() && block.func_185904_a() != Material.field_151579_a) {
                        double distance = this.entity.func_70011_f(rayPos.func_177958_n(), rayPos.func_177956_o(), rayPos.func_177952_p());
                        SoundType soundType = block.func_177230_c().getSoundType(block, this.entity.field_70170_p, rayPos, null);
                        if (distance < 2.5) {
                            this.entity.field_70170_p.func_72960_a((Entity)this.entity, (byte)85);
                            this.entity.crafting = true;
                            if (distance < (double)0.6f) {
                                this.entity.field_70179_y *= 0.0;
                                this.entity.field_70159_w *= 0.0;
                                this.entity.func_70661_as().func_75499_g();
                                this.entity.func_70605_aq().field_188491_h = EntityMoveHelper.Action.WAIT;
                            }
                            ++this.breakingTime;
                            int hardness = (int)(block.func_185887_b(this.entity.field_70170_p, rayPos) * 100.0f);
                            int i = (int)((float)this.breakingTime / (float)hardness * 10.0f);
                            if (this.breakingTime % 10 == 0) {
                                this.entity.func_184185_a(soundType.func_185846_f(), soundType.field_185860_m, soundType.field_185861_n);
                                this.entity.func_184185_a(SoundEvents.field_187730_dW, 1.0f, 0.5f);
                            }
                            if (i != this.previousBreakProgress) {
                                this.entity.field_70170_p.func_175715_c(this.entity.func_145782_y(), rayPos, i);
                                this.previousBreakProgress = i;
                            }
                            if (this.breakingTime == hardness) {
                                this.entity.field_70170_p.func_72960_a((Entity)this.entity, (byte)86);
                                this.entity.func_184185_a(SoundEvents.field_187638_cR, 1.0f, 1.0f);
                                this.entity.func_184185_a(soundType.func_185845_c(), soundType.field_185860_m, soundType.field_185861_n);
                                this.breakingTime = 0;
                                this.previousBreakProgress = -1;
                                this.destroyBlock(rayPos, block);
                                this.entity.fleePos = rayPos;
                                this.targetBlock = null;
                                this.entity.crafting = false;
                                this.func_75251_c();
                            }
                        }
                    }
                }
            } else {
                this.entity.func_70661_as().func_75492_a((double)this.getMovePos().func_177958_n() + 0.5, (double)this.getMovePos().func_177956_o(), (double)this.getMovePos().func_177952_p() + 0.5, 1.0);
                double distance = this.entity.func_70011_f((double)this.targetBlock.func_177958_n() + 0.5, this.targetBlock.func_177956_o() + 1, (double)this.targetBlock.func_177952_p() + 0.5);
                if (distance < 1.86 && this.canSeeChest() && te != null) {
                    FluidStack copiedFluid = this.entity.transportingFluid.copy();
                    IFluidHandler handler = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.entity.depositFacing);
                    if (handler == null) {
                        return;
                    }
                    if (this.entity.transportingFluid != null) {
                        int minusAmount = 0;
                        try {
                            if (handler.getTankProperties().length > 0) {
                                IFluidTankProperties firstTank = handler.getTankProperties()[0];
                                if (handler.getTankProperties().length > 1) {
                                    for (IFluidTankProperties otherTank : handler.getTankProperties()) {
                                        if (copiedFluid == null || !copiedFluid.isFluidEqual(otherTank.getContents())) continue;
                                        firstTank = otherTank;
                                    }
                                }
                                if ((firstTank.getContents() == null || copiedFluid == null || copiedFluid.isFluidEqual(firstTank.getContents())) && handler.fill(copiedFluid, false) != 0) {
                                    minusAmount = handler.fill(copiedFluid, true);
                                }
                            }
                        }
                        catch (Exception firstTank) {
                            // empty catch block
                        }
                        if (minusAmount <= 0) {
                            this.targetBlock = null;
                            this.func_75251_c();
                        } else {
                            int total = copiedFluid.amount - minusAmount;
                            if (total <= 0) {
                                this.entity.transportingFluid = null;
                            } else {
                                this.entity.transportingFluid.amount = total;
                            }
                            if (!this.entity.field_70170_p.field_72995_K) {
                                RatsMod.NETWORK_WRAPPER.sendToAll((IMessage)new MessageUpdateRatFluid(this.entity.func_145782_y(), this.entity.transportingFluid));
                            }
                            SoundEvent sound = this.entity.transportingFluid == null ? SoundEvents.field_187624_K : this.entity.transportingFluid.getFluid().getEmptySound();
                            this.entity.func_184185_a(sound, 1.0f, 1.0f);
                            this.targetBlock = null;
                            this.func_75251_c();
                        }
                    }
                    if (handler == null) {
                        this.targetBlock = null;
                        this.func_75251_c();
                        return;
                    }
                }
            }
        }
    }

    private void destroyBlock(BlockPos pos, IBlockState state) {
        NonNullList drops = NonNullList.func_191196_a();
        state.func_177230_c().getDrops(drops, (IBlockAccess)this.entity.field_70170_p, pos, state, 0);
        if (!drops.isEmpty() && this.entity.canRatPickupItem((ItemStack)drops.get(0))) {
            for (ItemStack drop : drops) {
                this.entity.func_70099_a(drop, 0.0f);
            }
            this.entity.field_70170_p.func_175655_b(pos, false);
            this.entity.fleePos = pos;
        }
    }
}

