/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.ai;

import com.github.alexthe666.rats.server.blocks.RatsBlockRegistry;
import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.entity.RatUtils;
import com.github.alexthe666.rats.server.entity.ai.RatAIMoveToBlock;
import com.github.alexthe666.rats.server.entity.tile.TileEntityRatTrap;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class RatAIEnterTrap
extends RatAIMoveToBlock {
    private final EntityRat entity;

    public RatAIEnterTrap(EntityRat entity) {
        super((EntityCreature)entity, 1.0, 20);
        this.entity = entity;
        this.distanceCheck = 2.5;
    }

    public static boolean isTrap(World world, BlockPos pos) {
        IBlockState block = world.func_180495_p(pos.func_177984_a());
        if (block.func_177230_c() == RatsBlockRegistry.RAT_TRAP) {
            TileEntity entity = world.func_175625_s(pos.func_177984_a());
            return entity != null && !((TileEntityRatTrap)entity).isShut && !((TileEntityRatTrap)entity).getBait().func_190926_b();
        }
        return false;
    }

    @Override
    public boolean func_75250_a() {
        if (!this.entity.canMove() || this.entity.func_70909_n() || this.entity.isInCage()) {
            return false;
        }
        if (!this.entity.func_184586_b(EnumHand.MAIN_HAND).func_190926_b()) {
            return false;
        }
        if (this.entity.func_70909_n()) {
            return false;
        }
        if (this.runDelay <= 0 && !ForgeEventFactory.getMobGriefingEvent((World)this.entity.field_70170_p, (Entity)this.entity)) {
            return false;
        }
        return super.func_75250_a();
    }

    @Override
    public boolean func_75253_b() {
        return super.func_75253_b() && this.entity.func_184586_b(EnumHand.MAIN_HAND).func_190926_b();
    }

    public boolean canSeeChest() {
        RayTraceResult rayTrace = RatUtils.rayTraceBlocksIgnoreRatholes(this.entity.field_70170_p, this.entity.func_174791_d(), new Vec3d((double)this.destinationBlock.func_177958_n() + 0.5, (double)this.destinationBlock.func_177956_o() + 0.5, (double)this.destinationBlock.func_177952_p() + 0.5), false);
        if (rayTrace != null && rayTrace.field_72307_f != null) {
            BlockPos sidePos = rayTrace.func_178782_a();
            BlockPos pos = new BlockPos(rayTrace.field_72307_f);
            return this.entity.field_70170_p.func_175623_d(sidePos) || this.entity.field_70170_p.func_175623_d(pos) || this.entity.field_70170_p.func_175625_s(pos) == this.entity.field_70170_p.func_175625_s(this.destinationBlock);
        }
        return true;
    }

    @Override
    public void func_75246_d() {
        double distance;
        BlockPos trapPos;
        TileEntity entity;
        super.func_75246_d();
        if (this.getIsAboveDestination() && this.destinationBlock != null && (entity = this.entity.field_70170_p.func_175625_s(trapPos = this.destinationBlock.func_177984_a())) instanceof TileEntityRatTrap && !((TileEntityRatTrap)entity).isShut && !((TileEntityRatTrap)entity).getBait().func_190926_b() && (distance = this.entity.func_70011_f(trapPos.func_177958_n(), trapPos.func_177956_o(), trapPos.func_177952_p())) < 0.5 && this.canSeeChest()) {
            ItemStack duplicate = ((TileEntityRatTrap)entity).getBait().func_77946_l();
            duplicate.func_190920_e(1);
            if (!this.entity.func_184586_b(EnumHand.MAIN_HAND).func_190926_b() && !this.entity.field_70170_p.field_72995_K) {
                this.entity.func_70099_a(this.entity.func_184586_b(EnumHand.MAIN_HAND), 0.0f);
            }
            this.entity.func_184611_a(EnumHand.MAIN_HAND, duplicate);
            ((TileEntityRatTrap)entity).getBait().func_190918_g(1);
            this.entity.fleePos = this.destinationBlock;
        }
    }

    @Override
    protected boolean shouldMoveTo(World worldIn, BlockPos pos) {
        return RatAIEnterTrap.isTrap(worldIn, pos);
    }
}

