/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.ai;

import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.entity.RatCommand;
import com.github.alexthe666.rats.server.entity.RatUtils;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import com.github.alexthe666.rats.server.message.MessageUpdateRatFluid;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class RatAIHarvestMilk
extends EntityAIBase {
    private static final int RADIUS = 16;
    private final EntityRat entity;
    private Entity targetCow = null;
    private boolean reachedCow = false;
    private int fishingCooldown = 1000;
    private int throwCooldown = 0;
    private Random rand = new Random();
    private Predicate<EntityLivingBase> COW_PREDICATE = new com.google.common.base.Predicate<EntityLivingBase>(){

        public boolean apply(@Nullable EntityLivingBase entity) {
            return entity != null && RatUtils.isCow((Entity)entity) && !entity.func_70631_g_();
        }
    };

    public RatAIHarvestMilk(EntityRat entity) {
        this.entity = entity;
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        if (!this.entity.canMove() || !this.entity.func_70909_n() || this.entity.getCommand() != RatCommand.HARVEST || this.entity.isInCage() || !this.entity.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_MILKER)) {
            return false;
        }
        if (this.entity.transportingFluid != null && this.entity.transportingFluid.amount >= this.entity.getMBTransferRate()) {
            return false;
        }
        this.resetTarget();
        return this.targetCow != null;
    }

    public boolean func_75253_b() {
        return this.targetCow != null && (this.entity.transportingFluid == null || this.entity.transportingFluid.amount < this.entity.getMBTransferRate());
    }

    public void func_75251_c() {
        this.entity.func_70661_as().func_75499_g();
        this.resetTarget();
    }

    public void func_75246_d() {
        if (!(this.targetCow == null || this.targetCow.field_70128_L || this.entity.transportingFluid != null && this.entity.transportingFluid.amount >= this.entity.getMBTransferRate())) {
            FluidBucketWrapper milkWrapper;
            this.entity.func_70661_as().func_75497_a(this.targetCow, 1.0);
            if ((double)this.entity.func_70032_d(this.targetCow) < 1.5 && this.entity.transportingFluid == null && (milkWrapper = new FluidBucketWrapper(new ItemStack(Items.field_151117_aB))).getFluid() != null && (this.entity.transportingFluid == null || this.entity.transportingFluid.amount < this.entity.getMBTransferRate())) {
                this.entity.transportingFluid = milkWrapper.getFluid().copy();
                if (!this.entity.field_70170_p.field_72995_K) {
                    RatsMod.NETWORK_WRAPPER.sendToAll((IMessage)new MessageUpdateRatFluid(this.entity.func_145782_y(), this.entity.transportingFluid));
                }
                this.entity.func_184185_a(SoundEvents.field_187564_an, 1.0f, 1.0f);
                this.targetCow = null;
                this.func_75251_c();
            }
        } else {
            this.func_75251_c();
        }
    }

    private void resetTarget() {
        List list = this.entity.field_70170_p.func_175647_a(EntityLiving.class, this.entity.func_174813_aQ().func_186662_g(16.0), (com.google.common.base.Predicate)this.COW_PREDICATE);
        EntityLivingBase closestCow = null;
        for (EntityLivingBase base : list) {
            if (closestCow != null && !(base.func_70068_e((Entity)this.entity) < closestCow.func_70068_e((Entity)this.entity))) continue;
            closestCow = base;
        }
        if (closestCow != null) {
            this.targetCow = closestCow;
        }
    }
}

