/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.ai;

import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.entity.RatCommand;
import com.github.alexthe666.rats.server.entity.RatUtils;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import java.util.ArrayList;
import java.util.Comparator;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class RatAIHarvestMine
extends EntityAIBase {
    private static final int RADIUS = 16;
    private final EntityRat entity;
    private final BlockSorter targetSorter;
    private BlockPos targetBlock = null;
    private int breakingTime;
    private int previousBreakProgress;
    private IBlockState prevMiningState = null;

    public RatAIHarvestMine(EntityRat entity) {
        this.entity = entity;
        this.targetSorter = new BlockSorter((Entity)entity);
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        if (!this.entity.canMove() || !this.entity.func_70909_n() || this.entity.getCommand() != RatCommand.HARVEST || this.entity.isInCage() || !this.entity.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_MINER)) {
            return false;
        }
        if (!this.entity.func_184586_b(EnumHand.MAIN_HAND).func_190926_b()) {
            return false;
        }
        this.resetTarget();
        return this.targetBlock != null;
    }

    private void resetTarget() {
        ArrayList<BlockPos> allBlocks = new ArrayList<BlockPos>();
        NonNullList<ItemStack> mining = this.getMiningList();
        for (BlockPos pos : BlockPos.func_177980_a((BlockPos)this.entity.func_180425_c().func_177982_a(-16, -16, -16), (BlockPos)this.entity.func_180425_c().func_177982_a(16, 16, 16))) {
            if (!this.doesListContainBlock(this.entity.field_70170_p, mining, pos)) continue;
            allBlocks.add(pos);
        }
        if (!allBlocks.isEmpty()) {
            allBlocks.sort(this.targetSorter);
            this.targetBlock = (BlockPos)allBlocks.get(0);
        }
    }

    private NonNullList<ItemStack> getMiningList() {
        NBTTagCompound nbttagcompound1 = this.entity.getUpgrade(RatsItemRegistry.RAT_UPGRADE_MINER).func_77978_p();
        NonNullList nonnulllist = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
        if (nbttagcompound1 != null && nbttagcompound1.func_150297_b("Items", 9)) {
            ItemStackHelper.func_191283_b((NBTTagCompound)nbttagcompound1, (NonNullList)nonnulllist);
        }
        return nonnulllist;
    }

    private boolean doesListContainBlock(World world, NonNullList<ItemStack> list, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        ItemStack getStack = state.func_177230_c().func_185473_a(world, pos, state);
        for (ItemStack stack : list) {
            if (!stack.func_77969_a(getStack)) continue;
            return true;
        }
        return false;
    }

    public boolean func_75253_b() {
        return this.targetBlock != null && this.entity.func_184586_b(EnumHand.MAIN_HAND).func_190926_b();
    }

    public void func_75251_c() {
        this.entity.func_70661_as().func_75499_g();
        this.resetTarget();
    }

    public void func_75246_d() {
        if (this.targetBlock != null) {
            BlockPos rayPos = this.entity.rayTraceBlockPos(this.targetBlock);
            if (rayPos == null) {
                rayPos = this.targetBlock;
            }
            if (this.entity.func_70661_as().func_75492_a((double)this.targetBlock.func_177958_n() + 0.5, (double)this.targetBlock.func_177956_o(), (double)this.targetBlock.func_177952_p() + 0.5, 1.0)) {
                rayPos = this.targetBlock;
            } else {
                this.entity.func_70661_as().func_75492_a((double)rayPos.func_177958_n() + 0.5, (double)rayPos.func_177956_o(), (double)rayPos.func_177952_p() + 0.5, 1.0);
            }
            if (!this.entity.func_70605_aq().func_75640_a() && this.entity.field_70122_E) {
                double distance;
                IBlockState block = this.entity.field_70170_p.func_180495_p(rayPos);
                SoundType soundType = block.func_177230_c().getSoundType(block, this.entity.field_70170_p, rayPos, null);
                if (RatUtils.canRatBreakBlock(this.entity.field_70170_p, rayPos, this.entity) && block.func_185904_a().func_76230_c() && block.func_185904_a() != Material.field_151579_a && (distance = this.entity.func_70011_f(rayPos.func_177958_n(), rayPos.func_177956_o(), rayPos.func_177952_p())) < 2.5) {
                    this.entity.field_70170_p.func_72960_a((Entity)this.entity, (byte)85);
                    this.entity.crafting = true;
                    if (block == this.prevMiningState) {
                        this.entity.field_70170_p.func_72960_a((Entity)this.entity, (byte)85);
                        this.entity.crafting = true;
                    } else {
                        this.entity.field_70170_p.func_72960_a((Entity)this.entity, (byte)86);
                        this.entity.crafting = false;
                    }
                    if (distance < (double)0.6f) {
                        this.entity.field_70179_y *= 0.0;
                        this.entity.field_70159_w *= 0.0;
                        this.entity.func_70661_as().func_75499_g();
                        this.entity.func_70605_aq().field_188491_h = EntityMoveHelper.Action.WAIT;
                    }
                    ++this.breakingTime;
                    int hardness = (int)(block.func_185887_b(this.entity.field_70170_p, rayPos) * 100.0f);
                    int i = (int)((float)this.breakingTime / (float)hardness * 10.0f);
                    if (this.breakingTime % 5 == 0) {
                        this.entity.func_184185_a(soundType.func_185846_f(), soundType.field_185860_m + 1.0f, soundType.field_185861_n);
                    }
                    if (i != this.previousBreakProgress) {
                        this.entity.field_70170_p.func_175715_c(this.entity.func_145782_y(), rayPos, i);
                        this.previousBreakProgress = i;
                    }
                    if (this.breakingTime == hardness) {
                        this.entity.field_70170_p.func_72960_a((Entity)this.entity, (byte)86);
                        this.entity.func_184185_a(soundType.func_185845_c(), soundType.field_185860_m, soundType.field_185861_n);
                        this.entity.func_184185_a(SoundEvents.field_187638_cR, 1.0f, 1.0f);
                        this.breakingTime = 0;
                        this.previousBreakProgress = -1;
                        this.destroyBlock(rayPos, block);
                        this.entity.fleePos = rayPos;
                        this.targetBlock = null;
                        this.entity.crafting = false;
                        this.func_75251_c();
                    }
                    this.prevMiningState = block;
                }
            }
        }
    }

    private void destroyBlock(BlockPos pos, IBlockState state) {
        NonNullList drops = NonNullList.func_191196_a();
        state.func_177230_c().getDrops(drops, (IBlockAccess)this.entity.field_70170_p, pos, state, 0);
        if (!drops.isEmpty() && this.entity.canRatPickupItem((ItemStack)drops.get(0))) {
            ItemStack duplicate = ((ItemStack)drops.get(0)).func_77946_l();
            drops.remove(0);
            if (!this.entity.func_184586_b(EnumHand.MAIN_HAND).func_190926_b() && !this.entity.field_70170_p.field_72995_K) {
                this.entity.func_70099_a(this.entity.func_184586_b(EnumHand.MAIN_HAND), 0.0f);
            }
            this.entity.func_184611_a(EnumHand.MAIN_HAND, duplicate);
            for (ItemStack drop : drops) {
                this.entity.func_70099_a(drop, 0.0f);
            }
            this.entity.field_70170_p.func_175655_b(pos, false);
            if (state.func_177230_c() instanceof BlockCrops) {
                this.entity.field_70170_p.func_175656_a(pos, state.func_177230_c().func_176223_P());
            }
            this.entity.fleePos = pos;
        }
    }

    public class BlockSorter
    implements Comparator<BlockPos> {
        private final Entity entity;

        public BlockSorter(Entity entity) {
            this.entity = entity;
        }

        @Override
        public int compare(BlockPos pos1, BlockPos pos2) {
            double distance1 = this.getDistance(pos1);
            double distance2 = this.getDistance(pos2);
            return Double.compare(distance1, distance2);
        }

        private double getDistance(BlockPos pos) {
            double deltaX = this.entity.field_70165_t - ((double)pos.func_177958_n() + 0.5);
            double deltaY = this.entity.field_70163_u + (double)this.entity.func_70047_e() - ((double)pos.func_177956_o() + 0.5);
            double deltaZ = this.entity.field_70161_v - ((double)pos.func_177952_p() + 0.5);
            return deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ;
        }
    }
}

