/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.ai;

import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.entity.RatCommand;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.IShearable;

public class RatAIHarvestShears
extends EntityAIBase {
    private static final int RADIUS = 16;
    private final EntityRat entity;
    private Entity targetSheep = null;
    private boolean reachedSheep = false;
    private int fishingCooldown = 1000;
    private int throwCooldown = 0;
    private static final ItemStack SHEAR_STACK = new ItemStack((Item)Items.field_151097_aZ);
    private Random rand = new Random();
    private Predicate<EntityLivingBase> SHEAR_PREDICATE = new com.google.common.base.Predicate<EntityLivingBase>(){

        public boolean apply(@Nullable EntityLivingBase entity) {
            return entity != null && entity instanceof IShearable && ((IShearable)entity).isShearable(SHEAR_STACK, (IBlockAccess)entity.field_70170_p, entity.func_180425_c());
        }
    };

    public RatAIHarvestShears(EntityRat entity) {
        this.entity = entity;
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        if (!this.entity.canMove() || !this.entity.func_70909_n() || this.entity.getCommand() != RatCommand.HARVEST || this.entity.isInCage() || !this.entity.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_SHEARS)) {
            return false;
        }
        if (!this.entity.func_184614_ca().func_190926_b()) {
            return false;
        }
        this.resetTarget();
        return this.targetSheep != null;
    }

    public boolean func_75253_b() {
        return this.targetSheep != null && this.entity.func_184614_ca().func_190926_b();
    }

    public void func_75251_c() {
        this.entity.func_70661_as().func_75499_g();
        this.resetTarget();
    }

    public void func_75246_d() {
        if (this.targetSheep != null && !this.targetSheep.field_70128_L && this.entity.func_184614_ca().func_190926_b()) {
            this.entity.func_70661_as().func_75497_a(this.targetSheep, 1.0);
            if ((double)this.entity.func_70032_d(this.targetSheep) < 1.5) {
                if (this.targetSheep instanceof IShearable) {
                    List drops = ((IShearable)this.targetSheep).onSheared(new ItemStack((Item)Items.field_151097_aZ), (IBlockAccess)this.entity.field_70170_p, this.targetSheep.func_180425_c(), 0);
                    for (ItemStack stack : drops) {
                        this.targetSheep.func_70099_a(stack, 0.0f);
                    }
                }
                this.targetSheep = null;
                this.func_75251_c();
            }
        } else {
            this.func_75251_c();
        }
    }

    private void resetTarget() {
        List list = this.entity.field_70170_p.func_175647_a(EntityLiving.class, this.entity.func_174813_aQ().func_186662_g(16.0), (com.google.common.base.Predicate)this.SHEAR_PREDICATE);
        EntityLivingBase closestSheep = null;
        for (EntityLivingBase base : list) {
            if (closestSheep != null && !(base.func_70068_e((Entity)this.entity) < closestSheep.func_70068_e((Entity)this.entity))) continue;
            closestSheep = base;
        }
        if (closestSheep != null) {
            this.targetSheep = closestSheep;
        }
    }
}

