/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.ai;

import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.entity.RatCommand;
import com.github.alexthe666.rats.server.entity.RatUtils;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class RatAIHarvestTrees
extends EntityAIBase {
    private static final int RADIUS = 16;
    private final EntityRat entity;
    private final BlockSorter targetSorter;
    private BlockPos targetBlock = null;
    private int destroyedLeaves;
    private int breakingTime;
    private int previousBreakProgress;

    public RatAIHarvestTrees(EntityRat entity) {
        this.entity = entity;
        this.targetSorter = new BlockSorter((Entity)entity);
        this.func_75248_a(1);
    }

    public static final boolean isBlockLog(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c().isWood((IBlockAccess)world, pos);
    }

    public static final boolean isBlockLeaf(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_177230_c().isLeaves(state, (IBlockAccess)world, pos);
    }

    public boolean func_75250_a() {
        if (!this.entity.canMove() || !this.entity.func_70909_n() || this.entity.getCommand() != RatCommand.HARVEST || this.entity.isInCage() || !this.entity.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_LUMBERJACK)) {
            return false;
        }
        if (!this.entity.func_184586_b(EnumHand.MAIN_HAND).func_190926_b()) {
            return false;
        }
        this.resetTarget();
        return this.targetBlock != null;
    }

    private void resetTarget() {
        World world = this.entity.field_70170_p;
        ArrayList<BlockPos> allBlocks = new ArrayList<BlockPos>();
        for (BlockPos pos : BlockPos.func_177980_a((BlockPos)this.entity.func_180425_c().func_177982_a(-16, -8, -16), (BlockPos)this.entity.func_180425_c().func_177982_a(16, 8, 16))) {
            if (!RatAIHarvestTrees.isBlockLog(world, pos)) continue;
            BlockPos topOfLog = new BlockPos((Vec3i)pos);
            while (!world.func_175623_d(topOfLog.func_177984_a()) && topOfLog.func_177956_o() < world.func_72800_K()) {
                topOfLog = topOfLog.func_177984_a();
            }
            if (!RatAIHarvestTrees.isBlockLeaf(world, topOfLog)) continue;
            BlockPos logPos = this.getStump(topOfLog);
            allBlocks.add(logPos);
        }
        if (!allBlocks.isEmpty()) {
            allBlocks.sort(this.targetSorter);
            this.targetBlock = (BlockPos)allBlocks.get(0);
        }
    }

    private BlockPos getStump(BlockPos log) {
        if (log.func_177956_o() > 0) {
            for (BlockPos pos : BlockPos.func_177980_a((BlockPos)log.func_177982_a(-4, -4, -4), (BlockPos)log.func_177982_a(4, 0, 4))) {
                if (!RatAIHarvestTrees.isBlockLog(this.entity.field_70170_p, pos.func_177977_b()) && !RatAIHarvestTrees.isBlockLeaf(this.entity.field_70170_p, pos.func_177977_b())) continue;
                return this.getStump(pos.func_177977_b());
            }
        }
        return log;
    }

    public boolean func_75253_b() {
        return this.targetBlock != null && this.entity.func_184586_b(EnumHand.MAIN_HAND).func_190926_b();
    }

    public void func_75251_c() {
        this.entity.func_70661_as().func_75499_g();
        this.destroyedLeaves = 0;
        this.entity.crafting = false;
        this.resetTarget();
    }

    public void func_75246_d() {
        if (this.targetBlock != null) {
            RayTraceResult rayTrace;
            if (!this.entity.func_70661_as().func_75492_a((double)this.targetBlock.func_177958_n() + 0.5, (double)this.targetBlock.func_177956_o(), (double)this.targetBlock.func_177952_p() + 0.5, 1.0) && (rayTrace = RatUtils.rayTraceBlocksIgnoreRatholes(this.entity.field_70170_p, this.entity.func_174791_d(), new Vec3d((double)this.targetBlock.func_177958_n() + 0.5, (double)this.targetBlock.func_177956_o() + 0.5, (double)this.targetBlock.func_177952_p() + 0.5), false)) != null && rayTrace.field_72307_f != null) {
                BlockPos pos = rayTrace.func_178782_a().func_177972_a(rayTrace.field_178784_b);
                this.entity.func_70661_as().func_75492_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 1.0);
            }
            if (RatAIHarvestTrees.isBlockLog(this.entity.field_70170_p, this.targetBlock)) {
                double distance = this.entity.func_70011_f(this.targetBlock.func_177958_n(), this.targetBlock.func_177956_o(), this.targetBlock.func_177952_p());
                if (distance < 2.5) {
                    this.entity.field_70170_p.func_72960_a((Entity)this.entity, (byte)85);
                    this.entity.crafting = true;
                    if (distance < (double)0.6f) {
                        this.entity.field_70179_y *= 0.0;
                        this.entity.field_70159_w *= 0.0;
                        this.entity.func_70661_as().func_75499_g();
                        this.entity.func_70605_aq().field_188491_h = EntityMoveHelper.Action.WAIT;
                    }
                    ++this.breakingTime;
                    int i = (int)((float)this.breakingTime / 160.0f * 10.0f);
                    if (this.breakingTime % 10 == 0) {
                        this.entity.func_184185_a(SoundEvents.field_187889_gU, 1.0f, 1.0f);
                        this.entity.func_184185_a(SoundEvents.field_187730_dW, 1.0f, 0.5f);
                    }
                    if (i != this.previousBreakProgress) {
                        this.entity.field_70170_p.func_175715_c(this.entity.func_145782_y(), this.targetBlock, i);
                        this.previousBreakProgress = i;
                    }
                    if (this.breakingTime == 160) {
                        this.entity.field_70170_p.func_72960_a((Entity)this.entity, (byte)86);
                        this.entity.func_184185_a(SoundEvents.field_187881_gQ, 1.0f, 1.0f);
                        this.breakingTime = 0;
                        this.previousBreakProgress = -1;
                        this.fellTree();
                        this.entity.fleePos = this.targetBlock;
                        this.targetBlock = null;
                        this.entity.crafting = false;
                        this.func_75251_c();
                    }
                }
            } else {
                this.entity.fleePos = this.targetBlock;
                this.targetBlock = null;
                this.func_75251_c();
            }
        }
    }

    private void fellTree() {
        World world = this.entity.field_70170_p;
        BlockPos base = new BlockPos((Vec3i)this.targetBlock);
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        while (RatAIHarvestTrees.isBlockLog(world, base)) {
            if (!queue.contains(base)) {
                queue.add(base);
            }
            for (BlockPos pos : BlockPos.func_177980_a((BlockPos)base.func_177982_a(-8, 0, -8), (BlockPos)base.func_177982_a(8, 2, 8))) {
                if (!RatAIHarvestTrees.isBlockLog(world, pos) || queue.contains(pos)) continue;
                if (RatAIHarvestTrees.isBlockLog(world, pos.func_177984_a()) && !RatAIHarvestTrees.isBlockLog(world, base.func_177984_a())) {
                    base = pos;
                }
                queue.add(pos);
            }
            base = base.func_177984_a();
        }
        while (!queue.isEmpty()) {
            BlockPos pop = (BlockPos)queue.remove();
            world.func_175655_b(pop, true);
        }
    }

    public class BlockSorter
    implements Comparator<BlockPos> {
        private final Entity entity;

        public BlockSorter(Entity entity) {
            this.entity = entity;
        }

        @Override
        public int compare(BlockPos pos1, BlockPos pos2) {
            double yDist2;
            double yDist1 = Math.abs((double)pos1.func_177956_o() + 0.5 - this.entity.field_70163_u);
            if (yDist1 == (yDist2 = Math.abs((double)pos2.func_177956_o() + 0.5 - this.entity.field_70163_u))) {
                double distance1 = this.getDistance(pos1);
                double distance2 = this.getDistance(pos2);
                return Double.compare(distance1, distance2);
            }
            return Double.compare(yDist1, yDist2);
        }

        private double getDistance(BlockPos pos) {
            double deltaX = this.entity.field_70165_t - ((double)pos.func_177958_n() + 0.5);
            double deltaY = this.entity.field_70163_u + (double)this.entity.func_70047_e() - ((double)pos.func_177956_o() + 0.5);
            double deltaZ = this.entity.field_70161_v - ((double)pos.func_177952_p() + 0.5);
            return deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ;
        }
    }
}

