/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.ai;

import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.entity.RatCommand;
import com.github.alexthe666.rats.server.entity.RatUtils;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import com.google.common.base.Predicate;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAITarget;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class RatAITargetItems<T extends EntityItem>
extends EntityAITarget {
    protected final Sorter theNearestAttackableTargetSorter;
    protected final Predicate<? super EntityItem> targetEntitySelector;
    protected int executionChance;
    protected boolean mustUpdate;
    protected EntityItem targetEntity;
    private EntityRat rat;

    public RatAITargetItems(EntityRat creature, boolean checkSight) {
        this(creature, checkSight, false);
        this.func_75248_a(1);
    }

    public RatAITargetItems(EntityRat creature, boolean checkSight, boolean onlyNearby) {
        this(creature, 10, checkSight, onlyNearby, null);
    }

    public RatAITargetItems(EntityRat creature, int chance, boolean checkSight, boolean onlyNearby, @Nullable Predicate<? super T> targetSelector) {
        super((EntityCreature)creature, checkSight, onlyNearby);
        this.executionChance = chance;
        this.rat = creature;
        this.theNearestAttackableTargetSorter = new Sorter((Entity)creature);
        this.targetEntitySelector = new Predicate<EntityItem>(){

            public boolean apply(@Nullable EntityItem item) {
                ItemStack stack = item.func_92059_d();
                if (RatAITargetItems.this.rat.isTargetCommand()) {
                    return item != null && !stack.func_190926_b() && RatAITargetItems.this.rat.canRatPickupItem(stack);
                }
                return !stack.func_190926_b() && RatUtils.shouldRaidItem(stack) && RatAITargetItems.this.rat.canRatPickupItem(stack);
            }
        };
        this.func_75248_a(0);
    }

    public boolean func_75250_a() {
        List list;
        if (!this.rat.canMove() || this.field_75299_d.func_184218_aH() || this.rat.isInCage() || this.rat.isTargetCommand() && this.rat.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_FARMER)) {
            return false;
        }
        if (!this.mustUpdate) {
            long worldTime = this.field_75299_d.field_70170_p.func_72820_D() % 10L;
            if (this.rat.func_70654_ax() >= 100 && worldTime != 0L) {
                return false;
            }
            if (this.rat.func_70681_au().nextInt(this.executionChance) != 0 && worldTime != 0L) {
                return false;
            }
        }
        if ((list = this.field_75299_d.field_70170_p.func_175647_a(EntityItem.class, this.getTargetableArea(this.func_111175_f()), this.targetEntitySelector)).isEmpty()) {
            return false;
        }
        Collections.sort(list, this.theNearestAttackableTargetSorter);
        this.targetEntity = (EntityItem)list.get(0);
        this.mustUpdate = false;
        return true;
    }

    protected double func_111175_f() {
        return 16.0;
    }

    protected AxisAlignedBB getTargetableArea(double targetDistance) {
        return this.field_75299_d.func_174813_aQ().func_72314_b(targetDistance, targetDistance, targetDistance);
    }

    public void func_75249_e() {
        this.field_75299_d.func_70661_as().func_75492_a(this.targetEntity.field_70165_t, this.targetEntity.field_70163_u, this.targetEntity.field_70161_v, 1.0);
        super.func_75249_e();
    }

    public void func_75246_d() {
        super.func_75246_d();
        if (this.targetEntity == null || this.targetEntity != null && this.targetEntity.field_70128_L) {
            this.func_75251_c();
            this.field_75299_d.func_70661_as().func_75499_g();
        }
        if (this.targetEntity != null && !this.targetEntity.field_70128_L && this.field_75299_d.func_70068_e((Entity)this.targetEntity) < 1.0 && this.rat.func_184586_b(EnumHand.MAIN_HAND).func_190926_b()) {
            EntityPlayer targetPlayer;
            EntityRat rat = (EntityRat)this.field_75299_d;
            ItemStack duplicate = this.targetEntity.func_92059_d().func_77946_l();
            int extractSize = rat.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_PLATTER) ? this.targetEntity.func_92059_d().func_190916_E() : 1;
            duplicate.func_190920_e(extractSize);
            this.targetEntity.func_92059_d().func_190918_g(extractSize);
            if (!rat.func_184586_b(EnumHand.MAIN_HAND).func_190926_b() && !rat.field_70170_p.field_72995_K) {
                rat.func_70099_a(rat.func_184586_b(EnumHand.MAIN_HAND), 0.0f);
            }
            rat.func_184611_a(EnumHand.MAIN_HAND, duplicate);
            if (this.targetEntity.func_145800_j() != null && (targetPlayer = this.field_75299_d.field_70170_p.func_72924_a(this.targetEntity.func_145800_j())) != null && RatUtils.isCheese(duplicate)) {
                if (!rat.func_70909_n() && rat.canBeTamed()) {
                    rat.wildTrust += 10;
                    ++rat.cheeseFeedings;
                    rat.field_70170_p.func_72960_a((Entity)rat, (byte)82);
                    if (rat.wildTrust >= 100 && rat.func_70681_au().nextInt(3) == 0 || rat.cheeseFeedings >= 15) {
                        rat.field_70170_p.func_72960_a((Entity)rat, (byte)83);
                        rat.func_70903_f(true);
                        rat.func_184754_b(targetPlayer.func_110124_au());
                        rat.setOwnerMonster(false);
                        rat.setCommand(RatCommand.FOLLOW);
                    }
                } else {
                    String untameableText = "entity.rat.untameable";
                    if (rat.func_70902_q() != null && !rat.func_184753_b().equals(targetPlayer.func_110124_au())) {
                        untameableText = "entity.rat.tamed_by_other";
                    }
                    if (!rat.func_152114_e((EntityLivingBase)targetPlayer)) {
                        targetPlayer.func_146105_b((ITextComponent)new TextComponentTranslation(untameableText, new Object[0]), true);
                    }
                }
            }
            this.func_75251_c();
        }
    }

    public void makeUpdate() {
        this.mustUpdate = true;
    }

    public boolean func_75253_b() {
        return !this.field_75299_d.func_70661_as().func_75500_f();
    }

    public static class Sorter
    implements Comparator<Entity> {
        private final Entity theEntity;

        public Sorter(Entity theEntityIn) {
            this.theEntity = theEntityIn;
        }

        @Override
        public int compare(Entity p_compare_1_, Entity p_compare_2_) {
            double d1;
            double d0 = this.theEntity.func_70068_e(p_compare_1_);
            return d0 < (d1 = this.theEntity.func_70068_e(p_compare_2_)) ? -1 : (d0 > d1 ? 1 : 0);
        }
    }
}

