/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.world;

import com.github.alexthe666.rats.server.blocks.RatsBlockRegistry;
import com.github.alexthe666.rats.server.world.PerlinNoise;
import com.github.alexthe666.rats.server.world.gen.MapGenRatRoad;
import com.github.alexthe666.rats.server.world.gen.WorldGenAquaduct;
import com.github.alexthe666.rats.server.world.gen.WorldGenRatRuin;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.BlockLiquid;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.MapGenCaves;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraft.world.gen.feature.WorldGenDungeons;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraft.world.gen.structure.MapGenStronghold;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ChunkProviderRatlantis
implements IChunkGenerator {
    protected static final NoiseGeneratorPerlin PATH_PERLIN = new NoiseGeneratorPerlin(new Random(2345L), 1);
    public double width;
    public int height;
    public PerlinNoise perlin1;
    public PerlinNoise perlin2;
    private Random rand;
    private World world;
    private Biome[] biomesForGeneration;
    private MapGenBase caveGenerator = new MapGenCaves();
    private MapGenStronghold strongholdGenerator = new MapGenStronghold();
    private MapGenRatRoad ratRoadGenerator = new MapGenRatRoad();
    private int drawnPaths = 0;

    public ChunkProviderRatlantis(World par1World, long par2) {
        this.world = par1World;
        this.rand = new Random(par2);
        this.perlin1 = new PerlinNoise(par2);
        this.perlin2 = new PerlinNoise(par2 + 100L);
        this.width = 5.0;
        this.height = 100;
    }

    public void generateTerrain(int chunkX, int chunkZ, ChunkPrimer chunkprimer) {
        int x = chunkX << 4;
        int z = chunkZ << 4;
        for (int i = x; i < x + 16; ++i) {
            for (int k = z; k < z + 16; ++k) {
                float dis = this.perlin2.turbulence2((float)i / 150.0f, (float)k / 150.0f, 10.0f) * 300.0f + 200.0f;
                float heightBase = (float)this.height - dis / (float)this.width + this.perlin1.turbulence2((float)i / 50.0f, (float)k / 50.0f, 4.0f) * 5.0f;
                for (int y = 0; y < 256; ++y) {
                    Object i4 = Blocks.field_150350_a;
                    if (heightBase > 67.0f) {
                        if (y < 2 + this.rand.nextInt(2)) {
                            i4 = Blocks.field_150357_h;
                        } else if ((float)y < heightBase - 3.0f) {
                            i4 = Blocks.field_150348_b;
                        } else if ((float)y < heightBase - 1.0f) {
                            i4 = Blocks.field_150346_d;
                        } else if ((float)y < heightBase) {
                            i4 = this.isPath(i, k) ? RatsBlockRegistry.MARBLED_CHEESE_BRICK_CRACKED : Blocks.field_150349_c;
                        }
                    } else if (y < 2 + this.rand.nextInt(2)) {
                        i4 = Blocks.field_150357_h;
                    } else if ((float)y < heightBase - 6.0f + (float)this.rand.nextInt(3)) {
                        i4 = Blocks.field_150348_b;
                    } else if ((float)y < heightBase - 3.0f) {
                        i4 = Blocks.field_150322_A;
                    } else if ((float)y < heightBase) {
                        i4 = Blocks.field_150354_m;
                    } else if (y <= 64) {
                        i4 = Blocks.field_150355_j;
                    }
                    chunkprimer.func_177855_a(i - x, y, k - z, i4.func_176223_P());
                }
            }
        }
    }

    private boolean isPath(int i, int k) {
        return false;
    }

    public Chunk func_185932_a(int chunkX, int chunkZ) {
        this.rand.setSeed((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
        ChunkPrimer chunkprimer = new ChunkPrimer();
        this.biomesForGeneration = this.world.func_72959_q().func_76933_b(this.biomesForGeneration, chunkX * 16, chunkZ * 16, 16, 16);
        this.generateTerrain(chunkX, chunkZ, chunkprimer);
        this.caveGenerator.func_186125_a(this.world, chunkX, chunkZ, chunkprimer);
        this.strongholdGenerator.func_186125_a(this.world, chunkX, chunkZ, chunkprimer);
        this.ratRoadGenerator.func_186125_a(this.world, chunkX, chunkZ, chunkprimer);
        Chunk chunk = new Chunk(this.world, chunkprimer, chunkX, chunkZ);
        byte[] biomeIds = chunk.func_76605_m();
        for (int var6 = 0; var6 < biomeIds.length; ++var6) {
            biomeIds[var6] = (byte)Biome.func_185362_a((Biome)this.biomesForGeneration[var6]);
        }
        chunk.func_76603_b();
        return chunk;
    }

    public void func_185931_b(int chunkX, int chunkZ) {
        BlockFalling.field_149832_M = true;
        BlockPos blockpos = new BlockPos(chunkX * 16, 0, chunkZ * 16);
        Biome biome = this.world.func_180494_b(blockpos.func_177982_a(16, 0, 16));
        this.rand.setSeed(this.world.func_72905_C());
        long randLongX = this.rand.nextLong() / 2L * 2L + 1L;
        long randLongZ = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)chunkX * randLongX + (long)chunkZ * randLongZ ^ this.world.func_72905_C());
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Pre((IChunkGenerator)this, this.world, this.rand, chunkX, chunkZ, false));
        this.strongholdGenerator.func_175794_a(this.world, this.rand, new ChunkPos(chunkX, chunkZ));
        this.ratRoadGenerator.func_175794_a(this.world, this.rand, new ChunkPos(chunkX, chunkZ));
        boolean flag = false;
        if (this.rand.nextInt(8) == 0 && TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAKE)) {
            int i1 = this.rand.nextInt(16) + 8;
            int j1 = this.rand.nextInt(256);
            int k1 = this.rand.nextInt(16) + 8;
            new WorldGenLakes((Block)Blocks.field_150355_j).func_180709_b(this.world, this.rand, blockpos.func_177982_a(i1, j1, k1));
        }
        if (TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.DUNGEON)) {
            for (int j2 = 0; j2 < 8; ++j2) {
                int i3 = this.rand.nextInt(16) + 8;
                int l3 = this.rand.nextInt(256);
                int l1 = this.rand.nextInt(16) + 8;
                new WorldGenDungeons().func_180709_b(this.world, this.rand, blockpos.func_177982_a(i3, l3, l1));
            }
        }
        this.addStructures(this.world, this.rand, blockpos);
        biome.func_180624_a(this.world, this.rand, blockpos);
        if (TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ANIMALS)) {
            WorldEntitySpawner.func_77191_a((World)this.world, (Biome)biome, (int)(chunkX * 16 + 8), (int)(chunkZ * 16 + 8), (int)16, (int)16, (Random)this.rand);
        }
        blockpos = blockpos.func_177982_a(8, 0, 8);
        if (TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)chunkX, (int)chunkZ, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ICE)) {
            for (int k2 = 0; k2 < 16; ++k2) {
                for (int j3 = 0; j3 < 16; ++j3) {
                    BlockPos blockpos1 = this.world.func_175725_q(blockpos.func_177982_a(k2, 0, j3));
                    BlockPos blockpos2 = blockpos1.func_177977_b();
                    if (this.world.func_175675_v(blockpos2)) {
                        this.world.func_180501_a(blockpos2, Blocks.field_150432_aD.func_176223_P(), 2);
                    }
                    if (!this.world.func_175708_f(blockpos1, true)) continue;
                    this.world.func_180501_a(blockpos1, Blocks.field_150431_aC.func_176223_P(), 2);
                }
            }
        }
        BlockFalling.field_149832_M = false;
    }

    private void addStructures(World world, Random rand, BlockPos blockpos) {
        if (rand.nextInt(4) == 0 && world.func_180495_p(world.func_175645_m(blockpos).func_177977_b()).func_185914_p()) {
            new WorldGenRatRuin(EnumFacing.field_176754_o[rand.nextInt(EnumFacing.field_176754_o.length - 1)]).func_180709_b(world, rand, blockpos);
        }
        if (rand.nextInt(40) == 0 && world.func_180495_p(world.func_175645_m(blockpos).func_177977_b()).func_177230_c() instanceof BlockLiquid) {
            new WorldGenAquaduct(EnumFacing.field_176754_o[rand.nextInt(EnumFacing.field_176754_o.length - 1)]).func_180709_b(world, rand, blockpos);
        }
    }

    public boolean func_185933_a(Chunk chunkIn, int x, int z) {
        return false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        Biome biome = this.world.func_180494_b(pos);
        return biome.func_76747_a(creatureType);
    }

    @Nullable
    public BlockPos func_180513_a(World worldIn, String structureName, BlockPos position, boolean findUnexplored) {
        return null;
    }

    public void func_180514_a(Chunk chunkIn, int x, int z) {
    }

    public boolean func_193414_a(World worldIn, String structureName, BlockPos pos) {
        return false;
    }
}

