/*
 * Decompiled with CFR 0.152.
 */
package shadows.plants2.block;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import shadows.placebo.Placebo;
import shadows.placebo.client.IHasModel;
import shadows.placebo.interfaces.IPostInitUpdate;
import shadows.placebo.interfaces.ISpecialPlacement;
import shadows.placebo.itemblock.ItemBlockBase;
import shadows.plants2.Plants2;
import shadows.plants2.data.PlantConfig;
import shadows.plants2.util.PlantUtil;

public abstract class BushBase
extends BlockBush
implements IHasModel,
IShearable,
IPostInitUpdate,
ISpecialPlacement {
    protected final EnumPlantType type;
    public static final AxisAlignedBB AABB = new AxisAlignedBB(0.2, 0.0, 0.2, 0.8, 0.75, 0.8);

    public BushBase(String name, EnumPlantType type) {
        this.setRegistryName(name);
        this.func_149663_c(Plants2.INFO.getID() + "." + name);
        this.func_149647_a(Plants2.INFO.getDefaultTab());
        this.type = type;
        this.func_149675_a(false);
        this.func_149672_a(SoundType.field_185850_c);
        Plants2.INFO.getBlockList().add((Object)this);
        ItemBlock ib = this.createItemBlock();
        if (ib != null) {
            Plants2.INFO.getItemList().add((Object)ib);
        }
        Placebo.UPDATES.add(this);
    }

    public BushBase(String name) {
        this(name, EnumPlantType.Plains);
    }

    public ItemBlock createItemBlock() {
        return new ItemBlockBase((Block)this);
    }

    protected boolean func_185514_i(IBlockState state) {
        return false;
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos) && this.func_180671_f(world, pos, this.func_176223_P());
    }

    public boolean func_180671_f(World world, BlockPos pos, IBlockState state) {
        IBlockState soil = world.func_180495_p(pos.func_177977_b());
        return soil.func_177230_c().canSustainPlant(soil, (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this) || this.isValidSoil(world, pos.func_177977_b(), state, soil);
    }

    public boolean isValidSoil(World world, BlockPos pos, IBlockState state, IBlockState soil) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return this.type;
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return PlantConfig.needShears;
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        return this.getActualDrops(world, pos, world.func_180495_p(pos), fortune);
    }

    public void getDrops(NonNullList<ItemStack> list, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        if (!PlantConfig.needShears) {
            list.addAll(this.getActualDrops(world, pos, state, fortune));
        }
    }

    public List<ItemStack> getActualDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> k = new ArrayList<ItemStack>();
        k.add(new ItemStack(this.func_180660_a(state, RANDOM, fortune), this.func_149745_a(RANDOM), this.func_180651_a(state)));
        return k;
    }

    public boolean placeStateAt(IBlockState state, World world, BlockPos pos) {
        return world.func_175656_a(pos, state);
    }

    protected void addStatesToList() {
        PlantUtil.TYPE_TO_STATES.get(this.type).add(this.func_176223_P());
    }

    public void postInit(FMLPostInitializationEvent e) {
        this.addStatesToList();
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 100;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 60;
    }
}

