/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges.blocks;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHopper;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.DyeUtils;
import wile.rsgauges.ModContent;
import wile.rsgauges.blocks.RsBlock;
import wile.rsgauges.detail.ModAuxiliaries;
import wile.rsgauges.detail.ModConfig;
import wile.rsgauges.detail.ModResources;
import wile.rsgauges.items.ItemSwitchLinkPearl;

public class BlockSwitch
extends RsBlock
implements ModContent.Colors.ColorTintSupport {
    public static final long SWITCH_DATA_POWERED_POWER_MASK = 15L;
    public static final long SWITCH_DATA_UNPOWERED_POWER_MASK = 240L;
    public static final long SWITCH_DATA_INVERTED = 256L;
    public static final long SWITCH_DATA_WEAK = 512L;
    public static final long SWITCH_DATA_NOOUTPUT = 1024L;
    public static final long SWITCH_DATA_SIDE_ENABLED_BOTTOM = 4096L;
    public static final long SWITCH_DATA_SIDE_ENABLED_TOP = 8192L;
    public static final long SWITCH_DATA_SIDE_ENABLED_FRONT = 16384L;
    public static final long SWITCH_DATA_SIDE_ENABLED_BACK = 32768L;
    public static final long SWITCH_DATA_SIDE_ENABLED_LEFT = 65536L;
    public static final long SWITCH_DATA_SIDE_ENABLED_RIGHT = 131072L;
    public static final long SWITCH_DATA_SIDE_ENABLED_ALL = 258048L;
    public static final long SWITCH_DATA_SIDE_ENABLED_MASK = 258048L;
    public static final long SWITCH_DATA_SIDE_ENABLED_SHIFT = 12L;
    public static final long SWITCH_DATA_ENTITY_DEFAULTS_MASK = 262143L;
    public static final long SWITCH_CONFIG_INVERTABLE = 0x100000L;
    public static final long SWITCH_CONFIG_WEAKABLE = 0x200000L;
    public static final long SWITCH_CONFIG_PULSETIME_CONFIGURABLE = 0x400000L;
    public static final long SWITCH_CONFIG_TOUCH_CONFIGURABLE = 0x800000L;
    public static final long SWITCH_CONFIG_PULSE_EXTENDABLE = 0x1000000L;
    public static final long SWITCH_CONFIG_LCLICK_RESETTABLE = 0x2000000L;
    public static final long SWITCH_CONFIG_BISTABLE = 0x10000000L;
    public static final long SWITCH_CONFIG_PULSE = 0x20000000L;
    public static final long SWITCH_CONFIG_CONTACT = 0x40000000L;
    public static final long SWITCH_CONFIG_TIMER_DAYTIME = 0x100000000L;
    public static final long SWITCH_CONFIG_TIMER_INTERVAL = 0x200000000L;
    public static final long SWITCH_CONFIG_SENSOR_VOLUME = 0x400000000L;
    public static final long SWITCH_CONFIG_SENSOR_LINEAR = 0x800000000L;
    public static final long SWITCH_CONFIG_SENSOR_LIGHT = 0x1000000000L;
    public static final long SWITCH_CONFIG_SENSOR_RAIN = 0x2000000000L;
    public static final long SWITCH_CONFIG_SENSOR_LIGHTNING = 0x4000000000L;
    public static final long SWITCH_CONFIG_SENSOR_BLOCKDETECT = 0x8000000000L;
    public static final long SWITCH_CONFIG_SENSOR_TIME = 0x200000000L;
    public static final long SWITCH_CONFIG_SENSOR_DETECTOR = 0xC00000000L;
    public static final long SWITCH_CONFIG_SENSOR_ENVIRONMENTAL = 0x7100000000L;
    public static final long SWITCH_CONFIG_AUTOMATIC = 0xFF00000000L;
    public static final long SWITCH_CONFIG_WALLMOUNT = 0x10000000000L;
    public static final long SWITCH_CONFIG_LATERAL = 0x20000000000L;
    public static final long SWITCH_CONFIG_LATERAL_WALLMOUNT = 0x30000000000L;
    public static final long SWITCH_CONFIG_OPPOSITE_PLACEMENT = 0x40000000000L;
    public static final long SWITCH_CONFIG_FULLCUBIC_BLOCK = 0x80000000000L;
    public static final long SWITCH_CONFIG_PROJECTILE_SENSE_ON = 0x100000000000L;
    public static final long SWITCH_CONFIG_PROJECTILE_SENSE_OFF = 0x200000000000L;
    public static final long SWITCH_CONFIG_PROJECTILE_SENSE = 0x300000000000L;
    public static final long SWITCH_CONFIG_SHOCK_SENSITIVE = 0x400000000000L;
    public static final long SWITCH_CONFIG_HIGH_SENSITIVE = 0x800000000000L;
    public static final long SWITCH_CONFIG_TRANSLUCENT = 0x1000000000000L;
    public static final long SWITCH_CONFIG_FAINT_LIGHTSOURCE = 0x2000000000000L;
    public static final long SWITCH_CONFIG_COLOR_TINT_SUPPORT = 0x4000000000000L;
    public static final long SWITCH_CONFIG_NOT_PISTON_MOUNTBALE = 0x8000000000000L;
    public static final long SWITCH_CONFIG_NOT_PASSABLE = 0x10000000000000L;
    public static final long SWITCH_CONFIG_HOPPER_MOUNTBALE = 0x20000000000000L;
    public static final long SWITCH_CONFIG_SIDES_CONFIGURABLE = 0x40000000000000L;
    public static final long SWITCH_CONFIG_LINK_SOURCE_SUPPORT = 0x100000000000000L;
    public static final long SWITCH_CONFIG_LINK_TARGET_SUPPORT = 0x200000000000000L;
    public static final long SWITCH_CONFIG_LINK_RELAY = 0x400000000000000L;
    public static final int SWITCH_DATA_SVD_ACTIVE_TIME_MASK = 255;
    public static final int SWITCH_DATA_SVD_COLOR_MASK = 3840;
    public static final int SWITCH_DATA_SVD_COLOR_SHIFT = 8;
    public static final int base_tick_rate = 2;
    public static final int default_pulse_on_time = 20;
    public final long config;
    @Nullable
    protected final AxisAlignedBB unrotated_bb_powered;
    protected final ModResources.BlockSoundEvent power_on_sound;
    protected final ModResources.BlockSoundEvent power_off_sound;
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");

    public BlockSwitch(String registryName, AxisAlignedBB unrotatedBBUnpowered, @Nullable AxisAlignedBB unrotatedBBPowered, long config, @Nullable ModResources.BlockSoundEvent powerOnSound, @Nullable ModResources.BlockSoundEvent powerOffSound, @Nullable Material material) {
        super(registryName, unrotatedBBUnpowered, material);
        if (powerOnSound == null && powerOffSound == null) {
            powerOnSound = ModResources.BlockSoundEvents.DEFAULT_SWITCH_ACTIVATION;
            powerOffSound = ModResources.BlockSoundEvents.DEFAULT_SWITCH_DEACTIVATION;
        } else {
            if (powerOnSound == null) {
                powerOnSound = ModResources.BlockSoundEvents.DEFAULT_SWITCH_MUTE;
            }
            if (powerOffSound == null) {
                powerOffSound = ModResources.BlockSoundEvents.DEFAULT_SWITCH_MUTE;
            }
        }
        this.unrotated_bb_powered = unrotatedBBPowered != null ? unrotatedBBPowered : unrotatedBBUnpowered;
        this.power_on_sound = powerOnSound;
        this.power_off_sound = powerOffSound;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
        if ((config & 0xFFL) == 255L) {
            config &= 0xFFFFFFFFFFFFFF00L;
        } else if ((config & 0xFFL) == 0L) {
            config |= 0xFL;
        }
        if ((config & 0x3F000L) != 0L) {
            config |= 0x40000000000000L;
        }
        this.config = config;
    }

    public BlockSwitch(String registryName, AxisAlignedBB unrotatedBBUnpowered, AxisAlignedBB unrotatedBBPowered, long config, @Nullable ModResources.BlockSoundEvent powerOnSound, @Nullable ModResources.BlockSoundEvent powerOffSound) {
        this(registryName, unrotatedBBUnpowered, unrotatedBBPowered, config, powerOnSound, powerOffSound, null);
    }

    @Override
    public AxisAlignedBB getUnrotatedBB(IBlockState state) {
        return state == null || state.func_177230_c() != this || (Boolean)state.func_177229_b((IProperty)POWERED) == false ? super.getUnrotatedBB() : this.unrotated_bb_powered;
    }

    @Override
    public boolean isWallMount() {
        return (this.config & 0x10000000000L) != 0L;
    }

    @Override
    public boolean isLateral() {
        return (this.config & 0x20000000000L) != 0L;
    }

    @Override
    public boolean isCube() {
        return (this.config & 0x80000000000L) != 0L;
    }

    @Override
    public boolean isOppositePlacement() {
        return (this.config & 0x40000000000L) != 0L;
    }

    @Override
    public boolean hasColorMultiplierRGBA() {
        return !ModConfig.optouts.without_color_tinting && (this.config & 0x4000000000000L) != 0L;
    }

    @Override
    public int getColorMultiplierRGBA(@Nullable IBlockState state, @Nullable IBlockAccess world, @Nullable BlockPos pos) {
        if (pos == null || world == null) {
            return -1;
        }
        TileEntitySwitch te = this.getTe(world, pos);
        if (te == null) {
            return -1;
        }
        return ModAuxiliaries.DyeColorFilters.byIndex(te.color_tint());
    }

    public boolean onLinkRequest(ItemSwitchLinkPearl.SwitchLink link, long req, World world, BlockPos pos, @Nullable EntityPlayer player) {
        if ((this.config & 0x30000000L) == 0L) {
            return false;
        }
        TileEntitySwitch te = this.getTe((IBlockAccess)world, pos);
        if (te == null || !te.check_link_request(link)) {
            return false;
        }
        return this.onSwitchActivated(world, pos, world.func_180495_p(pos), player, null);
    }

    protected void notifyNeighbours(World world, BlockPos pos, IBlockState state, @Nullable TileEntitySwitch te, boolean force) {
        if (!force && te != null && te.nooutput()) {
            return;
        }
        if (ForgeEventFactory.onNeighborNotify((World)world, (BlockPos)pos, (IBlockState)state, EnumSet.allOf(EnumFacing.class), (boolean)false).isCanceled()) {
            return;
        }
        if ((this.config & 0x40000000000000L) != 0L) {
            if (te == null) {
                return;
            }
            long disabled_sides = te.enabled_sides();
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                if ((disabled_sides & 1L << this.getAbsoluteFacing(state, facing).func_176745_a() << 12) == 0L || ForgeEventFactory.onNeighborNotify((World)world, (BlockPos)pos, (IBlockState)state, EnumSet.of(facing), (boolean)false).isCanceled()) continue;
                world.func_190524_a(pos.func_177972_a(facing), (Block)this, pos);
                if (!force && te.weak()) continue;
                world.func_175695_a(pos.func_177972_a(facing), (Block)this, facing.func_176734_d());
            }
        } else if (!this.isLateral() && this.isWallMount()) {
            EnumFacing wall = ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176734_d();
            world.func_190524_a(pos.func_177972_a(wall), (Block)this, pos);
            if (force || !te.weak()) {
                world.func_175695_a(pos.func_177972_a(wall), (Block)this, wall.func_176734_d());
            }
        } else if (this.isLateral() && !this.isWallMount()) {
            EnumFacing wall = (EnumFacing)state.func_177229_b((IProperty)FACING);
            world.func_190524_a(pos.func_177972_a(wall), (Block)this, pos);
            world.func_190524_a(pos.func_177977_b(), (Block)this, pos);
            if (force || !te.weak()) {
                world.func_175695_a(pos.func_177972_a(wall), (Block)this, wall.func_176734_d());
                world.func_175695_a(pos.func_177977_b(), (Block)this, EnumFacing.UP);
            }
        } else if (this.isLateral() && this.isWallMount()) {
            EnumFacing wall = (EnumFacing)state.func_177229_b((IProperty)FACING);
            world.func_190524_a(pos.func_177972_a(wall), (Block)this, pos);
            if (force || !te.weak()) {
                world.func_175695_a(pos.func_177972_a(wall), (Block)this, wall.func_176734_d());
            }
        } else {
            world.func_175685_c(pos, (Block)this, false);
            if (force || !te.weak()) {
                world.func_175695_a(pos.func_177977_b(), (Block)this, EnumFacing.UP);
                world.func_175695_a(pos.func_177984_a(), (Block)this, EnumFacing.DOWN);
                world.func_175695_a(pos.func_177974_f(), (Block)this, EnumFacing.WEST);
                world.func_175695_a(pos.func_177976_e(), (Block)this, EnumFacing.EAST);
                world.func_175695_a(pos.func_177978_c(), (Block)this, EnumFacing.SOUTH);
                world.func_175695_a(pos.func_177968_d(), (Block)this, EnumFacing.NORTH);
            }
        }
    }

    private int getPower(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side, boolean strong) {
        if ((this.config & 0x400000000000000L) != 0L || !(world instanceof World)) {
            return 0;
        }
        if ((this.config & 0x40000000L) != 0L) {
            if (side != ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176734_d() && (side != EnumFacing.UP || this.isWallMount())) {
                return 0;
            }
            TileEntitySwitch te = this.getTe((IBlockAccess)((World)world), pos);
            return te == null ? 0 : te.power(state, strong);
        }
        if ((this.config & 0x40000000000000L) == 0L) {
            boolean is_main_direction = side == (this.isLateral() ? ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176734_d() : (EnumFacing)state.func_177229_b((IProperty)FACING));
            TileEntitySwitch te = this.getTe((IBlockAccess)((World)world), pos);
            if (!is_main_direction && (strong || te.weak())) {
                return 0;
            }
            return te == null ? 0 : te.power(state, strong);
        }
        TileEntitySwitch te = this.getTe((IBlockAccess)((World)world), pos);
        if (te == null) {
            return 0;
        }
        if ((te.enabled_sides() & 1L << this.getAbsoluteFacing(state, side.func_176734_d()).func_176745_a() << 12) == 0L) {
            return 0;
        }
        return te.power(state, strong);
    }

    protected boolean onSwitchActivated(World world, BlockPos pos, IBlockState state, @Nullable EntityPlayer player, @Nullable EnumFacing facing) {
        if (world.field_72995_K || !(state.func_177230_c() instanceof BlockSwitch)) {
            return true;
        }
        TileEntitySwitch te = this.getTe((IBlockAccess)world, pos);
        if (te == null) {
            return true;
        }
        boolean was_powered = (Boolean)state.func_177229_b((IProperty)POWERED);
        if ((this.config & 0x8010000000L) != 0L) {
            state = state.func_177231_a((IProperty)POWERED);
            world.func_180501_a(pos, state, 3);
            if (was_powered) {
                this.power_off_sound.play(world, pos);
            } else {
                this.power_on_sound.play(world, pos);
            }
        } else {
            world.func_180501_a(pos, state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(true)), 3);
            this.power_on_sound.play(world, pos);
        }
        if ((this.config & 0x400000000000000L) == 0L) {
            this.notifyNeighbours(world, pos, state, te, false);
        }
        if ((this.config & 0x20000000L) != 0L) {
            if ((this.config & 0x1000000L) == 0L) {
                te.on_timer_reset();
            }
            te.on_timer_extend();
            te.reschedule_block_tick();
        }
        if ((this.config & 0x100000000000000L) != 0L && (this.config & 0x8030000000L) != 0L) {
            if (!was_powered) {
                if (!te.activate_links(1)) {
                    ModResources.BlockSoundEvents.SWITCHLINK_LINK_PEAL_USE_FAILED.play(world, pos);
                }
            } else if ((this.config & 0x20000000L) == 0L && !te.activate_links(2)) {
                ModResources.BlockSoundEvents.SWITCHLINK_LINK_PEAL_USE_FAILED.play(world, pos);
            }
        }
        return true;
    }

    @Override
    protected void onRsBlockDestroyed(IBlockState state, World world, BlockPos pos, boolean isUpdateEvent) {
        TileEntitySwitch te = this.getTe((IBlockAccess)world, pos);
        if (te != null) {
            te.unlink_all(true);
        }
        te.nooutput(true);
        if (isUpdateEvent) {
            world.func_175698_g(pos);
        }
        this.notifyNeighbours(world, pos, state, te, true);
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)(meta & 7))).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf((meta & 8) != 0));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a() & 7 | ((Boolean)state.func_177229_b((IProperty)POWERED) != false ? 8 : 0);
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, POWERED});
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return (this.config & 0x1000000000000L) != 0L ? BlockRenderLayer.TRANSLUCENT : BlockRenderLayer.CUTOUT;
    }

    @Override
    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return (this.config & 0x10000000000000L) == 0L ? field_185506_k : this.func_185496_a(state, world, pos);
    }

    public int func_149750_m(IBlockState state) {
        return (this.config & 0x2000000000000L) != 0L && ModAuxiliaries.isClientSide() ? 1 : 0;
    }

    public boolean func_149744_f(IBlockState state) {
        return (this.config & 0x400000000000000L) == 0L;
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable EnumFacing side) {
        return !this.isWallMount() && (side == null || side == EnumFacing.UP || side == state.func_177229_b((IProperty)FACING));
    }

    public int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return this.getPower(state, world, pos, side, false);
    }

    public int func_176211_b(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return this.getPower(state, world, pos, side, true);
    }

    @Override
    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        if ((this.config & 0x20000000000000L) == 0L) {
            return super.func_176198_a(world, pos, side);
        }
        return super.canPlaceBlockOnSide(world, pos, side, (Predicate<Block>)((Predicate)block -> {
            if ((this.config & 0x20000000000000L) != 0L && block instanceof BlockHopper) {
                return true;
            }
            return (this.config & 0x8000000000000L) == 0L || !BlockSwitch.func_193382_c((Block)block);
        }), null);
    }

    @Override
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighborBlock, BlockPos neighbourPos) {
        if (!this.neighborChangedCheck(state, world, pos, neighborBlock, neighbourPos)) {
            return;
        }
        if ((this.config & 0x400000000000000L) == 0L) {
            return;
        }
        TileEntitySwitch te = this.getTe((IBlockAccess)world, pos);
        if (te == null) {
            return;
        }
        boolean powered = world.func_175709_b(neighbourPos, ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176734_d());
        if ((this.config & 0x100000L) != 0L && te.inverted()) {
            powered = !powered;
        }
        if (te.on_power() == 0 == powered) {
            return;
        }
        te.on_power(powered ? 0 : 15);
        if ((this.config & 0x10000000L) != 0L && (Boolean)state.func_177229_b((IProperty)POWERED) == powered) {
            return;
        }
        if ((this.config & 0x20000000L) != 0L && (!powered || ((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue())) {
            return;
        }
        this.onSwitchActivated(world, pos, state, null, null);
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntitySwitch te = this.getTe((IBlockAccess)world, pos);
        if (te != null) {
            te.reset();
        }
        if (!super.onBlockPlacedByCheck(world, pos, state, placer, stack)) {
            return;
        }
        world.func_180501_a(pos, world.func_180495_p(pos).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)), 3);
        this.notifyNeighbours(world, pos, state, te, true);
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (world.field_72995_K || (this.config & 0x300000000000L) == 0L || !(entity instanceof IProjectile)) {
            return;
        }
        if ((Boolean)state.func_177229_b((IProperty)POWERED) != false ? (this.config & 0x200000000000L) == 0L : (this.config & 0x100000000000L) == 0L) {
            return;
        }
        this.onSwitchActivated(world, pos, state, null, null);
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K || !(state.func_177230_c() instanceof BlockSwitch)) {
            return true;
        }
        TileEntitySwitch te = this.getTe((IBlockAccess)world, pos);
        if (te == null) {
            return true;
        }
        te.click_config(null, false);
        ClickInteraction ck = ClickInteraction.get(world, pos, state, player, hand, facing, hitX, hitY, hitZ);
        if (ck.touch_configured) {
            if (te.activation_config(state, player, ck.x, ck.y)) {
                ModResources.BlockSoundEvents.DEFAULT_SWITCH_CONFIGCLICK.play(world, pos);
            }
            return true;
        }
        if (ck.wrenched) {
            if (te.click_config(this, false)) {
                ModResources.BlockSoundEvents.DEFAULT_SWITCH_CONFIGCLICK.play(world, pos);
                ModAuxiliaries.playerStatusMessage(player, te.configStatusTextComponentTranslation((BlockSwitch)state.func_177230_c()));
            }
            return true;
        }
        if (!ModConfig.optouts.without_rightclick_item_switchconfig && (ck.item == Items.field_151137_ax && (((BlockSwitch)state.func_177230_c()).config & 0x400000L) != 0L || ck.item == Items.field_151079_bi || ck.item == ModContent.SWITCH_LINK_PEARL)) {
            this.func_180649_a(world, pos, player);
            return true;
        }
        if ((this.config & 0x30000000L) == 0L) {
            return true;
        }
        return this.onSwitchActivated(world, pos, state, player, facing);
    }

    @Override
    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        if (world.field_72995_K || player == null) {
            return;
        }
        IBlockState state = world.func_180495_p(pos);
        if (!(state.func_177230_c() instanceof BlockSwitch)) {
            return;
        }
        TileEntitySwitch te = this.getTe((IBlockAccess)world, pos);
        if (te == null) {
            return;
        }
        Item item_held = player.field_71071_by.func_70448_g() != null ? player.field_71071_by.func_70448_g().func_77973_b() : Items.field_190931_a;
        ClickInteraction ck = ClickInteraction.get(world, pos, null, player, null, null, 0.0f, 0.0f, 0.0f);
        if (ck.wrenched) {
            if (te.click_config(this, false)) {
                ModAuxiliaries.playerStatusMessage(player, te.configStatusTextComponentTranslation((BlockSwitch)state.func_177230_c()));
                return;
            }
        } else if (ck.item == Items.field_151137_ax && (((BlockSwitch)state.func_177230_c()).config & 0x400000L) != 0L) {
            if (!ModConfig.optouts.without_pulsetime_config) {
                te.configured_on_time(ck.item_count * 2);
                ModAuxiliaries.playerStatusMessage(player, te.configStatusTextComponentTranslation((BlockSwitch)state.func_177230_c()));
                return;
            }
        } else if (ck.dye >= 0 && (((BlockSwitch)state.func_177230_c()).config & 0x4000000000000L) != 0L) {
            if (!ModConfig.optouts.without_color_tinting && ck.dye <= 15) {
                te.color_tint(ck.dye);
                world.markAndNotifyBlock(pos, null, state, state, 23);
                ModAuxiliaries.playerStatusMessage(player, ModAuxiliaries.localizable("switchconfig.tinting", null, ModAuxiliaries.localizable("switchconfig.tinting." + ModAuxiliaries.DyeColorFilters.nameByIndex[ck.dye & 0xF], null, new Object[0])));
                return;
            }
        } else if (ck.item == Items.field_151079_bi) {
            if (!ModConfig.optouts.without_switch_linking) {
                BlockSwitch block = (BlockSwitch)state.func_177230_c();
                if ((block.config & 0x200000000000000L) == 0L) {
                    ModAuxiliaries.playerStatusMessage(player, ModAuxiliaries.localizable("switchlinking.target_assign.error_notarget", null, new Object[0]));
                    ModResources.BlockSoundEvents.SWITCHLINK_CANNOT_LINK_THAT.play(world, pos);
                } else {
                    ItemStack link_stack = ItemSwitchLinkPearl.createFromEnderPearl(world, pos, player);
                    if (link_stack == null || link_stack.func_77978_p() == null) {
                        ModResources.BlockSoundEvents.SWITCHLINK_CANNOT_LINK_THAT.play(world, pos);
                    } else {
                        link_stack.func_77978_p().func_74772_a("cdtime", world.func_82737_E());
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, link_stack);
                        ModAuxiliaries.playerStatusMessage(player, ModAuxiliaries.localizable("switchlinking.target_assign.ok", null, new Object[0]));
                        ModResources.BlockSoundEvents.SWITCHLINK_LINK_TARGET_SELECTED.play(world, pos);
                    }
                }
                return;
            }
        } else if (ck.item == ModContent.SWITCH_LINK_PEARL && player.field_71071_by != null && item_held == ModContent.SWITCH_LINK_PEARL) {
            if (!ModConfig.optouts.without_switch_linking) {
                switch (te.assign_switchlink(world, pos, player.field_71071_by.func_70448_g())) {
                    case OK: {
                        player.field_71071_by.func_70448_g().func_190918_g(1);
                        ModResources.BlockSoundEvents.SWITCHLINK_LINK_SOURCE_SELECTED.play(world, pos);
                        ModAuxiliaries.playerStatusMessage(player, ModAuxiliaries.localizable("switchlinking.source_assign.ok", null, new Object[0]));
                        return;
                    }
                    case E_SELF_ASSIGN: {
                        long cdtime = player.field_71071_by.func_70448_g().func_77978_p().func_74763_f("cdtime");
                        if (Math.abs(world.func_82737_E() - cdtime) < 7L) {
                            return;
                        }
                        ItemSwitchLinkPearl.getCycledRelay(player.field_71071_by.func_70448_g(), world, pos);
                        ModAuxiliaries.playerStatusMessage(player, ModAuxiliaries.localizable("switchlinking.relayconfig.confval" + Integer.toString(ItemSwitchLinkPearl.SwitchLink.fromItemStack(player.field_71071_by.func_70448_g()).relay()), null, new Object[0]));
                        player.field_71071_by.func_70448_g().func_77978_p().func_74772_a("cdtime", world.func_82737_E());
                        return;
                    }
                    case E_NOSOURCE: {
                        ModAuxiliaries.playerStatusMessage(player, ModAuxiliaries.localizable("switchlinking.source_assign.error_nosource", null, new Object[0]));
                        break;
                    }
                    case E_ALREADY_LINKED: {
                        ModAuxiliaries.playerStatusMessage(player, ModAuxiliaries.localizable("switchlinking.source_assign.error_alreadylinked", null, new Object[0]));
                        break;
                    }
                    case E_TOO_FAR: {
                        ModAuxiliaries.playerStatusMessage(player, ModAuxiliaries.localizable("switchlinking.source_assign.error_toofaraway", null, new Object[0]));
                        break;
                    }
                    case E_FAILED: {
                        ModAuxiliaries.playerStatusMessage(player, ModAuxiliaries.localizable("switchlinking.source_assign.error_failed", null, new Object[0]));
                    }
                }
                ModResources.BlockSoundEvents.SWITCHLINK_LINK_SOURCE_FAILED.play(world, pos);
            }
            return;
        }
        if (item_held == Items.field_190931_a && te.click_config(this, true)) {
            ModResources.BlockSoundEvents.DEFAULT_SWITCH_CONFIGCLICK.play(world, pos);
            ModAuxiliaries.playerStatusMessage(player, te.configStatusTextComponentTranslation((BlockSwitch)state.func_177230_c()));
            return;
        }
        if ((this.config & 0x2000000L) != 0L) {
            te.on_timer_reset();
            if (!((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
                return;
            }
            world.func_180501_a(pos, state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)), 3);
            this.power_off_sound.play(world, pos);
        }
        if ((this.config & 0x400000000000000L) == 0L && !te.nooutput()) {
            this.notifyNeighbours(world, pos, state, te, false);
        }
    }

    public int func_149738_a(World world) {
        return 2;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (world.field_72995_K || !((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            return;
        }
        TileEntitySwitch te = this.getTe((IBlockAccess)world, pos);
        if (te != null && te.on_time_remaining() > 0) {
            te.reschedule_block_tick();
            return;
        }
        state = state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false));
        world.func_175656_a(pos, state);
        this.power_off_sound.play(world, pos);
        if ((this.config & 0x400000000000000L) == 0L) {
            this.notifyNeighbours(world, pos, state, te, false);
        }
        if ((this.config & 0x100000000000000L) != 0L && !te.activate_links(2)) {
            ModResources.BlockSoundEvents.SWITCHLINK_LINK_PEAL_USE_FAILED.play(world, pos);
        }
    }

    @Override
    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntitySwitch();
    }

    public TileEntitySwitch getTe(IBlockAccess world, BlockPos pos) {
        if (world == null) {
            return null;
        }
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof TileEntitySwitch)) {
            return null;
        }
        return (TileEntitySwitch)te;
    }

    protected static final class ClickInteraction {
        public boolean touch_configured = false;
        public boolean wrenched = false;
        public Item item = Items.field_190931_a;
        public int item_count = 0;
        public int dye = -1;
        public double x = 0.0;
        public double y = 0.0;

        protected ClickInteraction() {
        }

        public String toString() {
            return "{x:" + Double.toString(this.x) + ",y:" + Double.toString(this.y) + ",touch_configured:" + Boolean.toString(this.touch_configured) + ",wrenched:" + Boolean.toString(this.wrenched) + ",item_count:" + Integer.toString(this.item_count) + ",dye:" + Integer.toString(this.dye) + "}";
        }

        private static ClickInteraction touch(ClickInteraction ck, World world, BlockPos pos, @Nullable IBlockState state, EntityPlayer player, @Nullable EnumHand hand, @Nullable EnumFacing facing, float x, float y, float z) {
            BlockSwitch block = (BlockSwitch)state.func_177230_c();
            if (facing == null) {
                return ck;
            }
            double xo = 0.0;
            double yo = 0.0;
            if (block.isCube() || block.isWallMount() && !block.isLateral()) {
                if (!block.isCube() ? facing != state.func_177229_b((IProperty)RsBlock.FACING) : facing != ((EnumFacing)state.func_177229_b((IProperty)RsBlock.FACING)).func_176734_d()) {
                    return ck;
                }
                switch (facing.func_176745_a()) {
                    case 0: {
                        xo = 1.0f - x;
                        yo = 1.0f - z;
                        break;
                    }
                    case 1: {
                        xo = 1.0f - x;
                        yo = z;
                        break;
                    }
                    case 2: {
                        xo = 1.0f - x;
                        yo = y;
                        break;
                    }
                    case 3: {
                        xo = x;
                        yo = y;
                        break;
                    }
                    case 4: {
                        xo = z;
                        yo = y;
                        break;
                    }
                    case 5: {
                        xo = 1.0f - z;
                        yo = y;
                    }
                }
                AxisAlignedBB aa = block.getUnrotatedBB();
                xo = Math.round((xo - aa.field_72340_a) * (1.0 / (aa.field_72336_d - aa.field_72340_a)) * 15.5 - 0.25);
                yo = Math.round((yo - aa.field_72338_b) * (1.0 / (aa.field_72337_e - aa.field_72338_b)) * 15.5 - 0.25);
            } else if (block.isLateral()) {
                if (facing != EnumFacing.UP) {
                    return ck;
                }
                facing = (EnumFacing)state.func_177229_b((IProperty)RsBlock.FACING);
                switch (facing.func_176745_a()) {
                    case 0: {
                        xo = x;
                        yo = z;
                        break;
                    }
                    case 1: {
                        xo = x;
                        yo = z;
                        break;
                    }
                    case 2: {
                        xo = x;
                        yo = 1.0f - z;
                        break;
                    }
                    case 3: {
                        xo = 1.0f - x;
                        yo = z;
                        break;
                    }
                    case 4: {
                        xo = 1.0f - z;
                        yo = 1.0f - x;
                        break;
                    }
                    case 5: {
                        xo = z;
                        yo = x;
                    }
                }
                AxisAlignedBB aa = block.getUnrotatedBB();
                xo = 0.1 * (double)Math.round(10.0 * ((xo - aa.field_72340_a) * (1.0 / (aa.field_72336_d - aa.field_72340_a)) * 15.5 - 0.25));
                yo = 0.1 * (double)Math.round(10.0 * ((yo - (1.0 - aa.field_72334_f)) * (1.0 / (aa.field_72334_f - aa.field_72339_c)) * 15.5 - 0.25));
            } else {
                return ck;
            }
            double d = xo > 15.0 ? 15.0 : (ck.x = xo < 0.0 ? 0.0 : xo);
            ck.y = yo > 15.0 ? 15.0 : (yo < 0.0 ? 0.0 : yo);
            ck.touch_configured = true;
            return ck;
        }

        public static ClickInteraction get(World world, BlockPos pos, @Nullable IBlockState state, EntityPlayer player, @Nullable EnumHand hand, @Nullable EnumFacing facing, float x, float y, float z) {
            ClickInteraction ck = new ClickInteraction();
            if (world == null || pos == null) {
                return ck;
            }
            if (state == null) {
                state = world.func_180495_p(pos);
            }
            if (state == null || !(state.func_177230_c() instanceof BlockSwitch)) {
                return ck;
            }
            BlockSwitch block = (BlockSwitch)state.func_177230_c();
            ItemStack item = player.func_184614_ca();
            if (item == null) {
                return ck;
            }
            if (item.func_77973_b() == Items.field_151137_ax) {
                ck.item = Items.field_151137_ax;
                ck.item_count = item.func_190916_E();
            } else if (item.func_77973_b() == Items.field_151079_bi) {
                ck.item = Items.field_151079_bi;
                ck.item_count = item.func_190916_E();
            } else if (item.func_77973_b() == ModContent.SWITCH_LINK_PEARL) {
                ck.item = ModContent.SWITCH_LINK_PEARL;
                ck.item_count = item.func_190916_E();
            } else if (DyeUtils.isDye((ItemStack)item)) {
                ck.item = Items.field_151100_aR;
                ck.dye = DyeUtils.rawMetaFromStack((ItemStack)item);
                if (ck.dye > 15) {
                    ck.dye = 15;
                }
            } else if (item.func_77973_b() != Items.field_190931_a) {
                ck.wrenched = ("," + ModConfig.zmisc.accepted_wrenches + ",").contains("," + item.func_77973_b().getRegistryName().func_110623_a() + ",");
                if (ck.wrenched) {
                    return ck;
                }
            }
            if ((block.config & 0x800000L) != 0L) {
                return ClickInteraction.touch(ck, world, pos, state, player, hand, facing, x, y, z);
            }
            return ck;
        }
    }

    public static class TileEntitySwitch
    extends RsBlock.RsTileEntity {
        protected static final int max_pulse_time = 200;
        protected long pulse_off_deadline_ = 0L;
        protected int scd_ = 0;
        protected int svd_ = 0;
        protected long click_config_time_lastclicked_ = 0L;
        protected long click_config_last_cycled_ = 0L;
        protected long last_link_request_ = 0L;
        protected ArrayList<ItemSwitchLinkPearl.SwitchLink> links_ = null;

        @Override
        public void writeNbt(NBTTagCompound nbt, boolean updatePacket) {
            nbt.func_74768_a("scd", this.scd_);
            nbt.func_74768_a("svd", this.svd_);
            if (updatePacket) {
                return;
            }
            if (this.links_ == null || this.links_.isEmpty()) {
                if (nbt.func_74764_b("links")) {
                    nbt.func_82580_o("links");
                }
            } else {
                NBTTagList tl = new NBTTagList();
                for (ItemSwitchLinkPearl.SwitchLink e : this.links_) {
                    tl.func_74742_a((NBTBase)e.toNbt());
                }
                nbt.func_74782_a("links", (NBTBase)tl);
            }
        }

        @Override
        public void readNbt(NBTTagCompound nbt, boolean updatePacket) {
            int previous_scd = this.scd_;
            int previous_svd = this.svd_;
            this.scd_ = nbt.func_74762_e("scd");
            this.svd_ = nbt.func_74762_e("svd");
            if (!updatePacket) {
                if (this.scd_ == 0) {
                    this.reset();
                }
                if (!nbt.func_74764_b("links")) {
                    if (this.links_ != null) {
                        this.links_.clear();
                    }
                } else {
                    NBTTagList tl = nbt.func_150295_c("links", (int)nbt.func_74732_a());
                    ArrayList<ItemSwitchLinkPearl.SwitchLink> links = new ArrayList<ItemSwitchLinkPearl.SwitchLink>();
                    for (NBTBase e : tl) {
                        ItemSwitchLinkPearl.SwitchLink lnk = ItemSwitchLinkPearl.SwitchLink.fromNbt((NBTTagCompound)e);
                        links.add(lnk);
                    }
                    this.links_ = links;
                }
            } else if (((this.svd_ & 0xF00) != (previous_svd & 0xF00) || ((long)this.scd_ & 0xFL) != ((long)previous_scd & 0xFL)) && this.func_145831_w() != null && this.func_145831_w().field_72995_K) {
                this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
            }
        }

        protected void func_190201_b(World world) {
            this.reset((IBlockAccess)world);
        }

        public int svd() {
            return this.svd_;
        }

        public int scd() {
            return this.scd_;
        }

        public int configured_on_time() {
            return (this.svd_ & 0xFF) >> 0;
        }

        public void configured_on_time(int t) {
            this.svd_ = this.svd_ & 0xFFFFFF00 | (t & 0xFF) << 0;
        }

        public int color_tint() {
            return (this.svd_ & 0xF00) >> 8;
        }

        public int on_power() {
            return (this.scd_ & 0xF) >> 0;
        }

        public int off_power() {
            return (this.scd_ & 0xF0) >> 8;
        }

        public boolean inverted() {
            return (this.scd_ & 0x100) != 0;
        }

        public boolean weak() {
            return (this.scd_ & 0x200) != 0;
        }

        public boolean nooutput() {
            return (this.scd_ & 0x400) != 0;
        }

        public long enabled_sides() {
            return (long)this.scd_ & 0x3F000L;
        }

        public void color_tint(int tint) {
            this.svd_ = this.svd_ & 0xFFFFF0FF | tint << 8 & 0xF00;
        }

        public void on_power(int p) {
            this.scd_ = this.scd_ & 0xFFFFFFF0 | (p < 0 ? 0 : (p > 15 ? 15 : p) & 0xF) << 0;
        }

        public void off_power(int p) {
            this.scd_ = this.scd_ & 0xFFFFFF0F | (p < 0 ? 0 : (p > 15 ? 15 : p) & 0xF) << 8 & 0xF0;
        }

        public void inverted(boolean val) {
            this.scd_ = val ? (this.scd_ |= 0x100) : (this.scd_ &= 0xFFFFFEFF);
        }

        public void weak(boolean val) {
            this.scd_ = val ? (this.scd_ |= 0x200) : (this.scd_ &= 0xFFFFFDFF);
        }

        public void nooutput(boolean val) {
            this.scd_ = val ? (this.scd_ |= 0x400) : (this.scd_ &= 0xFFFFFBFF);
        }

        public void enabled_sides(long mask) {
            this.scd_ = this.scd_ & 0xFFFC0FFF | (int)(mask & 0x3F000L);
        }

        public void reset() {
            this.reset((IBlockAccess)this.func_145831_w());
        }

        public void reset(IBlockAccess world) {
            this.pulse_off_deadline_ = 0L;
            this.click_config_time_lastclicked_ = 0L;
            this.svd_ = 0;
            try {
                int current_scd = this.scd_;
                this.scd_ = (int)(((BlockSwitch)world.func_180495_p((BlockPos)this.func_174877_v()).func_177230_c()).config & 0x3FFFFL);
                if (current_scd != this.scd_) {
                    this.func_70296_d();
                }
            }
            catch (Exception e) {
                this.scd_ = 15;
            }
        }

        public int power(IBlockState state, boolean strong) {
            return this.nooutput() ? 0 : (strong && this.weak() ? 0 : (this.inverted() == ((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue() ? this.off_power() : this.on_power()));
        }

        public void reschedule_block_tick() {
            int t = this.on_time_remaining();
            if (t <= 0) {
                return;
            }
            Block block = this.func_145838_q();
            if (!this.field_145850_b.func_184145_b(this.field_174879_c, block)) {
                this.field_145850_b.func_175684_a(this.field_174879_c, block, t);
            }
        }

        public int on_time_remaining() {
            long dt = Math.max(0L, this.pulse_off_deadline_ - this.field_145850_b.func_82737_E());
            return dt > 200L ? 0 : (int)dt;
        }

        public void on_timer_reset() {
            this.on_timer_reset(0);
        }

        public void on_timer_reset(int preset_ticks) {
            this.pulse_off_deadline_ = this.field_145850_b.func_82737_E() + (long)(Math.min(preset_ticks, 200) > 0 ? preset_ticks : 0);
        }

        public void on_timer_extend() {
            int t = this.on_time_remaining();
            t = this.configured_on_time() >= 2 ? this.configured_on_time() : (t > 90 ? 200 : (t > 45 ? 100 : (t > 15 ? 50 : (t > 1 ? 30 : 20))));
            this.on_timer_reset(t);
        }

        public boolean activation_config(IBlockState state, @Nullable EntityPlayer player, double x, double y) {
            return false;
        }

        public boolean click_config(@Nullable BlockSwitch block, boolean needsDoubleClick) {
            if (block == null) {
                this.click_config_time_lastclicked_ = 0L;
                return false;
            }
            long t = System.currentTimeMillis();
            if (needsDoubleClick) {
                boolean dblclicked = t - this.click_config_time_lastclicked_ > 0L && t - this.click_config_time_lastclicked_ < (long)ModConfig.tweaks.config_left_click_timeout;
                long l = this.click_config_time_lastclicked_ = dblclicked ? 0L : t;
                if (!dblclicked) {
                    return false;
                }
            }
            boolean multiclicked = t - this.click_config_last_cycled_ > 0L && t - this.click_config_last_cycled_ < 3000L;
            this.click_config_last_cycled_ = t;
            if (!multiclicked) {
                return true;
            }
            if ((block.config & 0x300000L) == 0x300000L) {
                switch ((this.weak() ? 1 : 0) | (this.inverted() ? 2 : 0) | (this.nooutput() ? 4 : 0)) {
                    case 0: {
                        this.weak(true);
                        this.inverted(false);
                        this.nooutput(false);
                        break;
                    }
                    case 1: {
                        this.weak(false);
                        this.inverted(true);
                        this.nooutput(false);
                        break;
                    }
                    case 2: {
                        this.weak(true);
                        this.inverted(true);
                        this.nooutput(false);
                        break;
                    }
                    case 3: {
                        this.weak(false);
                        this.inverted(false);
                        this.nooutput(true);
                        break;
                    }
                    default: {
                        this.weak(false);
                        this.inverted(false);
                        this.nooutput(false);
                        break;
                    }
                }
            } else if ((block.config & 0x200000L) != 0L) {
                switch ((this.weak() ? 1 : 0) | (this.nooutput() ? 2 : 0)) {
                    case 0: {
                        this.weak(true);
                        this.inverted(false);
                        this.nooutput(false);
                        break;
                    }
                    case 1: {
                        this.weak(false);
                        this.inverted(false);
                        this.nooutput(true);
                        break;
                    }
                    default: {
                        this.weak(false);
                        this.inverted(false);
                        this.nooutput(false);
                        break;
                    }
                }
            } else if ((block.config & 0x100000L) != 0L) {
                switch ((this.inverted() ? 1 : 0) | (this.nooutput() ? 2 : 0)) {
                    case 0: {
                        this.weak(false);
                        this.inverted(true);
                        this.nooutput(false);
                        break;
                    }
                    case 1: {
                        this.weak(false);
                        this.inverted(false);
                        this.nooutput(true);
                        break;
                    }
                    default: {
                        this.weak(false);
                        this.inverted(false);
                        this.nooutput(false);
                    }
                }
            }
            if ((block.config & 0x200200L) == 512L && !this.weak()) {
                this.weak(true);
            }
            if (ModConfig.optouts.without_switch_nooutput || (block.config & 0x400000000000000L) != 0L) {
                this.nooutput(false);
            }
            this.func_70296_d();
            this.field_145850_b.func_175685_c(this.field_174879_c, (Block)block, false);
            for (EnumFacing f : EnumFacing.field_82609_l) {
                this.field_145850_b.func_175685_c(this.field_174879_c.func_177972_a(f), (Block)block, false);
            }
            return true;
        }

        public TextComponentTranslation configStatusTextComponentTranslation(BlockSwitch block) {
            TextComponentString separator = new TextComponentString(" | ");
            separator.func_150256_b().func_150238_a(TextFormatting.GRAY);
            TextComponentTranslation status = ModAuxiliaries.localizable("switchconfig.options", TextFormatting.RESET, new Object[0]);
            boolean statusset = false;
            if (!(this.on_power() >= 15 && this.off_power() <= 0 || block != null && (block.config & 0x40000FF00000000L) != 0L)) {
                statusset = true;
                status.func_150257_a((ITextComponent)ModAuxiliaries.localizable("switchconfig.options.output_power", TextFormatting.RED, this.on_power()));
            }
            if (this.nooutput()) {
                if (statusset) {
                    status.func_150257_a((ITextComponent)separator.func_150259_f());
                }
                statusset = true;
                status.func_150257_a((ITextComponent)ModAuxiliaries.localizable("switchconfig.options.no_output", TextFormatting.DARK_AQUA, new Object[0]));
            } else if (!this.inverted()) {
                if (statusset) {
                    status.func_150257_a((ITextComponent)separator.func_150259_f());
                }
                statusset = true;
                status.func_150257_a((ITextComponent)ModAuxiliaries.localizable("switchconfig.options." + (this.weak() ? "weak" : "strong"), TextFormatting.DARK_AQUA, new Object[0]));
            } else {
                if (statusset) {
                    status.func_150257_a((ITextComponent)separator.func_150259_f());
                }
                statusset = true;
                status.func_150257_a((ITextComponent)ModAuxiliaries.localizable("switchconfig.options." + (this.weak() ? "weakinverted" : "stronginverted"), TextFormatting.DARK_AQUA, new Object[0]));
            }
            if (this.configured_on_time() > 0) {
                if (statusset) {
                    status.func_150257_a((ITextComponent)separator.func_150259_f());
                }
                statusset = true;
                status.func_150257_a((ITextComponent)ModAuxiliaries.localizable("switchconfig.options.pulsetime", TextFormatting.GOLD, Double.toString((double)this.configured_on_time() / 20.0), Integer.toString(this.configured_on_time())));
            }
            return status;
        }

        public boolean has_links() {
            return this.links_ != null && !this.links_.isEmpty();
        }

        public static long linktime() {
            return System.currentTimeMillis();
        }

        public boolean check_link_request(ItemSwitchLinkPearl.SwitchLink link) {
            long t = TileEntitySwitch.linktime();
            if (this.field_145850_b.field_72995_K || this.last_link_request_ == t) {
                return false;
            }
            this.last_link_request_ = t;
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (state == null || !(state.func_177230_c() instanceof BlockSwitch)) {
                return false;
            }
            return (((BlockSwitch)state.func_177230_c()).config & 0x200000000000000L) != 0L;
        }

        SwitchLinkAssignmentResult assign_switchlink(World world, BlockPos sourcepos, ItemStack stack) {
            if (stack == null) {
                return SwitchLinkAssignmentResult.E_FAILED;
            }
            ItemSwitchLinkPearl.SwitchLink link = ItemSwitchLinkPearl.SwitchLink.fromItemStack(stack);
            if (world == null || !link.valid || !sourcepos.equals((Object)this.func_174877_v())) {
                return SwitchLinkAssignmentResult.E_FAILED;
            }
            IBlockState state = world.func_180495_p(sourcepos);
            if (state == null || !(state.func_177230_c() instanceof BlockSwitch)) {
                return SwitchLinkAssignmentResult.E_FAILED;
            }
            if (link.target_position.equals((Object)sourcepos)) {
                return SwitchLinkAssignmentResult.E_SELF_ASSIGN;
            }
            if ((((BlockSwitch)state.func_177230_c()).config & 0x100000000000000L) == 0L) {
                return SwitchLinkAssignmentResult.E_NOSOURCE;
            }
            if (link.isTooFar(sourcepos)) {
                return SwitchLinkAssignmentResult.E_TOO_FAR;
            }
            if (this.links_ == null) {
                this.links_ = new ArrayList();
            }
            for (ItemSwitchLinkPearl.SwitchLink lnk : this.links_) {
                if (!lnk.target_position.equals((Object)link.target_position)) continue;
                return SwitchLinkAssignmentResult.E_ALREADY_LINKED;
            }
            this.links_.add(link);
            this.func_70296_d();
            return SwitchLinkAssignmentResult.OK;
        }

        public ArrayList<ItemStack> unlink_all(boolean drop) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            if (this.field_145850_b.field_72995_K || this.links_ == null) {
                return stacks;
            }
            for (ItemSwitchLinkPearl.SwitchLink switchLink : this.links_) {
                stacks.add(switchLink.toSwitchLinkPearl());
            }
            this.links_.clear();
            if (drop) {
                for (ItemStack itemStack : stacks) {
                    this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), itemStack));
                }
            }
            return stacks;
        }

        public boolean activate_links(int req) {
            if (ModConfig.optouts.without_switch_linking) {
                return true;
            }
            this.last_link_request_ = TileEntitySwitch.linktime();
            if (this.links_ == null) {
                return true;
            }
            int n_fails = 0;
            block3: for (ItemSwitchLinkPearl.SwitchLink lnk : this.links_) {
                switch (lnk.request(req, this.field_145850_b, this.field_174879_c, null)) {
                    case OK: 
                    case NOT_MATCHED: {
                        continue block3;
                    }
                }
                ++n_fails;
            }
            return n_fails == 0;
        }

        static enum SwitchLinkAssignmentResult {
            OK,
            E_SELF_ASSIGN,
            E_ALREADY_LINKED,
            E_TOO_FAR,
            E_NOSOURCE,
            E_FAILED;

        }
    }
}

