/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges.detail;

import java.util.LinkedList;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModResources {
    @GameRegistry.ObjectHolder(value="rsgauges:alarm_siren_sound")
    public static final SoundEvent ALARM_SIREN_SOUND = SoundRegistry.createSoundEvent("alarm_siren_sound");

    public static final class BlockSoundEvents {
        public static final BlockSoundEvent DEFAULT_SWITCH_MUTE = new BlockSoundEvent(SoundEvents.field_187750_dc, 0.0f, 1.0f);
        public static final BlockSoundEvent DEFAULT_SWITCH_ACTIVATION = new BlockSoundEvent(SoundEvents.field_187750_dc, 0.3f, 0.92f);
        public static final BlockSoundEvent DEFAULT_SWITCH_DEACTIVATION = new BlockSoundEvent(SoundEvents.field_187750_dc, 0.3f, 0.82f);
        public static final BlockSoundEvent DEFAULT_SWITCH_CONFIGCLICK = new BlockSoundEvent(SoundEvents.field_187750_dc, 0.01f, 1.9f);
        public static final BlockSoundEvent SWITCHLINK_CANNOT_LINK_THAT = new BlockSoundEvent(SoundEvents.field_187532_aV, 0.2f, 2.5f);
        public static final BlockSoundEvent SWITCHLINK_LINK_TARGET_SELECTED = new BlockSoundEvent(SoundEvents.field_187534_aX, 0.2f, 2.0f);
        public static final BlockSoundEvent SWITCHLINK_LINK_SOURCE_SELECTED = new BlockSoundEvent(SoundEvents.field_187534_aX, 0.2f, 2.0f);
        public static final BlockSoundEvent SWITCHLINK_LINK_SOURCE_FAILED = SWITCHLINK_CANNOT_LINK_THAT;
        public static final BlockSoundEvent SWITCHLINK_LINK_PEAL_USE_SUCCESS = new BlockSoundEvent(SoundEvents.field_187529_aS, 0.1f, 4.0f);
        public static final BlockSoundEvent SWITCHLINK_LINK_PEAL_USE_FAILED = new BlockSoundEvent(SoundEvents.field_187531_aU, 0.1f, 2.0f);
    }

    public static final class BlockSoundEvent {
        final SoundEvent se_;
        final float volume_;
        final float pitch_;

        public BlockSoundEvent(SoundEvent se, float volume, float pitch) {
            this.se_ = se;
            this.volume_ = volume;
            this.pitch_ = pitch;
        }

        public BlockSoundEvent(SoundEvent se, float volume) {
            this(se, volume, 1.0f);
        }

        public BlockSoundEvent(SoundEvent se) {
            this(se, 1.0f, 1.0f);
        }

        public SoundEvent sound() {
            return this.se_;
        }

        public float volume() {
            return this.volume_;
        }

        public float pitch() {
            return this.pitch_;
        }

        public void play(World world, BlockPos pos) {
            world.func_184133_a(null, pos, this.se_, SoundCategory.BLOCKS, this.volume_, this.pitch_);
        }
    }

    @Mod.EventBusSubscriber(modid="rsgauges")
    public static final class SoundRegistry {
        private static LinkedList<SoundEvent> created_sounds_ = new LinkedList();

        public static SoundEvent createSoundEvent(String name) {
            ResourceLocation rl = new ResourceLocation("rsgauges", name);
            SoundEvent se = (SoundEvent)new SoundEvent(rl).setRegistryName(rl);
            created_sounds_.push(se);
            return se;
        }

        @SubscribeEvent
        public static void onRegistryEvent(RegistryEvent.Register<SoundEvent> event) {
            for (SoundEvent se : created_sounds_) {
                event.getRegistry().register((IForgeRegistryEntry)se);
            }
            created_sounds_.clear();
        }
    }
}

