/*
 * Decompiled with CFR 0.152.
 */
package codersafterdark.compatskills.common.compats.minecraft.drops;

import codersafterdark.compatskills.common.compats.minecraft.drops.ItemStackDropKey;
import codersafterdark.compatskills.utils.CompatSkillsConfig;
import codersafterdark.compatskills.utils.Utils;
import codersafterdark.reskillable.api.data.LockKey;
import codersafterdark.reskillable.api.data.PlayerData;
import codersafterdark.reskillable.api.data.PlayerDataHandler;
import codersafterdark.reskillable.api.data.RequirementHolder;
import codersafterdark.reskillable.base.LevelLockHandler;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class BlockDropsHandler {
    @SubscribeEvent
    public void onBlockDrops(BlockEvent.HarvestDropsEvent event) {
        if (event.isCanceled()) {
            return;
        }
        EntityPlayer player = event.getHarvester();
        if (Utils.skipPlayer(player)) {
            return;
        }
        PlayerData data = PlayerDataHandler.get((EntityPlayer)player);
        HashMap<RequirementHolder, Object> stackMap = new HashMap<RequirementHolder, Object>();
        for (Object stack : event.getDrops()) {
            RequirementHolder requirementHolder = LevelLockHandler.getLockByKey((LockKey)new ItemStackDropKey((ItemStack)stack));
            if (requirementHolder.equals(LevelLockHandler.EMPTY_LOCK)) continue;
            stackMap.put(requirementHolder, stack);
        }
        boolean errored = false;
        for (Map.Entry entry : stackMap.entrySet()) {
            RequirementHolder holder = (RequirementHolder)entry.getKey();
            if (data.matchStats(holder)) continue;
            errored = true;
            event.getDrops().remove(entry.getValue());
            if (!CompatSkillsConfig.Configs.Minecraft.BlockDropsError) continue;
            TextComponentTranslation error = new TextComponentTranslation("compatskills.error.drops", new Object[0]);
            player.func_146105_b(Utils.getError(holder, data, error), false);
        }
        if (!CompatSkillsConfig.Configs.Minecraft.BlockDropsError && errored) {
            TextComponentTranslation error = new TextComponentTranslation("compatskills.error.drops", new Object[0]);
            player.func_146105_b((ITextComponent)new TextComponentString(error.func_150261_e()), true);
        }
    }
}

