/*
 * Decompiled with CFR 0.152.
 */
package codersafterdark.compatskills.common.compats.reskillable.customcontent;

import codersafterdark.compatskills.common.compats.reskillable.ReskillableCompatHandler;
import codersafterdark.compatskills.common.compats.reskillable.customcontent.CrTSkill;
import codersafterdark.compatskills.utils.CheckMethods;
import codersafterdark.compatskills.utils.Utils;
import codersafterdark.reskillable.api.ReskillableRegistries;
import codersafterdark.reskillable.api.data.RequirementHolder;
import codersafterdark.reskillable.api.unlockable.Trait;
import codersafterdark.reskillable.api.unlockable.Unlockable;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.event.BlockHarvestDropsEvent;
import crafttweaker.api.event.EntityLivingDeathDropsEvent;
import crafttweaker.api.event.EntityLivingDeathEvent;
import crafttweaker.api.event.EntityLivingHurtEvent;
import crafttweaker.api.event.PlayerBreakSpeedEvent;
import crafttweaker.api.event.PlayerRightClickBlockEvent;
import crafttweaker.api.event.PlayerTickEvent;
import crafttweaker.api.formatting.IFormattedText;
import crafttweaker.mc1120.events.handling.MCBlockHarvestDropsEvent;
import crafttweaker.mc1120.events.handling.MCEnderTeleportEvent;
import crafttweaker.mc1120.events.handling.MCEntityLivingDeathDropsEvent;
import crafttweaker.mc1120.events.handling.MCEntityLivingDeathEvent;
import crafttweaker.mc1120.events.handling.MCEntityLivingHurtEvent;
import crafttweaker.mc1120.events.handling.MCPlayerBreakSpeedEvent;
import crafttweaker.mc1120.events.handling.MCPlayerRightClickBlockEvent;
import crafttweaker.mc1120.events.handling.MCPlayerTickEvent;
import crafttweaker.util.IEventHandler;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;
import stanhebben.zenscript.annotations.ZenProperty;
import stanhebben.zenscript.annotations.ZenSetter;

@ZenRegister
@ZenClass(value="mods.compatskills.TraitCreator")
public class CrTTrait
extends Trait {
    @ZenProperty
    public IEventHandler<BlockHarvestDropsEvent> onBlockDrops;
    @ZenProperty
    public IEventHandler<crafttweaker.api.event.EnderTeleportEvent> onEnderTeleport;
    @ZenProperty
    public IEventHandler<PlayerTickEvent> onPlayerTick;
    @ZenProperty
    public IEventHandler<PlayerBreakSpeedEvent> getBreakSpeed;
    @ZenProperty
    public IEventHandler<EntityLivingDeathDropsEvent> onMobDrops;
    @ZenProperty
    public IEventHandler<EntityLivingHurtEvent> onAttackMob;
    @ZenProperty
    public IEventHandler<EntityLivingHurtEvent> onHurt;
    @ZenProperty
    public IEventHandler<PlayerRightClickBlockEvent> onRightClickBlock;
    @ZenProperty
    public IEventHandler<EntityLivingDeathEvent> onKillMob;
    @ZenProperty
    public IFormattedText name;
    @ZenProperty
    public IFormattedText description;

    public CrTTrait(ResourceLocation name, int x, int y, ResourceLocation skillName, int cost, String ... requirements) {
        super(name, x, y, skillName, cost, requirements);
        ReskillableRegistries.UNLOCKABLES.register((IForgeRegistryEntry)this);
    }

    private static CrTTrait createTrait(ResourceLocation name, int x, int y, ResourceLocation skillName, int cost, String ... requirements) {
        Unlockable value;
        if (requirements == null) {
            requirements = new String[]{};
        }
        CrTTrait customTrait = new CrTTrait(name, x, y, skillName, cost, requirements);
        if (ReskillableRegistries.UNLOCKABLES.containsKey(name) && (value = (Unlockable)ReskillableRegistries.UNLOCKABLES.getValue(name)) instanceof CrTTrait) {
            String updated = "";
            if (customTrait.getX() != x) {
                customTrait.unlockableConfig.setX(x);
                updated = updated + " - Updated X Pos: " + x;
            }
            if (customTrait.getY() != y) {
                customTrait.unlockableConfig.setY(y);
                updated = updated + " - Updated Y Pos: " + y;
            }
            if (!skillName.equals((Object)customTrait.getParentSkill().getRegistryName())) {
                customTrait.setParentSkill(skillName);
                updated = updated + " - Updated Parent Skill: " + skillName;
            }
            if (customTrait.getCost() != cost) {
                customTrait.unlockableConfig.setCost(cost);
                updated = updated + " - Updated Cost: " + cost;
            }
            String reqs = Utils.formatRequirements(requirements);
            RequirementHolder holder = RequirementHolder.fromStringList((String[])requirements);
            if (!holder.equals(customTrait.getRequirements())) {
                customTrait.unlockableConfig.setRequirementHolder(holder);
                updated = updated + " - Updated Requirements: " + reqs;
            }
            if (!updated.isEmpty()) {
                CraftTweakerAPI.logInfo((String)("Loaded Trait: " + name + updated));
            } else {
                CraftTweakerAPI.logInfo((String)("Created or Loaded Trait: " + name + " - With Pos: " + x + ", " + y + " -  With Cost: " + cost + " - Requirements: " + reqs));
            }
        }
        return customTrait;
    }

    @ZenMethod
    public static CrTTrait createTrait(String traitName, int x, int y, String skillLocation, int cost, String ... requirements) {
        if (ReskillableCompatHandler.ENABLED & CheckMethods.checkString(traitName) & CheckMethods.checkIntX(x) & CheckMethods.checkIntY(y) & CheckMethods.checkParentSkillsString(skillLocation) & CheckMethods.checkInt(cost) & CheckMethods.checkOptionalRequirements(requirements)) {
            return CrTTrait.createTrait(new ResourceLocation("compatskills", traitName), x, y, new ResourceLocation(skillLocation), cost, requirements);
        }
        return null;
    }

    @ZenMethod
    public static CrTTrait createTrait(String traitName, int x, int y, CrTSkill parentSkill, int cost, String ... requirements) {
        if (ReskillableCompatHandler.ENABLED & CheckMethods.checkString(traitName) & CheckMethods.checkIntX(x) & CheckMethods.checkIntY(y) & CheckMethods.checkCrTSkillParent(parentSkill) & CheckMethods.checkInt(cost) & CheckMethods.checkOptionalRequirements(requirements)) {
            return CrTTrait.createTrait(new ResourceLocation("compatskills", traitName), x, y, parentSkill.getRegistryName(), cost, requirements);
        }
        return null;
    }

    @ZenMethod
    public static CrTTrait createNewTrait(String traitLocation, int x, int y, String skillLocation, int cost, String ... requirements) {
        if (ReskillableCompatHandler.ENABLED & CheckMethods.checkString(traitLocation) & CheckMethods.checkIntX(x) & CheckMethods.checkIntY(y) & CheckMethods.checkParentSkillsString(skillLocation) & CheckMethods.checkInt(cost) & CheckMethods.checkOptionalRequirements(requirements)) {
            return CrTTrait.createTrait(new ResourceLocation(traitLocation), x, y, new ResourceLocation(skillLocation), cost, requirements);
        }
        return null;
    }

    @ZenMethod
    public static CrTTrait createNewTrait(String traitLocation, int x, int y, CrTSkill parentSkill, int cost, String ... requirements) {
        if (ReskillableCompatHandler.ENABLED & CheckMethods.checkString(traitLocation) & CheckMethods.checkIntX(x) & CheckMethods.checkIntY(y) & CheckMethods.checkCrTSkillParent(parentSkill) & CheckMethods.checkInt(cost) & CheckMethods.checkOptionalRequirements(requirements)) {
            return CrTTrait.createTrait(new ResourceLocation(traitLocation), x, y, parentSkill.getRegistryName(), cost, requirements);
        }
        return null;
    }

    @ZenGetter(value="enabled")
    @ZenMethod
    public boolean getEnabled() {
        return this.isEnabled();
    }

    @ZenSetter(value="enabled")
    @ZenMethod
    public void setEnabled(boolean enabled) {
        this.unlockableConfig.setEnabled(enabled);
    }

    @ZenGetter(value="icon")
    @ZenMethod
    public String retrieveIcon() {
        return this.getIcon().toString();
    }

    @ZenSetter(value="icon")
    @ZenMethod
    public void changeIcon(String resourceLocation) {
        if (CheckMethods.checkResourceLocation(resourceLocation)) {
            this.setIcon(new ResourceLocation(resourceLocation));
        }
    }

    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (this.onPlayerTick != null) {
            this.onPlayerTick.handle((Object)new MCPlayerTickEvent(event));
        }
        super.onPlayerTick(event);
    }

    public void onBlockDrops(BlockEvent.HarvestDropsEvent event) {
        if (this.onBlockDrops != null) {
            this.onBlockDrops.handle((Object)new MCBlockHarvestDropsEvent(event));
        }
        super.onBlockDrops(event);
    }

    public void getBreakSpeed(PlayerEvent.BreakSpeed event) {
        if (this.getBreakSpeed != null) {
            this.getBreakSpeed.handle((Object)new MCPlayerBreakSpeedEvent(event));
        }
        super.getBreakSpeed(event);
    }

    public void onMobDrops(LivingDropsEvent event) {
        if (this.onMobDrops != null) {
            this.onMobDrops.handle((Object)new MCEntityLivingDeathDropsEvent(event));
        }
        super.onMobDrops(event);
    }

    public void onAttackMob(LivingHurtEvent event) {
        if (this.onAttackMob != null) {
            this.onAttackMob.handle((Object)new MCEntityLivingHurtEvent(event));
        }
        super.onAttackMob(event);
    }

    public void onHurt(LivingHurtEvent event) {
        if (this.onHurt != null) {
            this.onHurt.handle((Object)new MCEntityLivingHurtEvent(event));
        }
        super.onHurt(event);
    }

    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (this.onRightClickBlock != null) {
            this.onRightClickBlock.handle((Object)new MCPlayerRightClickBlockEvent(event));
        }
        super.onRightClickBlock(event);
    }

    public void onEnderTeleport(EnderTeleportEvent event) {
        if (this.onEnderTeleport != null) {
            this.onEnderTeleport.handle((Object)new MCEnderTeleportEvent(event));
        }
        super.onEnderTeleport(event);
    }

    public void onKillMob(LivingDeathEvent event) {
        if (this.onKillMob != null) {
            this.onKillMob.handle((Object)new MCEntityLivingDeathEvent(event));
        }
        super.onKillMob(event);
    }

    public String getName() {
        return this.name == null ? super.getName() : this.name.getText();
    }

    public String getDescription() {
        return this.description == null ? super.getDescription() : this.description.getText();
    }
}

