/*
 * Decompiled with CFR 0.152.
 */
package codersafterdark.compatskills.common.compats.reskillable.levellocking;

import codersafterdark.compatskills.common.compats.reskillable.levellocking.SkillLock;
import codersafterdark.compatskills.utils.Utils;
import codersafterdark.reskillable.api.data.LockKey;
import codersafterdark.reskillable.api.data.PlayerData;
import codersafterdark.reskillable.api.data.PlayerDataHandler;
import codersafterdark.reskillable.api.data.RequirementHolder;
import codersafterdark.reskillable.api.event.LevelUpEvent;
import codersafterdark.reskillable.api.skill.Skill;
import codersafterdark.reskillable.base.LevelLockHandler;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class SkillLockHandler {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public void levelUpEvent(LevelUpEvent.Pre event) {
        int oldLevel;
        EntityPlayer player = event.getEntityPlayer();
        if (Utils.skipPlayer(player)) {
            return;
        }
        int level = event.getLevel();
        if (level < (oldLevel = event.getOldLevel()) || level > oldLevel + 1) {
            return;
        }
        PlayerData data = PlayerDataHandler.get((EntityPlayer)player);
        Skill skill = event.getSkill();
        RequirementHolder requirementHolder = LevelLockHandler.getLockByKey((LockKey)new SkillLock(skill, level));
        if (!requirementHolder.equals(LevelLockHandler.EMPTY_LOCK) && !data.matchStats(requirementHolder)) {
            event.setCanceled(true);
            TextComponentTranslation error = new TextComponentTranslation("compatskills.error.reskillable.level_lock", new Object[0]);
            TextComponentTranslation error2 = new TextComponentTranslation("compatskills.error.reskillable.level_lock_2", new Object[0]);
            TextComponentTranslation error3 = new TextComponentTranslation("compatskills.misc.requirements", new Object[0]);
            String reqString = requirementHolder.getRequirements().stream().map(requirement -> "\n " + requirement.getToolTip(data) + ' ').collect(Collectors.joining());
            TextComponentString textComponent = new TextComponentString(error.func_150261_e() + '\n' + error2.func_150261_e() + '\n' + error3.func_150261_e() + ' ' + reqString);
            player.func_146105_b((ITextComponent)textComponent, false);
        }
    }
}

