/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.packet;

import com.creativemd.creativecore.common.utils.stack.InfoStack;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.EnumConnectionState;
import net.minecraft.network.EnumPacketDirection;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class CreativeCorePacket {
    public static final HashMap<String, Class<? extends CreativeCorePacket>> packets = new HashMap();
    public static int maxPacketSize = 1047576;

    public static void registerPacket(Class<? extends CreativeCorePacket> PacketClass, String id) {
        packets.put(id, PacketClass);
    }

    public static Class<? extends CreativeCorePacket> getClassByID(String id) {
        return packets.get(id);
    }

    public static String getIDByClass(Class<? extends CreativeCorePacket> packet) {
        for (Map.Entry<String, Class<? extends CreativeCorePacket>> entry : packets.entrySet()) {
            if (entry.getValue() != packet) continue;
            return entry.getKey();
        }
        return "";
    }

    public static String getIDByClass(CreativeCorePacket packet) {
        return CreativeCorePacket.getIDByClass(packet.getClass());
    }

    public abstract void writeBytes(ByteBuf var1);

    public abstract void readBytes(ByteBuf var1);

    @SideOnly(value=Side.CLIENT)
    public abstract void executeClient(EntityPlayer var1);

    public abstract void executeServer(EntityPlayer var1);

    public static void writeString(ByteBuf buf, String input) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)input);
    }

    public static String readString(ByteBuf buf) {
        return ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public static void writePos(ByteBuf buf, BlockPos pos) {
        buf.writeInt(pos.func_177958_n());
        buf.writeInt(pos.func_177956_o());
        buf.writeInt(pos.func_177952_p());
    }

    public static BlockPos readPos(ByteBuf buf) {
        return new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
    }

    public static void writeState(ByteBuf buf, IBlockState state) {
        buf.writeInt(Block.func_176210_f((IBlockState)state));
    }

    public static IBlockState readState(ByteBuf buf) {
        return Block.func_176220_d((int)buf.readInt());
    }

    public static void writeNBT(ByteBuf buf, NBTTagCompound nbt) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)nbt);
    }

    public static NBTTagCompound readNBT(ByteBuf buf) {
        return ByteBufUtils.readTag((ByteBuf)buf);
    }

    public static void writeVec3d(Vec3d vec, ByteBuf buf) {
        buf.writeDouble(vec.field_72450_a);
        buf.writeDouble(vec.field_72448_b);
        buf.writeDouble(vec.field_72449_c);
    }

    public static Vec3d readVec3d(ByteBuf buf) {
        double x = buf.readDouble();
        double y = buf.readDouble();
        double z = buf.readDouble();
        return new Vec3d(x, y, z);
    }

    public static void writeInfoStack(ByteBuf buf, InfoStack info) {
        CreativeCorePacket.writeNBT(buf, info.writeToNBT(new NBTTagCompound()));
    }

    public static InfoStack readInfoStack(ByteBuf buf) {
        return InfoStack.parseNBT(CreativeCorePacket.readNBT(buf));
    }

    public void writeInfoStacks(ByteBuf buf, ArrayList<InfoStack> infos) {
        buf.writeInt(infos.size());
        for (int i = 0; i < infos.size(); ++i) {
            CreativeCorePacket.writeInfoStack(buf, infos.get(i));
        }
    }

    public ArrayList<InfoStack> readInfoStacks(ByteBuf buf) {
        int count = buf.readInt();
        ArrayList<InfoStack> infos = new ArrayList<InfoStack>();
        for (int i = 0; i < count; ++i) {
            InfoStack info = CreativeCorePacket.readInfoStack(buf);
            if (info == null) continue;
            infos.add(info);
        }
        return infos;
    }

    public static void writeItemStack(ByteBuf buf, ItemStack stack) {
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)stack);
    }

    public static ItemStack readItemStack(ByteBuf buf) {
        return ByteBufUtils.readItemStack((ByteBuf)buf);
    }

    public static EnumFacing readFacing(ByteBuf buf) {
        return EnumFacing.func_82600_a((int)buf.readInt());
    }

    public static void writeFacing(ByteBuf buf, EnumFacing facing) {
        buf.writeInt(facing.func_176745_a());
    }

    public static void writePacket(ByteBuf buf, Packet<?> packet) {
        EnumConnectionState state = EnumConnectionState.func_150752_a(packet);
        buf.writeInt(state.func_150759_c());
        try {
            buf.writeInt(state.func_179246_a(EnumPacketDirection.CLIENTBOUND, packet).intValue());
            packet.func_148840_b(new PacketBuffer(buf));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Packet<?> readPacket(ByteBuf buf) {
        Packet packet;
        EnumConnectionState state = EnumConnectionState.func_150760_a((int)buf.readInt());
        try {
            packet = state.func_179244_a(EnumPacketDirection.CLIENTBOUND, buf.readInt());
            packet.func_148837_a(new PacketBuffer(buf));
        }
        catch (IOException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    public static void openContainerOnServer(EntityPlayerMP entityPlayerMP, Container container) {
        entityPlayerMP.func_71117_bO();
        entityPlayerMP.func_71128_l();
        int windowId = entityPlayerMP.field_71139_cq;
        entityPlayerMP.field_71070_bA = container;
        entityPlayerMP.field_71070_bA.field_75152_c = windowId;
        entityPlayerMP.field_71070_bA.func_75132_a((IContainerListener)entityPlayerMP);
    }
}

