/*
 * Decompiled with CFR 0.152.
 */
package rustic.common.blocks;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import rustic.client.renderer.CabinetRenderer;
import rustic.common.blocks.BlockRotatable;
import rustic.common.tileentity.TileEntityCabinet;
import rustic.core.Rustic;

public class BlockCabinet
extends BlockRotatable
implements ITileEntityProvider {
    public static final PropertyBool MIRROR = PropertyBool.func_177716_a((String)"mirror");
    public static final PropertyBool TOP = PropertyBool.func_177716_a((String)"top");
    public static final PropertyBool BOTTOM = PropertyBool.func_177716_a((String)"bottom");
    public static final int GUI_ID = 3;

    public BlockCabinet() {
        super(Material.field_151575_d, "cabinet");
        this.func_149711_c(2.5f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)MIRROR, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)TOP, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BOTTOM, (Comparable)Boolean.valueOf(false)));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        ItemStack material;
        NBTTagCompound nbttagcompound;
        super.func_190948_a(stack, player, tooltip, advanced);
        if (stack.func_77942_o() && (nbttagcompound = stack.func_77978_p()).func_150297_b("material", 10) && !(material = new ItemStack(nbttagcompound.func_74775_l("material"))).func_190926_b()) {
            tooltip.add(material.func_82833_r());
        }
    }

    public boolean func_189539_a(IBlockState state, World worldIn, BlockPos pos, int id, int param) {
        super.func_189539_a(state, worldIn, pos, id, param);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity == null ? false : tileentity.func_145842_c(id, param);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof TileEntityCabinet)) {
            return false;
        }
        if (facing == state.func_177229_b((IProperty)FACING)) {
            player.openGui((Object)Rustic.instance, 3, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            return true;
        }
        return false;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileEntityCabinet) {
            ((TileEntityCabinet)tileentity).breakBlock(worldIn, pos, state);
        }
        worldIn.func_175713_t(pos);
        if (worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof BlockCabinet && ((Boolean)worldIn.func_180495_p(pos.func_177984_a()).func_177229_b((IProperty)TOP)).booleanValue()) {
            worldIn.func_175656_a(pos.func_177984_a(), worldIn.func_180495_p(pos.func_177984_a()).func_177226_a((IProperty)TOP, (Comparable)Boolean.valueOf(false)));
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        return items;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityCabinet();
    }

    @Override
    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        EnumFacing f = placer.func_174811_aO().func_176734_d();
        boolean m = false;
        boolean t = false;
        m = f.equals((Object)EnumFacing.NORTH) ? (double)hitX >= 0.5 : (f.equals((Object)EnumFacing.SOUTH) ? (double)hitX < 0.5 : (f.equals((Object)EnumFacing.EAST) ? (double)hitZ >= 0.5 : (double)hitZ < 0.5));
        boolean bl = t = worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BlockCabinet && (Boolean)worldIn.func_180495_p(pos.func_177977_b()).func_177229_b((IProperty)TOP) == false && (Boolean)worldIn.func_180495_p(pos.func_177977_b()).func_177229_b((IProperty)MIRROR) == m && ((EnumFacing)worldIn.func_180495_p(pos.func_177977_b()).func_177229_b((IProperty)FACING)).equals((Object)f);
        if (t && worldIn.func_175625_s(pos.func_177977_b()) instanceof TileEntityCabinet) {
            ((TileEntityCabinet)worldIn.func_175625_s((BlockPos)pos.func_177977_b())).doubleCabinetHandler = null;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)f).func_177226_a((IProperty)MIRROR, (Comparable)Boolean.valueOf(m)).func_177226_a((IProperty)TOP, (Comparable)Boolean.valueOf(t));
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tileentity;
        if (stack.func_77942_o() && (tileentity = worldIn.func_175625_s(pos)) instanceof TileEntityCabinet) {
            NBTTagCompound tag;
            TileEntityCabinet te = (TileEntityCabinet)tileentity;
            if (stack.func_82837_s()) {
                te.func_190575_a(stack.func_82833_r());
            }
            if ((tag = stack.func_77978_p()).func_74764_b("material")) {
                ItemStack material;
                te.material = material = new ItemStack(tag.func_74775_l("material"));
            }
            te.func_70296_d();
        }
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        IBlockState state = this.func_176223_P().func_177226_a((IProperty)MIRROR, (Comparable)Boolean.valueOf((meta & 4) > 0));
        state = state.func_177226_a((IProperty)TOP, (Comparable)Boolean.valueOf((meta & 8) > 0));
        return state.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)(5 - (meta & 3))));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        int meta = 0;
        if (((Boolean)state.func_177229_b((IProperty)TOP)).booleanValue()) {
            meta |= 8;
        }
        if (((Boolean)state.func_177229_b((IProperty)MIRROR)).booleanValue()) {
            meta |= 4;
        }
        return meta |= 5 - ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        state = state.func_177226_a((IProperty)BOTTOM, (Comparable)Boolean.valueOf((Boolean)state.func_177229_b((IProperty)TOP) == false && worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof BlockCabinet && (Boolean)worldIn.func_180495_p(pos.func_177984_a()).func_177229_b((IProperty)TOP) != false));
        return state;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, MIRROR, TOP, BOTTOM});
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityCabinet.class, (TileEntitySpecialRenderer)new CabinetRenderer());
        Item.func_150898_a((Block)this).setTileEntityItemStackRenderer((TileEntityItemStackRenderer)new CabinetRenderer.CabinetTEISR());
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing side) {
        return side == state.func_177229_b((IProperty)FACING) ? BlockFaceShape.UNDEFINED : BlockFaceShape.SOLID;
    }
}

