/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.items;

import com.agricraft.agricore.core.AgriCore;
import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.reference.AgriNuggetType;
import com.infinityraider.agricraft.utility.OreDictUtil;
import com.infinityraider.infinitylib.item.IAutoRenderedItem;
import com.infinityraider.infinitylib.item.ItemBase;
import com.infinityraider.infinitylib.utility.IRecipeRegisterer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemNugget
extends ItemBase
implements IAutoRenderedItem,
IRecipeRegisterer {
    public ItemNugget() {
        super("agri_nugget");
        this.func_77637_a(CreativeTabs.field_78035_l);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> varients) {
        if (tab == this.func_77640_w() || tab == CreativeTabs.field_78027_g) {
            for (AgriNuggetType type : AgriNuggetType.values()) {
                ItemStack stack = new ItemStack((Item)this, 1, type.ordinal());
                varients.add((Object)stack);
            }
        }
    }

    public boolean func_77614_k() {
        return true;
    }

    public String func_77667_c(ItemStack stack) {
        return AgriNuggetType.getNugget(stack.func_77960_j()).getUnlocalizedName();
    }

    public String getModelId(ItemStack stack) {
        return AgriNuggetType.getNugget((int)stack.func_77960_j()).nugget;
    }

    public String getBaseTexture(ItemStack stack) {
        return AgriNuggetType.getNugget((int)stack.func_77960_j()).texture;
    }

    public List<ResourceLocation> getAllTextures() {
        ArrayList<ResourceLocation> textures = new ArrayList<ResourceLocation>(AgriNuggetType.values().length);
        for (AgriNuggetType type : AgriNuggetType.values()) {
            textures.add(new ResourceLocation(type.texture));
        }
        return textures;
    }

    public void registerRecipes(IForgeRegistry<IRecipe> registry) {
        for (AgriNuggetType type : AgriNuggetType.values()) {
            AgriCore.getLogger("agricraft").info("Registering in Ore Dictionary: {0}", type.nugget);
            ItemStack oneNugget = new ItemStack((Item)this, 1, type.ordinal());
            OreDictionary.registerOre((String)type.nugget, (ItemStack)oneNugget);
            ItemStack ingot = OreDictUtil.getFirstOre(type.ingot).orElse(ItemStack.field_190927_a);
            if (ingot.func_190926_b()) continue;
            AgriCore.getLogger("agricraft").info("Adding a recipe to convert nine {0} into one {1}", type.nugget, type.ingot);
            ResourceLocation group = new ResourceLocation(AgriCraft.instance.getModId(), "combine_nugget");
            ResourceLocation name = new ResourceLocation(AgriCraft.instance.getModId(), "combine_nugget_" + type.name().toLowerCase());
            ShapedOreRecipe recipe = new ShapedOreRecipe(group, ingot, new Object[]{"nnn", "nnn", "nnn", Character.valueOf('n'), type.nugget});
            recipe.setRegistryName(name);
            AgriCore.getLogger("agricraft").info("Registering nugget recipe: {0}!", recipe.getRegistryName());
            registry.register((IForgeRegistryEntry)recipe);
        }
    }
}

