/*
 * Decompiled with CFR 0.152.
 */
package com.sb205.missing_pieces;

import com.sb205.missing_pieces.Config.MpConfiguration;
import com.sb205.missing_pieces.MpItems.ItemSpindle;
import com.sb205.missing_pieces.Utilities.BlockInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;

public class Items {
    public static ItemSpindle item_spindle;
    public static ItemSpindle item_flat_spindle;
    public static ItemSpindle item_tall_spindle;
    public static ItemSpindle item_bent_spindle;
    private static IForgeRegistry<Item> itemRegistry;

    public static void preInitCommon() {
        itemRegistry = ForgeRegistries.ITEMS;
        item_spindle = Items.createSpindle("spindle", 1, MpConfiguration.BlockEnable[MpConfiguration.ConfigInfo.MISC_SPINDLE.ordinal()]);
        item_flat_spindle = Items.createSpindle("flat_spindle", 2, MpConfiguration.BlockEnable[MpConfiguration.ConfigInfo.MISC_FLAT_SPINDLE.ordinal()]);
        item_tall_spindle = Items.createSpindle("tall_spindle", 3, MpConfiguration.BlockEnable[MpConfiguration.ConfigInfo.MISC_TALL_SPINDLE.ordinal()]);
        item_bent_spindle = Items.createSpindle("bent_spindle", 4, MpConfiguration.BlockEnable[MpConfiguration.ConfigInfo.MISC_BENT_SPINDLE.ordinal()]);
    }

    public static void initClientOnly() {
        Items.registerItem(item_spindle, MpConfiguration.BlockEnable[MpConfiguration.ConfigInfo.MISC_SPINDLE.ordinal()]);
        Items.registerItem(item_flat_spindle, MpConfiguration.BlockEnable[MpConfiguration.ConfigInfo.MISC_FLAT_SPINDLE.ordinal()]);
        Items.registerItem(item_tall_spindle, MpConfiguration.BlockEnable[MpConfiguration.ConfigInfo.MISC_TALL_SPINDLE.ordinal()]);
        Items.registerItem(item_bent_spindle, MpConfiguration.BlockEnable[MpConfiguration.ConfigInfo.MISC_BENT_SPINDLE.ordinal()]);
    }

    public static ItemSpindle createSpindle(String name, int type, Boolean enabled) {
        ItemSpindle spindle = null;
        if (enabled.booleanValue()) {
            spindle = (ItemSpindle)new ItemSpindle().func_77655_b(name);
            ResourceLocation resource = new ResourceLocation("missing_pieces:" + name);
            itemRegistry.register(spindle.setRegistryName(name));
            OreDictionary.registerOre((String)"MaterialSpindle", (Item)spindle);
            switch (type) {
                default: {
                    GameRegistry.addShapedRecipe((ResourceLocation)resource, (ResourceLocation)new ResourceLocation("missing_pieces:spindle"), (ItemStack)new ItemStack((Item)spindle, 4), (Object[])new Object[]{"A", "B", "A", Character.valueOf('A'), Blocks.field_150344_f, Character.valueOf('B'), net.minecraft.init.Items.field_151055_y});
                    GameRegistry.addShapedRecipe((ResourceLocation)resource, (ResourceLocation)new ResourceLocation("missing_pieces:spindle"), (ItemStack)new ItemStack((Item)spindle, 4), (Object[])new Object[]{"A", "B", "A", Character.valueOf('A'), "plankWood", Character.valueOf('B'), "stickWood"});
                    break;
                }
                case 2: {
                    GameRegistry.addShapedRecipe((ResourceLocation)resource, (ResourceLocation)new ResourceLocation("missing_pieces:spindle"), (ItemStack)new ItemStack((Item)spindle, 4), (Object[])new Object[]{"   ", "PSP", "   ", Character.valueOf('S'), BlockInfo.blockType2Stack(BlockInfo.BlockType.BT_ITEM_SPINDLE), Character.valueOf('P'), Blocks.field_150344_f});
                    GameRegistry.addShapedRecipe((ResourceLocation)resource, (ResourceLocation)new ResourceLocation("missing_pieces:spindle"), (ItemStack)new ItemStack((Item)spindle, 4), (Object[])new Object[]{"   ", "PSP", "   ", Character.valueOf('S'), BlockInfo.blockType2Stack(BlockInfo.BlockType.BT_ITEM_SPINDLE), Character.valueOf('P'), "plankWood"});
                    break;
                }
                case 3: {
                    GameRegistry.addShapedRecipe((ResourceLocation)resource, (ResourceLocation)new ResourceLocation("missing_pieces:spindle"), (ItemStack)new ItemStack((Item)spindle, 3), (Object[])new Object[]{"S", "S", "S", Character.valueOf('S'), BlockInfo.blockType2Stack(BlockInfo.BlockType.BT_ITEM_SPINDLE)});
                    break;
                }
                case 4: {
                    GameRegistry.addShapedRecipe((ResourceLocation)resource, (ResourceLocation)new ResourceLocation("missing_pieces:spindle"), (ItemStack)new ItemStack((Item)spindle, 3), (Object[])new Object[]{"S  ", " S ", " S ", Character.valueOf('S'), BlockInfo.blockType2Stack(BlockInfo.BlockType.BT_ITEM_SPINDLE)});
                }
            }
        }
        return spindle;
    }

    public static void registerItem(Item item, Boolean enabled) {
        boolean DEFAULT_ITEM_SUBTYPE = false;
        if (enabled.booleanValue()) {
            String name = item.func_77658_a().substring(5);
            ModelResourceLocation itemModelResourceLocation = new ModelResourceLocation("missing_pieces:" + name, "inventory");
            Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(item, 0, itemModelResourceLocation);
        }
    }
}

