/*
 * Decompiled with CFR 0.152.
 */
package com.sb205.missing_pieces.MpBlocks;

import com.google.common.base.Predicate;
import com.sb205.missing_pieces.MpBlocks.EnumChairTypes;
import com.sb205.missing_pieces.MpBlocks.MpBlock;
import com.sb205.missing_pieces.Utilities.MountableUtil;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockChair
extends MpBlock {
    public static final PropertyDirection PROPERTYFACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyEnum CHAIR_TYPE = PropertyEnum.func_177709_a((String)"type", EnumChairTypes.class);

    public BlockChair(Material mType, EnumChairTypes chairType) {
        super(mType, Float.valueOf(0.5f), "axe", 1);
        this.func_149647_a(CreativeTabs.field_78031_c);
        this.func_149711_c(0.5f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)CHAIR_TYPE, (Comparable)((Object)chairType)));
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = EnumFacing.func_176731_b((int)meta);
        EnumChairTypes chairType = EnumChairTypes.getType(meta);
        return this.func_176223_P().func_177226_a((IProperty)PROPERTYFACING, (Comparable)facing).func_177226_a((IProperty)CHAIR_TYPE, (Comparable)((Object)chairType));
    }

    public int func_176201_c(IBlockState state) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)PROPERTYFACING);
        EnumChairTypes chairType = (EnumChairTypes)((Object)state.func_177229_b((IProperty)CHAIR_TYPE));
        int facingbits = facing.func_176736_b() + chairType.getMeta();
        return facingbits;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing blockFaceClickedOn, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        EnumFacing enumfacing = placer == null ? EnumFacing.NORTH : EnumFacing.func_176733_a((double)placer.field_70177_z);
        EnumChairTypes enumtype = EnumChairTypes.getType(meta);
        return this.func_176223_P().func_177226_a((IProperty)PROPERTYFACING, (Comparable)enumfacing).func_177226_a((IProperty)CHAIR_TYPE, (Comparable)((Object)enumtype));
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing heldItem, float side, float hitX, float hitY) {
        double height = 0.4375;
        EnumChairTypes chairType = (EnumChairTypes)((Object)state.func_177229_b((IProperty)CHAIR_TYPE));
        switch (chairType) {
            case STRAIGHT: {
                height = 0.4375;
                break;
            }
            case TALL: {
                height = 0.625;
                break;
            }
            case ADIRONDACK: {
                height = 0.375;
                break;
            }
            default: {
                height = 0.4375;
            }
        }
        return MountableUtil.MountBlock(worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), playerIn, height);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{PROPERTYFACING, CHAIR_TYPE});
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState blockState, World worldIn, BlockPos pos) {
        return this.getAxisAlignedBBFromFacing(pos);
    }

    private AxisAlignedBB getAxisAlignedBBFromFacing(BlockPos pos) {
        double minZ = 0.1875;
        double minX = 0.1875;
        double maxZ = 0.8125;
        double maxX = 0.8125;
        double minY = 0.0;
        double maxY = 1.25;
        return new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> list) {
        EnumChairTypes[] allTypes;
        for (EnumChairTypes type : allTypes = EnumChairTypes.values()) {
            if (!type.getEnabled().booleanValue()) continue;
            list.add((Object)new ItemStack((Block)this, 1, type.getMeta()));
        }
    }

    public String func_149739_a() {
        IBlockState state = this.func_176223_P();
        EnumChairTypes chairType = (EnumChairTypes)((Object)state.func_177229_b((IProperty)CHAIR_TYPE));
        if (chairType == EnumChairTypes.SPINDLE) {
            return super.func_149739_a();
        }
        return super.func_149739_a() + "_" + chairType.func_176610_l();
    }
}

