/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.gottschcore.block;

import com.someguyssoftware.gottschcore.block.ModBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;

public class ModBlockBuilder {
    private String modID;
    private String name;
    private Material material;
    private MapColor mapColor;
    private Float hardness;
    private String toolClass;
    private Integer toolLevel;
    private Float resistance;
    private SoundType soundType;
    private Boolean normalCube = true;
    private CreativeTabs tab;

    public ModBlock build() {
        ModBlock block = new ModBlock(this.modID, this.name, this.material, this.mapColor);
        if (this.toolClass != null && !this.toolClass.equals("") && this.toolLevel != null) {
            block.setHarvestLevel(this.toolClass, this.toolLevel);
        }
        if (this.hardness != null) {
            block.func_149711_c(this.hardness.floatValue());
        }
        if (this.resistance != null) {
            block.func_149752_b(this.resistance.floatValue());
        }
        if (this.soundType != null) {
            block.setSoundType(this.soundType);
        }
        block.setNormalCube(this.normalCube);
        block.func_149647_a(this.tab);
        return block;
    }

    public void clear() {
        this.withModID(null).withName(null).withMaterial(null).withMapColor(null).withHardness(null).withHarvestLevel(null, null).withResistance(null).withSoundType(null).withNormalCube(true);
    }

    public String getModID() {
        return this.modID;
    }

    public ModBlockBuilder withModID(String modID) {
        this.modID = modID;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public ModBlockBuilder withName(String name) {
        this.name = name;
        return this;
    }

    public Material getMaterial() {
        return this.material;
    }

    public ModBlockBuilder withMaterial(Material material) {
        this.material = material;
        return this;
    }

    public MapColor getMapColor() {
        return this.mapColor;
    }

    public ModBlockBuilder withMapColor(MapColor mapColor) {
        this.mapColor = mapColor;
        return this;
    }

    public ModBlockBuilder withHarvestLevel(String toolClass, Integer toolLevel) {
        this.toolClass = toolClass;
        this.toolLevel = toolLevel;
        return this;
    }

    public Boolean isNormalCube() {
        return this.normalCube;
    }

    public ModBlockBuilder withNormalCube(Boolean normalCube) {
        this.normalCube = normalCube;
        return this;
    }

    public Float getHardness() {
        return this.hardness;
    }

    public ModBlockBuilder withHardness(Float hardness) {
        this.hardness = hardness;
        return this;
    }

    public SoundType getSoundType() {
        return this.soundType;
    }

    public ModBlockBuilder withSoundType(SoundType soundType) {
        this.soundType = soundType;
        return this;
    }

    public CreativeTabs getCreativeTab() {
        return this.tab;
    }

    public ModBlockBuilder withCreativeTab(CreativeTabs tab) {
        this.tab = tab;
        return this;
    }

    public Float getResistance() {
        return this.resistance;
    }

    public ModBlockBuilder withResistance(Float resistance) {
        this.resistance = resistance;
        return this;
    }
}

