/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.gottschcore.world;

import com.someguyssoftware.gottschcore.cube.Cube;
import com.someguyssoftware.gottschcore.positional.Coords;
import com.someguyssoftware.gottschcore.positional.ICoords;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;

public class WorldInfo {
    private static final int MAX_HEIGHT = 256;
    private static final int MIN_HEIGHT = 1;
    public static final ICoords EMPTY_COORDS = new Coords(-1, -1, -1);
    public static final int INVALID_SURFACE_POS = -255;
    public static final int CHUNK_RADIUS = 8;
    public static final int CHUNK_SIZE = 16;

    public static boolean isServerSide() {
        return FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER;
    }

    public static boolean isServerSide(World world) {
        return !world.field_72995_K;
    }

    public static boolean isClientSide() {
        return FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT;
    }

    public static boolean isClientSide(World world) {
        return world.field_72995_K;
    }

    public static int getHeightValue(World world, ICoords coords) {
        return WorldInfo.getHeightValue(world, coords.toPos());
    }

    private static int getHeightValue(World world, BlockPos pos) {
        BlockPos p = world.func_175645_m(pos);
        return p.func_177956_o();
    }

    public static boolean isValidY(ICoords coords) {
        return WorldInfo.isValidY(coords.toPos());
    }

    private static boolean isValidY(BlockPos blockPos) {
        return blockPos.func_177956_o() >= 1 && blockPos.func_177956_o() <= 256;
    }

    public static boolean isValidY(World world, ICoords coords) {
        return WorldInfo.isValidY(world, coords.toPos());
    }

    private static boolean isValidY(World world, BlockPos blockPos) {
        return blockPos.func_177956_o() >= 1 && blockPos.func_177956_o() <= world.func_72940_L();
    }

    public static ICoords getSurfaceCoords(World world, ICoords coords) {
        boolean isSurfaceBlock = false;
        ICoords newCoords = coords;
        while (!isSurfaceBlock) {
            Cube cube = new Cube(world, newCoords.down(1));
            if (!WorldInfo.isValidY(cube.getCoords())) {
                return null;
            }
            if (cube.equalsMaterial(Material.field_151579_a) || cube.isReplaceable() && !cube.isLiquid() || cube.equalsMaterial(Material.field_151584_j) || cube.equalsBlock(Blocks.field_150364_r) || cube.equalsBlock(Blocks.field_150363_s) || cube.isBurning(world)) {
                newCoords = newCoords.down(1);
                continue;
            }
            isSurfaceBlock = true;
        }
        return newCoords;
    }

    public static ICoords getDryLandSurfaceCoords(World world, ICoords coords) {
        boolean isSurfaceBlock = false;
        ICoords newCoords = coords;
        while (!isSurfaceBlock) {
            Cube cube = new Cube(world, newCoords.down(1));
            if (!WorldInfo.isValidY(cube.getCoords())) {
                return EMPTY_COORDS;
            }
            if (cube.equalsMaterial(Material.field_151586_h) || cube.equalsMaterial(Material.field_151587_i) || cube.equalsMaterial(Material.field_151588_w)) {
                return EMPTY_COORDS;
            }
            if (cube.equalsMaterial(Material.field_151579_a) || cube.isReplaceable() || cube.equalsMaterial(Material.field_151584_j) || cube.equalsMaterial(Material.field_151575_d) || cube.isBurning(world)) {
                newCoords = newCoords.down(1);
                continue;
            }
            isSurfaceBlock = true;
        }
        return newCoords;
    }

    public static ICoords getAnyLandSurfaceCoords(World world, ICoords coords) {
        boolean isSurfaceBlock = false;
        ICoords newCoords = coords;
        while (!isSurfaceBlock) {
            Cube cube = new Cube(world, newCoords.down(1));
            if (!WorldInfo.isValidY(cube.getCoords())) {
                return EMPTY_COORDS;
            }
            if (cube.equalsMaterial(Material.field_151579_a) || cube.equalsMaterial(Material.field_151586_h) || cube.isReplaceable() || cube.equalsMaterial(Material.field_151584_j) || cube.equalsMaterial(Material.field_151575_d) || cube.equalsMaterial(Material.field_151587_i) || cube.equalsMaterial(Material.field_151588_w) || cube.isBurning(world)) {
                newCoords = newCoords.down(1);
                continue;
            }
            isSurfaceBlock = true;
        }
        return newCoords;
    }

    public static ICoords getOceanFloorSurfaceCoords(World world, ICoords coords) {
        boolean isSurfaceBlock = false;
        ICoords newCoords = coords;
        while (!isSurfaceBlock) {
            Cube cube = new Cube(world, newCoords.down(1));
            if (!WorldInfo.isValidY(cube.getCoords())) {
                return EMPTY_COORDS;
            }
            if (cube.equalsMaterial(Material.field_151587_i)) {
                return EMPTY_COORDS;
            }
            if (cube.equalsMaterial(Material.field_151579_a) || cube.equalsMaterial(Material.field_151586_h) || cube.equalsMaterial(Material.field_151588_w) || cube.isReplaceable() || cube.equalsMaterial(Material.field_151584_j) || cube.equalsMaterial(Material.field_151575_d) || cube.isBurning(world)) {
                newCoords = newCoords.down(1);
                continue;
            }
            isSurfaceBlock = true;
        }
        return newCoords;
    }

    public static SURFACE getSurface(World world, ICoords coords) {
        ICoords surfaceCoords = WorldInfo.getSurfaceCoords(world, coords);
        if (surfaceCoords == null) {
            return SURFACE.INVALID;
        }
        Cube cube = new Cube(world, surfaceCoords.down(1));
        if (!WorldInfo.isValidY(cube.getCoords())) {
            return SURFACE.INVALID;
        }
        SURFACE surface = cube.equalsMaterial(Material.field_151586_h) || cube.equalsMaterial(Material.field_151588_w) ? SURFACE.WATER : (cube.equalsMaterial(Material.field_151587_i) ? SURFACE.LAVA : (cube.isSolid() ? SURFACE.LAND : SURFACE.OTHER));
        return surface;
    }

    public static boolean isSurfaceOnLand(World world, ICoords coords) {
        return WorldInfo.getSurface(world, coords) == SURFACE.LAND;
    }

    public static boolean isSurfaceOnWater(World world, ICoords coords) {
        return WorldInfo.getSurface(world, coords) == SURFACE.WATER;
    }

    public static boolean isValidAboveGroundBase(World world, ICoords coords, int width, int depth, double groundPercentRequired, double airPercentRequired) {
        return WorldInfo.isSolidBase(world, coords, width, depth, groundPercentRequired) && WorldInfo.isAirBase(world, coords.up(1), width, depth, airPercentRequired);
    }

    public static boolean isValidAboveGroundBase(World world, ICoords coords, int width, int depth, double groundPercentRequired, double airPercentRequired1, double airPercentRequired2) {
        return WorldInfo.isSolidBase(world, coords, width, depth, groundPercentRequired) && WorldInfo.isAirBase(world, coords.up(1), width, depth, airPercentRequired1) && WorldInfo.isAirBase(world, coords.up(2), width, depth, airPercentRequired2);
    }

    public static boolean isSolidBase(World world, ICoords coords, int width, int depth, double percentRequired) {
        double percent = WorldInfo.getSolidBasePercent(world, coords.down(1), width, depth);
        return !(percent < percentRequired);
    }

    public static double getSolidBasePercent(World world, ICoords coords, int width, int depth) {
        int platformSize = 0;
        for (int z = 0; z < depth; ++z) {
            for (int x = 0; x < width; ++x) {
                Cube cube = new Cube(world, coords.add(x, 0, z));
                if (!cube.hasState() || !cube.isSolid() || cube.isReplaceable()) continue;
                ++platformSize;
            }
        }
        double base = depth * width;
        double percent = (double)platformSize / base * 100.0;
        return percent;
    }

    public static double getAirBasePercent(World world, ICoords coords, int width, int depth) {
        double percent = 0.0;
        int airBlocks = 0;
        for (int z = 0; z < depth; ++z) {
            for (int x = 0; x < width; ++x) {
                Cube cube = new Cube(world, coords.add(x, 0, z));
                if (!cube.hasState() || !cube.equalsMaterial(Material.field_151579_a) && !cube.isReplaceable()) continue;
                ++airBlocks;
            }
        }
        double base = depth * width;
        percent = (double)airBlocks / base * 100.0;
        return percent;
    }

    public static boolean isAirBase(World world, ICoords coords, int width, int depth, double percentRequired) {
        double percent = WorldInfo.getAirBasePercent(world, coords.down(1), width, depth);
        return !(percent < percentRequired);
    }

    public static int getDifferenceWithSurface(World world, ICoords coords) {
        int ySurface = 0;
        int diff = 0;
        ySurface = WorldInfo.getHeightValue(world, coords);
        ICoords surfaceCoords = WorldInfo.getSurfaceCoords(world, coords.resetY(ySurface));
        if (surfaceCoords == null) {
            return -255;
        }
        diff = surfaceCoords.getY() - coords.getY();
        return diff;
    }

    public static ICoords getClosestPlayerCoords(World world, ICoords sourceCoords) {
        double closestDistSq = -1.0;
        Coords closestCoords = null;
        for (int i = 0; i < world.field_73010_i.size(); ++i) {
            EntityPlayer player = (EntityPlayer)world.field_73010_i.get(i);
            Coords playerCoords = new Coords(player.func_180425_c());
            double dist = sourceCoords.getDistanceSq(playerCoords);
            if (closestDistSq != -1.0 && !(dist < closestDistSq)) continue;
            closestDistSq = dist;
            closestCoords = playerCoords;
        }
        return closestCoords;
    }

    public static enum SURFACE {
        LAND,
        WATER,
        LAVA,
        OTHER,
        INVALID;

    }
}

