/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.gottschcore.world.gen.structure;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.someguyssoftware.gottschcore.GottschCore;
import com.someguyssoftware.gottschcore.positional.Coords;
import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.gottschcore.world.gen.structure.DecayBlockInfo;
import com.someguyssoftware.gottschcore.world.gen.structure.IDecayProcessor;
import com.someguyssoftware.gottschcore.world.gen.structure.StructureMarkerContext;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityStructure;
import net.minecraft.util.Mirror;
import net.minecraft.util.ObjectIntIdentityMap;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.template.BlockRotationProcessor;
import net.minecraft.world.gen.structure.template.ITemplateProcessor;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class GottschTemplate
extends Template {
    private final List<Template.BlockInfo> blocks = Lists.newArrayList();
    private final List<Template.EntityInfo> entities = Lists.newArrayList();
    private BlockPos size = BlockPos.field_177992_a;
    private final Multimap<Block, StructureMarkerContext> markerMap = ArrayListMultimap.create();

    public BlockPos func_186259_a() {
        return this.size;
    }

    public Map<BlockPos, String> func_186258_a(BlockPos pos, PlacementSettings placementIn) {
        HashMap map = Maps.newHashMap();
        StructureBoundingBox structureboundingbox = placementIn.func_186213_g();
        for (Template.BlockInfo template$blockinfo : this.blocks) {
            TileEntityStructure.Mode tileentitystructure$mode;
            IBlockState iblockstate;
            BlockPos blockpos = GottschTemplate.func_186266_a((PlacementSettings)placementIn, (BlockPos)template$blockinfo.field_186242_a).func_177971_a((Vec3i)pos);
            if (structureboundingbox != null && !structureboundingbox.func_175898_b((Vec3i)blockpos) || (iblockstate = template$blockinfo.field_186243_b).func_177230_c() != Blocks.field_185779_df || template$blockinfo.field_186244_c == null || (tileentitystructure$mode = TileEntityStructure.Mode.valueOf((String)template$blockinfo.field_186244_c.func_74779_i("mode"))) != TileEntityStructure.Mode.DATA) continue;
            map.put(blockpos, template$blockinfo.field_186244_c.func_74779_i("metadata"));
        }
        return map;
    }

    public void func_186253_b(World worldIn, BlockPos pos, PlacementSettings placementIn) {
        this.func_189960_a(worldIn, pos, (ITemplateProcessor)new BlockRotationProcessor(pos, placementIn), placementIn, 2);
    }

    public void func_189962_a(World world, BlockPos pos, PlacementSettings placementIn, int flags) {
        this.addBlocksToWorld(world, pos, (ITemplateProcessor)new BlockRotationProcessor(pos, placementIn), placementIn, Blocks.field_150357_h, null, flags);
    }

    public void addBlocksToWorld(World world, BlockPos pos, IDecayProcessor decayProcessor, PlacementSettings placementIn, int flags) {
        this.addBlocksToWorld(world, pos, (ITemplateProcessor)new BlockRotationProcessor(pos, placementIn), decayProcessor, placementIn, Blocks.field_150357_h, null, flags);
    }

    public void addBlocksToWorld(World worldIn, BlockPos pos, PlacementSettings placementIn, Block NULL_BLOCK, Map<IBlockState, IBlockState> replacementBlocks, int flags) {
        this.addBlocksToWorld(worldIn, pos, (ITemplateProcessor)new BlockRotationProcessor(pos, placementIn), placementIn, NULL_BLOCK, replacementBlocks, flags);
    }

    public void addBlocksToWorld(World worldIn, BlockPos pos, IDecayProcessor decayProcessor, PlacementSettings placementIn, Block NULL_BLOCK, Map<IBlockState, IBlockState> replacementBlocks, int flags) {
        this.addBlocksToWorld(worldIn, pos, (ITemplateProcessor)new BlockRotationProcessor(pos, placementIn), decayProcessor, placementIn, NULL_BLOCK, replacementBlocks, flags);
    }

    public void addBlocksToWorld(World worldIn, BlockPos pos, @Nullable ITemplateProcessor templateProcessor, PlacementSettings placementIn, Block NULL_BLOCK, Map<IBlockState, IBlockState> replacementBlocks, int flags) {
        if (!(this.blocks.isEmpty() && (placementIn.func_186221_e() || this.entities.isEmpty()) || this.size.func_177958_n() < 1 || this.size.func_177956_o() < 1 || this.size.func_177952_p() < 1)) {
            Block replacedBlock = placementIn.func_186219_f();
            StructureBoundingBox structureboundingbox = placementIn.func_186213_g();
            for (Template.BlockInfo blockInfo : this.blocks) {
                TileEntity tileentity2;
                TileEntity tileentity;
                Template.BlockInfo processedBlockInfo;
                BlockPos blockpos = GottschTemplate.func_186266_a((PlacementSettings)placementIn, (BlockPos)blockInfo.field_186242_a).func_177971_a((Vec3i)pos);
                if (structureboundingbox != null && !structureboundingbox.func_175898_b((Vec3i)blockpos) || (processedBlockInfo = templateProcessor != null ? templateProcessor.func_189943_a(worldIn, blockpos, blockInfo) : blockInfo) == null) continue;
                Block processedBlock = null;
                processedBlock = processedBlockInfo.field_186243_b.func_177230_c();
                if (this.markerMap.containsKey((Object)processedBlock)) {
                    processedBlock = NULL_BLOCK;
                }
                if (replacedBlock != null && replacedBlock == processedBlock || placementIn.func_186227_h() && processedBlock == Blocks.field_185779_df || structureboundingbox != null && !structureboundingbox.func_175898_b((Vec3i)blockpos) || processedBlock == NULL_BLOCK) continue;
                IBlockState iblockstate = processedBlockInfo.field_186243_b.func_185902_a(placementIn.func_186212_b());
                IBlockState iblockstate1 = iblockstate.func_185907_a(placementIn.func_186215_c());
                if (replacementBlocks != null && replacementBlocks.containsKey(iblockstate1)) {
                    iblockstate1 = replacementBlocks.get(iblockstate1);
                }
                if (processedBlockInfo.field_186244_c != null && (tileentity = worldIn.func_175625_s(blockpos)) != null) {
                    if (tileentity instanceof IInventory) {
                        ((IInventory)tileentity).func_174888_l();
                    }
                    worldIn.func_180501_a(blockpos, Blocks.field_180401_cv.func_176223_P(), 4);
                }
                if (!worldIn.func_180501_a(blockpos, iblockstate1, flags) || processedBlockInfo.field_186244_c == null || (tileentity2 = worldIn.func_175625_s(blockpos)) == null) continue;
                processedBlockInfo.field_186244_c.func_74768_a("x", blockpos.func_177958_n());
                processedBlockInfo.field_186244_c.func_74768_a("y", blockpos.func_177956_o());
                processedBlockInfo.field_186244_c.func_74768_a("z", blockpos.func_177952_p());
                tileentity2.func_145839_a(processedBlockInfo.field_186244_c);
                tileentity2.func_189668_a(placementIn.func_186212_b());
                tileentity2.func_189667_a(placementIn.func_186215_c());
            }
            for (Template.BlockInfo template$blockinfo2 : this.blocks) {
                TileEntity tileentity1;
                if (replacedBlock != null && replacedBlock == template$blockinfo2.field_186243_b.func_177230_c()) continue;
                BlockPos blockpos1 = GottschTemplate.func_186266_a((PlacementSettings)placementIn, (BlockPos)template$blockinfo2.field_186242_a).func_177971_a((Vec3i)pos);
                if (structureboundingbox != null && !structureboundingbox.func_175898_b((Vec3i)blockpos1)) continue;
                worldIn.func_175722_b(blockpos1, template$blockinfo2.field_186243_b.func_177230_c(), false);
                if (template$blockinfo2.field_186244_c == null || (tileentity1 = worldIn.func_175625_s(blockpos1)) == null) continue;
                tileentity1.func_70296_d();
            }
            if (!placementIn.func_186221_e()) {
                this.addEntitiesToWorld(worldIn, pos, placementIn.func_186212_b(), placementIn.func_186215_c(), structureboundingbox);
            }
        }
    }

    public void addBlocksToWorld(World worldIn, BlockPos pos, @Nullable ITemplateProcessor templateProcessor, @Nullable IDecayProcessor decayProcessor, PlacementSettings placementIn, Block NULL_BLOCK, Map<IBlockState, IBlockState> replacementBlocks, int flags) {
        if (!(this.blocks.isEmpty() && (placementIn.func_186221_e() || this.entities.isEmpty()) || this.size.func_177958_n() < 1 || this.size.func_177956_o() < 1 || this.size.func_177952_p() < 1)) {
            Template.BlockInfo processed;
            Block replacedBlock = placementIn.func_186219_f();
            StructureBoundingBox structureBoundingBox = placementIn.func_186213_g();
            for (Template.BlockInfo blockInfo : this.blocks) {
                Template.BlockInfo processedBlockInfo;
                BlockPos blockPos = GottschTemplate.func_186266_a((PlacementSettings)placementIn, (BlockPos)blockInfo.field_186242_a).func_177971_a((Vec3i)pos);
                if (structureBoundingBox != null && !structureBoundingBox.func_175898_b((Vec3i)blockPos) || (processedBlockInfo = templateProcessor != null ? templateProcessor.func_189943_a(worldIn, blockPos, blockInfo) : blockInfo) == null) continue;
                Block processedBlock = null;
                processedBlock = processedBlockInfo.field_186243_b.func_177230_c();
                if (replacedBlock != null && replacedBlock == processedBlock || placementIn.func_186227_h() && processedBlock == Blocks.field_185779_df || structureBoundingBox != null && !structureBoundingBox.func_175898_b((Vec3i)blockPos)) continue;
                IBlockState iblockstate = processedBlockInfo.field_186243_b.func_185902_a(placementIn.func_186212_b());
                IBlockState blockState1 = iblockstate.func_185907_a(placementIn.func_186215_c());
                if (this.markerMap.containsKey((Object)blockState1.func_177230_c())) {
                    blockState1 = NULL_BLOCK.func_176223_P();
                }
                if (replacementBlocks != null && replacementBlocks.containsKey(blockState1)) {
                    blockState1 = replacementBlocks.get(blockState1);
                }
                decayProcessor.add(new Coords(blockPos), processedBlockInfo, blockState1);
            }
            Coords transformedSize = new Coords(this.func_186257_a(placementIn.func_186215_c()));
            List<DecayBlockInfo> decayBlockInfoList = decayProcessor.process(worldIn, new Random(), transformedSize, NULL_BLOCK);
            for (DecayBlockInfo decay : decayBlockInfoList) {
                TileEntity tileentity2;
                TileEntity tileentity;
                if (decay.getState().func_177230_c() == NULL_BLOCK) continue;
                processed = decay.getBlockInfo();
                BlockPos decayPos = decay.getCoords().toPos();
                if (processed.field_186244_c != null && (tileentity = worldIn.func_175625_s(decayPos)) != null) {
                    if (tileentity instanceof IInventory) {
                        ((IInventory)tileentity).func_174888_l();
                    }
                    worldIn.func_180501_a(decayPos, Blocks.field_180401_cv.func_176223_P(), 4);
                }
                if (!worldIn.func_180501_a(decayPos, decay.getState(), flags) || processed.field_186244_c == null || (tileentity2 = worldIn.func_175625_s(decayPos)) == null) continue;
                processed.field_186244_c.func_74768_a("x", decayPos.func_177958_n());
                processed.field_186244_c.func_74768_a("y", decayPos.func_177956_o());
                processed.field_186244_c.func_74768_a("z", decayPos.func_177952_p());
                tileentity2.func_145839_a(processed.field_186244_c);
                tileentity2.func_189668_a(placementIn.func_186212_b());
                tileentity2.func_189667_a(placementIn.func_186215_c());
            }
            for (DecayBlockInfo decay : decayBlockInfoList) {
                TileEntity tileEntity1;
                if (decay.getState().func_177230_c() == NULL_BLOCK) continue;
                processed = decay.getBlockInfo();
                if (replacedBlock != null && replacedBlock == processed.field_186243_b.func_177230_c()) continue;
                BlockPos blockPos1 = GottschTemplate.func_186266_a((PlacementSettings)placementIn, (BlockPos)processed.field_186242_a).func_177971_a((Vec3i)pos);
                if (structureBoundingBox != null && !structureBoundingBox.func_175898_b((Vec3i)blockPos1)) continue;
                worldIn.func_175722_b(blockPos1, processed.field_186243_b.func_177230_c(), false);
                if (processed.field_186244_c == null || (tileEntity1 = worldIn.func_175625_s(blockPos1)) == null) continue;
                tileEntity1.func_70296_d();
            }
            if (!placementIn.func_186221_e()) {
                this.addEntitiesToWorld(worldIn, pos, placementIn.func_186212_b(), placementIn.func_186215_c(), structureBoundingBox);
            }
        }
    }

    private void addEntitiesToWorld(World worldIn, BlockPos pos, Mirror mirrorIn, Rotation rotationIn, @Nullable StructureBoundingBox aabb) {
        PlacementSettings placement = new PlacementSettings();
        placement.func_186220_a(rotationIn).func_186214_a(mirrorIn);
        for (Template.EntityInfo template$entityinfo : this.entities) {
            Entity entity;
            BlockPos blockpos = GottschTemplate.func_186266_a((PlacementSettings)placement, (BlockPos)template$entityinfo.field_186248_b).func_177971_a((Vec3i)pos);
            if (aabb != null && !aabb.func_175898_b((Vec3i)blockpos)) continue;
            NBTTagCompound nbttagcompound = template$entityinfo.field_186249_c;
            Vec3d vec3d = GottschTemplate.transformedVec3d(template$entityinfo.field_186247_a, mirrorIn, rotationIn);
            Vec3d vec3d1 = vec3d.func_72441_c((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            NBTTagList nbttaglist = new NBTTagList();
            nbttaglist.func_74742_a((NBTBase)new NBTTagDouble(vec3d1.field_72450_a));
            nbttaglist.func_74742_a((NBTBase)new NBTTagDouble(vec3d1.field_72448_b));
            nbttaglist.func_74742_a((NBTBase)new NBTTagDouble(vec3d1.field_72449_c));
            nbttagcompound.func_74782_a("Pos", (NBTBase)nbttaglist);
            nbttagcompound.func_186854_a("UUID", UUID.randomUUID());
            try {
                entity = EntityList.func_75615_a((NBTTagCompound)nbttagcompound, (World)worldIn);
            }
            catch (Exception var15) {
                entity = null;
            }
            if (entity == null) continue;
            float f = entity.func_184217_a(mirrorIn);
            entity.func_70012_b(vec3d1.field_72450_a, vec3d1.field_72448_b, vec3d1.field_72449_c, f += entity.field_70177_z - entity.func_184229_a(rotationIn), entity.field_70125_A);
            worldIn.func_72838_d(entity);
        }
    }

    public BlockPos func_186257_a(Rotation rotationIn) {
        switch (rotationIn) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                return new BlockPos(this.func_186259_a().func_177952_p(), this.func_186259_a().func_177956_o(), this.func_186259_a().func_177958_n());
            }
        }
        return this.func_186259_a();
    }

    public static ICoords transformedCoords(PlacementSettings placement, ICoords coords) {
        return new Coords(GottschTemplate.func_186266_a((PlacementSettings)placement, (BlockPos)coords.toPos()));
    }

    private static Vec3d transformedVec3d(Vec3d vec, Mirror mirrorIn, Rotation rotationIn) {
        double d0 = vec.field_72450_a;
        double d1 = vec.field_72448_b;
        double d2 = vec.field_72449_c;
        boolean flag = true;
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                d2 = 1.0 - d2;
                break;
            }
            case FRONT_BACK: {
                d0 = 1.0 - d0;
                break;
            }
            default: {
                flag = false;
            }
        }
        switch (rotationIn) {
            case COUNTERCLOCKWISE_90: {
                return new Vec3d(d2, d1, 1.0 - d0);
            }
            case CLOCKWISE_90: {
                return new Vec3d(1.0 - d2, d1, d0);
            }
            case CLOCKWISE_180: {
                return new Vec3d(1.0 - d0, d1, 1.0 - d2);
            }
        }
        return flag ? new Vec3d(d0, d1, d2) : vec;
    }

    public NBTTagCompound func_189552_a(NBTTagCompound nbt) {
        BasicPalette template$basicpalette = new BasicPalette();
        NBTTagList nbttaglist = new NBTTagList();
        for (Template.BlockInfo blockInfo : this.blocks) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74782_a("pos", (NBTBase)this.writeInts(blockInfo.field_186242_a.func_177958_n(), blockInfo.field_186242_a.func_177956_o(), blockInfo.field_186242_a.func_177952_p()));
            nbttagcompound.func_74768_a("state", template$basicpalette.idFor(blockInfo.field_186243_b));
            if (blockInfo.field_186244_c != null) {
                nbttagcompound.func_74782_a("nbt", (NBTBase)blockInfo.field_186244_c);
            }
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        NBTTagList nbttaglist1 = new NBTTagList();
        for (Template.EntityInfo template$entityinfo : this.entities) {
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74782_a("pos", (NBTBase)this.writeDoubles(template$entityinfo.field_186247_a.field_72450_a, template$entityinfo.field_186247_a.field_72448_b, template$entityinfo.field_186247_a.field_72449_c));
            nbttagcompound1.func_74782_a("blockPos", (NBTBase)this.writeInts(template$entityinfo.field_186248_b.func_177958_n(), template$entityinfo.field_186248_b.func_177956_o(), template$entityinfo.field_186248_b.func_177952_p()));
            if (template$entityinfo.field_186249_c != null) {
                nbttagcompound1.func_74782_a("nbt", (NBTBase)template$entityinfo.field_186249_c);
            }
            nbttaglist1.func_74742_a((NBTBase)nbttagcompound1);
        }
        NBTTagList nBTTagList = new NBTTagList();
        for (IBlockState iblockstate : template$basicpalette) {
            nBTTagList.func_74742_a((NBTBase)NBTUtil.func_190009_a((NBTTagCompound)new NBTTagCompound(), (IBlockState)iblockstate));
        }
        FMLCommonHandler.instance().getDataFixer().writeVersionData(nbt);
        nbt.func_74782_a("palette", (NBTBase)nBTTagList);
        nbt.func_74782_a("blocks", (NBTBase)nbttaglist);
        nbt.func_74782_a("entities", (NBTBase)nbttaglist1);
        nbt.func_74782_a("size", (NBTBase)this.writeInts(this.size.func_177958_n(), this.size.func_177956_o(), this.size.func_177952_p()));
        nbt.func_74778_a("author", this.func_186261_b());
        nbt.func_74768_a("DataVersion", 1343);
        return nbt;
    }

    public void read(NBTTagCompound compound, List<Block> markerBlocks, Map<IBlockState, IBlockState> replacementBlocks) {
        GottschCore.logger.debug("made it to template.read()");
        this.blocks.clear();
        this.entities.clear();
        NBTTagList nbttaglist = compound.func_150295_c("size", 3);
        this.size = new BlockPos(nbttaglist.func_186858_c(0), nbttaglist.func_186858_c(1), nbttaglist.func_186858_c(2));
        this.func_186252_a(compound.func_74779_i("author"));
        BasicPalette template$basicpalette = new BasicPalette();
        NBTTagList nbttaglist1 = compound.func_150295_c("palette", 10);
        for (int i = 0; i < nbttaglist1.func_74745_c(); ++i) {
            template$basicpalette.addMapping(NBTUtil.func_190008_d((NBTTagCompound)nbttaglist1.func_150305_b(i)), i);
        }
        NBTTagList blocks = compound.func_150295_c("blocks", 10);
        for (int blockIndex = 0; blockIndex < blocks.func_74745_c(); ++blockIndex) {
            NBTTagCompound nbttagcompound = blocks.func_150305_b(blockIndex);
            NBTTagList nbttaglist2 = nbttagcompound.func_150295_c("pos", 3);
            BlockPos blockPos = new BlockPos(nbttaglist2.func_186858_c(0), nbttaglist2.func_186858_c(1), nbttaglist2.func_186858_c(2));
            IBlockState blockState = template$basicpalette.stateFor(nbttagcompound.func_74762_e("state"));
            NBTTagCompound nbttagcompound1 = null;
            nbttagcompound1 = nbttagcompound.func_74764_b("nbt") ? nbttagcompound.func_74775_l("nbt") : null;
            this.blocks.add(new Template.BlockInfo(blockPos, blockState, nbttagcompound1));
            Block block = blockState.func_177230_c();
            if (block == Blocks.field_150350_a || !markerBlocks.contains(block)) continue;
            GottschCore.logger.debug("template map adding block -> {} with pos -> {}", (Object)block.getRegistryName(), (Object)blockPos);
            this.markerMap.put((Object)block, (Object)new StructureMarkerContext(new Coords(blockPos), blockState));
        }
        NBTTagList nbttaglist4 = compound.func_150295_c("entities", 10);
        for (int k = 0; k < nbttaglist4.func_74745_c(); ++k) {
            NBTTagCompound nbttagcompound3 = nbttaglist4.func_150305_b(k);
            NBTTagList nbttaglist5 = nbttagcompound3.func_150295_c("pos", 6);
            Vec3d vec3d = new Vec3d(nbttaglist5.func_150309_d(0), nbttaglist5.func_150309_d(1), nbttaglist5.func_150309_d(2));
            NBTTagList nbttaglist6 = nbttagcompound3.func_150295_c("blockPos", 3);
            BlockPos blockpos1 = new BlockPos(nbttaglist6.func_186858_c(0), nbttaglist6.func_186858_c(1), nbttaglist6.func_186858_c(2));
            if (!nbttagcompound3.func_74764_b("nbt")) continue;
            NBTTagCompound nbttagcompound2 = nbttagcompound3.func_74775_l("nbt");
            this.entities.add(new Template.EntityInfo(vec3d, blockpos1, nbttagcompound2));
        }
    }

    private NBTTagList writeInts(int ... values) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i : values) {
            nbttaglist.func_74742_a((NBTBase)new NBTTagInt(i));
        }
        return nbttaglist;
    }

    private NBTTagList writeDoubles(double ... values) {
        NBTTagList nbttaglist = new NBTTagList();
        for (double d0 : values) {
            nbttaglist.func_74742_a((NBTBase)new NBTTagDouble(d0));
        }
        return nbttaglist;
    }

    @Deprecated
    public Multimap<Block, ICoords> getMap() {
        ArrayListMultimap map = ArrayListMultimap.create();
        for (Map.Entry e : this.getMarkerMap().entries()) {
            map.put(e.getKey(), (Object)((StructureMarkerContext)e.getValue()).getCoords());
        }
        return map;
    }

    public void setSize(BlockPos size) {
        this.size = size;
    }

    public ICoords findCoords(Random random, Block findBlock) {
        ICoords coords = null;
        List contextList = (List)this.getMarkerMap().get((Object)findBlock);
        List list = contextList.stream().map(c -> c.getCoords()).collect(Collectors.toList());
        if (list.isEmpty()) {
            return new Coords(0, 0, 0);
        }
        coords = list.size() == 1 ? (ICoords)list.get(0) : (ICoords)list.get(random.nextInt(list.size()));
        return coords;
    }

    @Deprecated
    public List<ICoords> findCoords(Block findBlock) {
        List contextList = (List)this.getMarkerMap().get((Object)findBlock);
        List<ICoords> list = contextList.stream().map(e -> e.getCoords()).collect(Collectors.toList());
        return list;
    }

    @Deprecated
    public List<ICoords> getMapCoords() {
        List<ICoords> coords = this.getMarkerMap().entries().stream().map(e -> ((StructureMarkerContext)e.getValue()).getCoords()).collect(Collectors.toList());
        return coords;
    }

    public Multimap<Block, StructureMarkerContext> getMarkerMap() {
        return this.markerMap;
    }

    static class BasicPalette
    implements Iterable<IBlockState> {
        public static final IBlockState DEFAULT_BLOCK_STATE = Blocks.field_150350_a.func_176223_P();
        final ObjectIntIdentityMap<IBlockState> ids = new ObjectIntIdentityMap(16);
        private int lastId;

        private BasicPalette() {
        }

        public int idFor(IBlockState state) {
            int i = this.ids.func_148747_b((Object)state);
            if (i == -1) {
                i = this.lastId++;
                this.ids.func_148746_a((Object)state, i);
            }
            return i;
        }

        @Nullable
        public IBlockState stateFor(int id) {
            IBlockState iblockstate = (IBlockState)this.ids.func_148745_a(id);
            return iblockstate == null ? DEFAULT_BLOCK_STATE : iblockstate;
        }

        @Override
        public Iterator<IBlockState> iterator() {
            return this.ids.iterator();
        }

        public void addMapping(IBlockState blockState, int p_189956_2_) {
            this.ids.func_148746_a((Object)blockState, p_189956_2_);
        }
    }
}

