/*
 * Decompiled with CFR 0.152.
 */
package familiarfauna.init;

import com.google.common.collect.Maps;
import familiarfauna.config.ConfigurationHandler;
import familiarfauna.core.FamiliarFauna;
import familiarfauna.entities.EntityButterfly;
import familiarfauna.entities.EntityDeer;
import familiarfauna.entities.EntityDragonfly;
import familiarfauna.entities.EntityPixie;
import familiarfauna.entities.EntitySnail;
import familiarfauna.entities.EntityTurkey;
import familiarfauna.init.ModConfiguration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class ModEntities {
    public static final Map<Integer, EntityList.EntityEggInfo> entityEggs = Maps.newLinkedHashMap();
    public static final Map<Integer, String> idToBEEntityName = Maps.newLinkedHashMap();
    private static int nextFFEntityId = 1;

    public static void init() {
        ModEntities.registerFFEntityWithSpawnEgg(EntityButterfly.class, "familiarfauna.butterfly", 80, 3, true, 0x282828, 15691551, EnumCreatureType.AMBIENT, ConfigurationHandler.butterflyWeight, ConfigurationHandler.butterflyMin, ConfigurationHandler.butterflyMax, ModConfiguration.butterflyBiomeList);
        if (ConfigurationHandler.deerReplaceCows) {
            ModEntities.removeSpawn(EntityCow.class, EnumCreatureType.CREATURE, ModConfiguration.deerBiomeList);
        }
        ModEntities.registerFFEntityWithSpawnEgg(EntityDeer.class, "familiarfauna.deer", 80, 3, true, 7754036, 16248806, EnumCreatureType.CREATURE, ConfigurationHandler.deerWeight, ConfigurationHandler.deerMin, ConfigurationHandler.deerMax, ModConfiguration.deerBiomeList);
        ModEntities.registerFFEntityWithSpawnEgg(EntityDragonfly.class, "familiarfauna.dragonfly", 80, 3, true, 3424365, 5349836, EnumCreatureType.AMBIENT, ConfigurationHandler.dragonflyWeight, ConfigurationHandler.dragonflyMin, ConfigurationHandler.dragonflyMax, ModConfiguration.dragonflyBiomeList);
        ModEntities.registerFFEntityWithSpawnEgg(EntityPixie.class, "familiarfauna.pixie", 80, 3, true, 0xFF99E9, 0xFFFFFF, EnumCreatureType.AMBIENT, ConfigurationHandler.pixieWeight, ConfigurationHandler.pixieMin, ConfigurationHandler.pixieMax, ModConfiguration.pixieBiomeList);
        ModEntities.registerFFEntityWithSpawnEgg(EntitySnail.class, "familiarfauna.snail", 80, 3, true, 10917052, 13476462, EnumCreatureType.AMBIENT, ConfigurationHandler.snailWeight, ConfigurationHandler.snailMin, ConfigurationHandler.snailMax, ModConfiguration.snailBiomeList);
        if (ConfigurationHandler.turkeyReplaceChickens) {
            ModEntities.removeSpawn(EntityChicken.class, EnumCreatureType.CREATURE, ModConfiguration.turkeyBiomeList);
        }
        ModEntities.registerFFEntityWithSpawnEgg(EntityTurkey.class, "familiarfauna.turkey", 80, 3, true, 7031086, 14823729, EnumCreatureType.CREATURE, ConfigurationHandler.turkeyWeight, ConfigurationHandler.turkeyMin, ConfigurationHandler.turkeyMax, ModConfiguration.turkeyBiomeList);
    }

    public static int registerFFEntity(Class<? extends Entity> entityClass, String entityName, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
        int ffEntityId = nextFFEntityId++;
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("familiarfauna", entityName), entityClass, (String)entityName, (int)ffEntityId, (Object)FamiliarFauna.instance, (int)trackingRange, (int)updateFrequency, (boolean)sendsVelocityUpdates);
        idToBEEntityName.put(ffEntityId, entityName);
        return ffEntityId;
    }

    public static int registerFFEntityWithSpawnEgg(Class<? extends EntityLiving> entityClass, String entityName, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates, int eggBackgroundColor, int eggForegroundColor, EnumCreatureType enumCreatureType, int spawnWeight, int spawnMin, int spawnMax, List<String> biomes) {
        int ffEntityId = ModEntities.registerFFEntity(entityClass, entityName, trackingRange, updateFrequency, sendsVelocityUpdates);
        EntityRegistry.registerEgg((ResourceLocation)new ResourceLocation("familiarfauna", entityName), (int)eggBackgroundColor, (int)eggForegroundColor);
        ModEntities.addSpawn(entityClass, spawnWeight, spawnMin, spawnMax, enumCreatureType, biomes);
        return ffEntityId;
    }

    public static Entity createEntityByID(int tanEntityId, World worldIn) {
        Entity entity = null;
        ModContainer mc = FMLCommonHandler.instance().findContainerFor((Object)FamiliarFauna.instance);
        EntityRegistry.EntityRegistration er = EntityRegistry.instance().lookupModSpawn(mc, tanEntityId);
        if (er != null) {
            Class clazz = er.getEntityClass();
            try {
                if (clazz != null) {
                    entity = (Entity)clazz.getConstructor(World.class).newInstance(worldIn);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (entity == null) {
            FamiliarFauna.logger.warn("Skipping FF Entity with id " + tanEntityId);
        }
        return entity;
    }

    public static void addSpawn(Class<? extends EntityLiving> entityClass, int weightedProb, int min, int max, EnumCreatureType typeOfCreature, List<String> biomes) {
        for (String biomeName : biomes) {
            ResourceLocation loc = new ResourceLocation(biomeName);
            if (!ForgeRegistries.BIOMES.containsKey(loc)) continue;
            Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(loc);
            List spawns = biome.func_76747_a(typeOfCreature);
            boolean found = false;
            for (Biome.SpawnListEntry entry : spawns) {
                if (entry.field_76300_b != entityClass) continue;
                entry.field_76292_a = weightedProb;
                entry.field_76301_c = min;
                entry.field_76299_d = max;
                found = true;
                break;
            }
            if (found) continue;
            spawns.add(new Biome.SpawnListEntry(entityClass, weightedProb, min, max));
        }
    }

    public static void removeSpawn(Class<? extends EntityLiving> entityClass, EnumCreatureType typeOfCreature, List<String> biomes) {
        for (String biomeName : biomes) {
            ResourceLocation loc = new ResourceLocation(biomeName);
            if (!ForgeRegistries.BIOMES.containsKey(loc)) continue;
            Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(loc);
            Iterator spawns = biome.func_76747_a(typeOfCreature).iterator();
            while (spawns.hasNext()) {
                Biome.SpawnListEntry entry = (Biome.SpawnListEntry)spawns.next();
                if (entry.field_76300_b != entityClass) continue;
                spawns.remove();
            }
        }
    }
}

