/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import teamroots.embers.api.capabilities.EmbersCapabilities;
import teamroots.embers.api.power.IEmberCapability;
import teamroots.embers.api.tile.IExtraDialInformation;
import teamroots.embers.tileentity.TileEntityBaseGauge;

public class TileEntityEmberGauge
extends TileEntityBaseGauge {
    @Override
    public int calculateComparatorValue(TileEntity tileEntity, EnumFacing facing) {
        int comparatorValue = 0;
        if (tileEntity.hasCapability(EmbersCapabilities.EMBER_CAPABILITY, facing)) {
            IEmberCapability capability = (IEmberCapability)tileEntity.getCapability(EmbersCapabilities.EMBER_CAPABILITY, facing);
            double fill = capability.getEmber() / capability.getEmberCapacity();
            int n = comparatorValue = fill > 0.0 ? (int)(1.0 + fill * 14.0) : 0;
        }
        if (tileEntity instanceof IExtraDialInformation) {
            comparatorValue = ((IExtraDialInformation)tileEntity).getComparatorData(facing, comparatorValue, this.getDialType());
        }
        return comparatorValue;
    }

    @Override
    public String getDialType() {
        return "ember";
    }
}

