/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import mysticalmechanics.api.IGearBehavior;
import mysticalmechanics.api.IGearbox;
import mysticalmechanics.api.IMechCapability;
import mysticalmechanics.api.MysticalMechanicsAPI;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import teamroots.embers.api.capabilities.EmbersCapabilities;
import teamroots.embers.api.tile.IExtraCapabilityInformation;
import teamroots.embers.block.BlockMechActuator;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.upgrade.UpgradeActuator;
import teamroots.embers.util.ConsumerMechCapability;
import teamroots.embers.util.Misc;

public class TileEntityMechActuator
extends TileEntity
implements ITickable,
ITileEntityBase,
IGearbox,
IExtraCapabilityInformation {
    public UpgradeActuator upgrade;
    public ItemStack[] gears = new ItemStack[]{ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a};
    public double angle;
    public double lastAngle;
    private Random random = new Random();
    public ConsumerMechCapability capability = new ConsumerMechCapability(){

        @Override
        public void onPowerChange() {
            TileEntityMechActuator box = TileEntityMechActuator.this;
            box.updateNeighbors();
            box.func_70296_d();
        }

        @Override
        public double getPower(EnumFacing from) {
            ItemStack gearStack = TileEntityMechActuator.this.getGear(from);
            if (from != null && gearStack.func_190926_b()) {
                return 0.0;
            }
            IGearBehavior behavior = MysticalMechanicsAPI.IMPL.getGearBehavior(gearStack);
            return behavior.transformPower((TileEntity)TileEntityMechActuator.this, from, gearStack, super.getPower(from));
        }

        @Override
        public void setPower(double value, EnumFacing from) {
            ItemStack gearStack = TileEntityMechActuator.this.getGear(from);
            if (from != null && gearStack.func_190926_b()) {
                super.setPower(0.0, from);
            }
            super.setPower(value, from);
        }
    };

    public TileEntityMechActuator() {
        this.upgrade = new UpgradeActuator(this);
        this.capability.setAdditive(true);
    }

    public void updateNeighbors() {
        for (EnumFacing f : EnumFacing.field_82609_l) {
            TileEntity t = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(f));
            if (t != null && t.hasCapability(MysticalMechanicsAPI.MECH_CAPABILITY, f.func_176734_d()) && !this.getGear(f).func_190926_b()) {
                this.capability.setPower(((IMechCapability)t.getCapability(MysticalMechanicsAPI.MECH_CAPABILITY, f.func_176734_d())).getPower(f.func_176734_d()), f);
                continue;
            }
            this.capability.setPower(0.0, f);
        }
        this.func_70296_d();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        int i;
        super.func_189515_b(tag);
        for (i = 0; i < 6; ++i) {
            tag.func_74782_a("gear" + i, (NBTBase)this.gears[i].func_77955_b(new NBTTagCompound()));
        }
        for (i = 0; i < 6; ++i) {
            tag.func_74780_a("mech_power" + i, this.capability.power[i]);
        }
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        int i;
        super.func_145839_a(tag);
        for (i = 0; i < 6; ++i) {
            this.gears[i] = new ItemStack(tag.func_74775_l("gear" + i));
        }
        for (i = 0; i < 6; ++i) {
            this.capability.power[i] = tag.func_74769_h("mech_power" + i);
        }
        this.capability.markDirty();
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public EnumFacing getFacing() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (state.func_177230_c() instanceof BlockMechActuator) {
            return (EnumFacing)state.func_177229_b((IProperty)BlockMechActuator.facing);
        }
        return null;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == EmbersCapabilities.UPGRADE_PROVIDER_CAPABILITY) {
            return this.getFacing().func_176734_d() == facing;
        }
        if (capability == MysticalMechanicsAPI.MECH_CAPABILITY) {
            return facing == null || this.getFacing().func_176740_k() != facing.func_176740_k();
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == EmbersCapabilities.UPGRADE_PROVIDER_CAPABILITY && this.getFacing().func_176734_d() == facing) {
            return (T)this.upgrade;
        }
        if (capability == MysticalMechanicsAPI.MECH_CAPABILITY && (facing == null || this.getFacing().func_176740_k() != facing.func_176740_k())) {
            return (T)this.capability;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            this.lastAngle = this.angle;
            this.angle += this.capability.getPower(null);
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                ItemStack gear = this.getGear(facing);
                IGearBehavior behavior = MysticalMechanicsAPI.IMPL.getGearBehavior(gear);
                behavior.visualUpdate((TileEntity)this, facing, gear);
            }
        }
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (!heldItem.func_190926_b() && this.canAttachGear(side, heldItem)) {
            if (this.getGear(side).func_190926_b() && MysticalMechanicsAPI.IMPL.isValidGear(heldItem)) {
                ItemStack gear = heldItem.func_77946_l();
                gear.func_190920_e(1);
                this.attachGear(side, gear);
                heldItem.func_190918_g(1);
                if (heldItem.func_190926_b()) {
                    player.func_184611_a(hand, ItemStack.field_190927_a);
                }
                this.capability.onPowerChange();
                return true;
            }
        } else if (!this.getGear(side).func_190926_b()) {
            ItemStack gear = this.detachGear(side);
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)new EntityItem(world, player.field_70165_t, player.field_70163_u + (double)(player.field_70131_O / 2.0f), player.field_70161_v, gear));
            }
            this.capability.onPowerChange();
            return true;
        }
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        for (int i = 0; i < 6; ++i) {
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, this.gears[i]));
            }
            this.gears[i] = ItemStack.field_190927_a;
        }
        this.capability.setPower(0.0, null);
        this.updateNeighbors();
    }

    public void func_70296_d() {
        super.func_70296_d();
        Misc.syncTE(this);
    }

    public void attachGear(EnumFacing facing, ItemStack stack) {
        if (facing == null) {
            return;
        }
        this.gears[facing.func_176745_a()] = stack;
        this.func_70296_d();
    }

    public ItemStack detachGear(EnumFacing facing) {
        if (facing == null || this.getFacing().func_176740_k() == facing.func_176740_k()) {
            return ItemStack.field_190927_a;
        }
        int index = facing.func_176745_a();
        ItemStack gear = this.gears[index];
        this.gears[index] = ItemStack.field_190927_a;
        this.func_70296_d();
        return gear;
    }

    public ItemStack getGear(EnumFacing facing) {
        if (facing == null || this.getFacing().func_176740_k() == facing.func_176740_k()) {
            return ItemStack.field_190927_a;
        }
        return this.gears[facing.func_176745_a()];
    }

    public boolean canAttachGear(EnumFacing facing, ItemStack stack) {
        return this.getFacing().func_176740_k() != facing.func_176740_k();
    }

    public int getConnections() {
        return 1;
    }

    @Override
    public boolean hasCapabilityDescription(Capability<?> capability) {
        return false;
    }

    @Override
    public void addCapabilityDescription(List<String> strings, Capability<?> capability, EnumFacing facing) {
    }
}

