/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.server.fastener;

import com.pau101.fairylights.server.fastener.accessor.FastenerAccessor;
import com.pau101.fairylights.server.fastener.connection.ConnectionType;
import com.pau101.fairylights.server.fastener.connection.type.Connection;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;

public interface Fastener<F extends FastenerAccessor>
extends ICapabilitySerializable<NBTTagCompound> {
    public NBTTagCompound serializeNBT();

    public Map<UUID, Connection> getConnections();

    default public Connection getFirstConnection() {
        return this.getConnections().values().stream().findFirst().orElse(null);
    }

    public AxisAlignedBB getBounds();

    public Vec3d getConnectionPoint();

    public BlockPos getPos();

    public EnumFacing getFacing();

    public void setWorld(World var1);

    @Nullable
    public World getWorld();

    public F createAccessor();

    public boolean isMoving();

    default public void resistSnap(Vec3d from) {
    }

    public boolean update();

    public void setDirty();

    public boolean shouldDropConnection();

    public void dropItems(World var1, BlockPos var2);

    public void remove();

    public boolean hasNoConnections();

    public boolean hasConnectionWith(Fastener<?> var1);

    @Nullable
    public Connection getConnectionTo(FastenerAccessor var1);

    public boolean removeConnection(UUID var1);

    public boolean removeConnection(Connection var1);

    public boolean removeConnectionImmediately(UUID var1);

    public boolean removeConnectionImmediately(Connection var1);

    @Nullable
    public Connection reconnect(Fastener<?> var1, Fastener<?> var2);

    public Connection connectWith(World var1, Fastener<?> var2, ConnectionType var3, NBTTagCompound var4);

    public Connection createConnection(World var1, UUID var2, Fastener<?> var3, ConnectionType var4, boolean var5, NBTTagCompound var6);
}

