/*
 * Decompiled with CFR 0.152.
 */
package com.pau101.fairylights.server.fastener;

import com.pau101.fairylights.server.capability.CapabilityHandler;
import com.pau101.fairylights.server.fastener.Fastener;
import com.pau101.fairylights.server.fastener.accessor.FastenerAccessor;
import com.pau101.fairylights.server.fastener.connection.Catenary;
import com.pau101.fairylights.server.fastener.connection.ConnectionType;
import com.pau101.fairylights.server.fastener.connection.Segment;
import com.pau101.fairylights.server.fastener.connection.type.Connection;
import com.pau101.fairylights.util.AABBBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public abstract class FastenerDefault<F extends FastenerAccessor>
implements Fastener<F> {
    protected Map<UUID, Connection> connections = new HashMap<UUID, Connection>();
    protected AxisAlignedBB bounds = TileEntity.INFINITE_EXTENT_AABB;
    @Nullable
    private World world;
    private boolean isDirty;

    @Override
    public Map<UUID, Connection> getConnections() {
        return this.connections;
    }

    @Override
    public AxisAlignedBB getBounds() {
        return this.bounds;
    }

    @Override
    public abstract BlockPos getPos();

    @Override
    public void setWorld(World world) {
        this.world = world;
        this.connections.values().forEach(c -> c.setWorld(world));
    }

    @Override
    @Nullable
    public World getWorld() {
        return this.world;
    }

    @Override
    public boolean update() {
        Iterator<Connection> connectionIterator = this.connections.values().iterator();
        Vec3d fromOffset = this.getConnectionPoint();
        boolean catenaryChange = false;
        boolean dataChange = this.isDirty;
        this.isDirty = false;
        while (connectionIterator.hasNext()) {
            Connection connection = connectionIterator.next();
            connection.update(fromOffset);
            catenaryChange |= connection.pollCateneryUpdate();
            dataChange |= connection.pollDataUpdate();
            if (!connection.shouldDisconnect()) continue;
            dataChange = true;
            catenaryChange = true;
            connection.remove();
            connectionIterator.remove();
        }
        if (catenaryChange) {
            this.calculateBoundingBox();
        }
        return dataChange;
    }

    @Override
    public void setDirty() {
        this.isDirty = true;
    }

    protected void calculateBoundingBox() {
        AABBBuilder builder = new AABBBuilder();
        for (Connection connection : this.connections.values()) {
            Catenary catenary = connection.getCatenary();
            if (catenary == null) continue;
            Segment[] segments = catenary.getSegments();
            for (int i = 0; i < segments.length; ++i) {
                Segment segment = segments[i];
                builder.include(segment.getStart().func_186678_a(0.0625));
            }
            builder.include(segments[segments.length - 1].getEnd().func_186678_a(0.0625));
        }
        this.bounds = builder.add(this.getConnectionPoint()).build();
    }

    @Override
    public boolean shouldDropConnection() {
        return true;
    }

    @Override
    public void dropItems(World world, BlockPos pos) {
        float offsetX = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
        float offsetY = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
        float offsetZ = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
        for (Connection connection : this.connections.values()) {
            if (!connection.shouldDrop()) continue;
            ItemStack stack = connection.getItemStack();
            EntityItem entityItem = new EntityItem(world, (double)((float)pos.func_177958_n() + offsetX), (double)((float)pos.func_177956_o() + offsetY), (double)((float)pos.func_177952_p() + offsetZ), stack);
            float scale = 0.05f;
            entityItem.field_70159_w = world.field_73012_v.nextGaussian() * (double)scale;
            entityItem.field_70181_x = world.field_73012_v.nextGaussian() * (double)scale + (double)0.2f;
            entityItem.field_70179_y = world.field_73012_v.nextGaussian() * (double)scale;
            world.func_72838_d((Entity)entityItem);
        }
    }

    @Override
    public void remove() {
        this.connections.values().forEach(Connection::remove);
    }

    @Override
    public boolean hasNoConnections() {
        return this.connections.isEmpty();
    }

    @Override
    public boolean hasConnectionWith(Fastener<?> fastener) {
        return this.getConnectionTo((FastenerAccessor)fastener.createAccessor()) != null;
    }

    @Override
    @Nullable
    public Connection getConnectionTo(FastenerAccessor destination) {
        for (Connection connection : this.connections.values()) {
            if (!connection.isDestination(destination)) continue;
            return connection;
        }
        return null;
    }

    @Override
    public boolean removeConnection(UUID uuid) {
        return this.removeConnection(this.connections.get(uuid));
    }

    @Override
    public boolean removeConnection(Connection connection) {
        if (connection != null) {
            connection.forceRemove = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean removeConnectionImmediately(UUID uuid) {
        Connection connection = this.connections.remove(uuid);
        if (connection == null) {
            return false;
        }
        connection.remove();
        this.calculateBoundingBox();
        this.setDirty();
        return true;
    }

    @Override
    public boolean removeConnectionImmediately(Connection connection) {
        return this.removeConnectionImmediately(connection.getUUID());
    }

    @Override
    public Connection reconnect(Fastener<?> oldDestination, Fastener<?> newDestination) {
        for (Map.Entry<UUID, Connection> entry : this.connections.entrySet()) {
            Connection connection = entry.getValue();
            if (!connection.getDestination().isLoaded(this.world) || !connection.getDestination().get(this.world).equals(oldDestination)) continue;
            if (connection.getFastener().equals(newDestination) || newDestination.hasConnectionWith(connection.getFastener())) {
                return null;
            }
            UUID uuid = entry.getKey();
            oldDestination.removeConnectionImmediately(uuid);
            connection.setDestination(newDestination);
            Connection other = newDestination.createConnection(this.world, uuid, this, connection.getType(), !connection.isOrigin(), connection.serializeLogic());
            newDestination.getConnections().put(uuid, other);
            return connection;
        }
        return null;
    }

    @Override
    public Connection connectWith(World world, Fastener<?> destination, ConnectionType type, NBTTagCompound compound) {
        UUID uuid = MathHelper.func_188210_a();
        this.connections.put(uuid, this.createConnection(world, uuid, destination, type, true, compound));
        Connection c = destination.createConnection(world, uuid, this, type, false, compound);
        destination.getConnections().put(uuid, c);
        return c;
    }

    @Override
    public Connection createConnection(World world, UUID uuid, Fastener<?> destination, ConnectionType type, boolean isOrigin, NBTTagCompound compound) {
        return type.createConnection(world, this, uuid, destination, isOrigin, compound);
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        NBTTagList listConnections = new NBTTagList();
        for (Map.Entry<UUID, Connection> connectionEntry : this.connections.entrySet()) {
            UUID uuid = connectionEntry.getKey();
            Connection connection = connectionEntry.getValue();
            NBTTagCompound connectionCompound = new NBTTagCompound();
            connectionCompound.func_74782_a("connection", (NBTBase)connection.serialize());
            connectionCompound.func_74774_a("type", (byte)connection.getType().ordinal());
            connectionCompound.func_74782_a("uuid", (NBTBase)NBTUtil.func_186862_a((UUID)uuid));
            listConnections.func_74742_a((NBTBase)connectionCompound);
        }
        compound.func_74782_a("connections", (NBTBase)listConnections);
        return compound;
    }

    public void deserializeNBT(NBTTagCompound compound) {
        if (!compound.func_150297_b("connections", 9)) {
            return;
        }
        NBTTagList listConnections = compound.func_150295_c("connections", 10);
        ArrayList<UUID> nbtUUIDs = new ArrayList<UUID>();
        for (int i = 0; i < listConnections.func_74745_c(); ++i) {
            Connection connection;
            NBTTagCompound connectionCompound = listConnections.func_150305_b(i);
            UUID uuid = connectionCompound.func_150297_b("uuid", 10) ? NBTUtil.func_186860_b((NBTTagCompound)connectionCompound.func_74775_l("uuid")) : MathHelper.func_188210_a();
            nbtUUIDs.add(uuid);
            if (this.connections.containsKey(uuid)) {
                connection = this.connections.get(uuid);
            } else {
                ConnectionType type = ConnectionType.from(connectionCompound.func_74771_c("type"));
                connection = type.createConnection(this.world, this, uuid);
                this.connections.put(uuid, connection);
            }
            connection.deserialize(connectionCompound.func_74775_l("connection"));
        }
        Iterator<Map.Entry<UUID, Connection>> connectionsIter = this.connections.entrySet().iterator();
        while (connectionsIter.hasNext()) {
            Map.Entry<UUID, Connection> connection = connectionsIter.next();
            if (nbtUUIDs.contains(connection.getKey())) continue;
            connectionsIter.remove();
            connection.getValue().remove();
        }
        if (this.world != null) {
            for (Connection connection : this.connections.values()) {
                connection.updateCatenary(this.getConnectionPoint());
            }
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityHandler.FASTENER_CAP;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)(this.hasCapability(capability, facing) ? CapabilityHandler.FASTENER_CAP.cast((Object)this) : null);
    }
}

